// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2013 Raritan Inc. All rights reserved.

package com.raritan.util;

public class StringUtils {
    private StringUtils() {
    }

    public static boolean stringsEqual(String s1, String s2) {
        if (s1 == null && s2 == null) {
            return true;
        }
        if (s1 == null && s2 != null) {
            return false;
        }
        if (s1 != null && s2 == null) {
            return false;
        }
        return s1.equals(s2);
    }

    public static String join(String[] s, String delimiter) {
        if (s == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < s.length; i++) {
            if (i > 0) {
                builder.append(delimiter);
            }
            builder.append(s[i]);
        }
        return builder.toString();
    }
}
