// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2025 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from ZigbeeManager.idl.

package com.raritan.json_rpc.zigbee;

import org.json.*;

import com.raritan.idl.*;
import com.raritan.json_rpc.*;
import com.raritan.util.AsyncRequest;

public class ZigbeeManager_Proxy extends ObjectProxy implements com.raritan.idl.zigbee.ZigbeeManager {

  public ZigbeeManager_Proxy(Agent agent, String rid, TypeInfo typeInfo) {
    super(agent, rid, typeInfo);
  }

  public ZigbeeManager_Proxy(Agent agent, String rid) {
    this(agent, rid, com.raritan.idl.zigbee.ZigbeeManager.typeInfo);
  }

  public static ZigbeeManager_Proxy staticCast(ObjectProxy proxy) {
    return proxy == null ? null : new ZigbeeManager_Proxy(proxy.getAgent(), proxy.getRid(), proxy.getStaticTypeInfo());
  }


  @Override
  public GetMetaDataResult getMetaData() throws Exception {
    JSONObject params = null;
    final JSONObject result = rpcCall("getMetaData", params);
    GetMetaDataResult ret = new GetMetaDataResult();
    ret._ret_ = com.raritan.json_rpc.zigbee.ZigbeeManager.MetaData_Codec.decode(result.getJSONObject("_ret_"), agent);
    return ret;
  }

  @Override
  public AsyncRequest getMetaData(final AsyncRpcResponse<GetMetaDataResult> rsp) {
    return getMetaData(rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest getMetaData(final AsyncRpcResponse<GetMetaDataResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = null;
    return rpcCall("getMetaData", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          GetMetaDataResult ret = new GetMetaDataResult();
          ret._ret_ = com.raritan.json_rpc.zigbee.ZigbeeManager.MetaData_Codec.decode(result.getJSONObject("_ret_"), agent);
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public GetDongleStateResult getDongleState() throws Exception {
    JSONObject params = null;
    final JSONObject result = rpcCall("getDongleState", params);
    GetDongleStateResult ret = new GetDongleStateResult();
    ret._ret_ = com.raritan.json_rpc.zigbee.ZigbeeManager.DongleState_Codec.decode(result.getInt("_ret_"));
    return ret;
  }

  @Override
  public AsyncRequest getDongleState(final AsyncRpcResponse<GetDongleStateResult> rsp) {
    return getDongleState(rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest getDongleState(final AsyncRpcResponse<GetDongleStateResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = null;
    return rpcCall("getDongleState", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          GetDongleStateResult ret = new GetDongleStateResult();
          ret._ret_ = com.raritan.json_rpc.zigbee.ZigbeeManager.DongleState_Codec.decode(result.getInt("_ret_"));
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public GetSettingsResult getSettings() throws Exception {
    JSONObject params = null;
    final JSONObject result = rpcCall("getSettings", params);
    GetSettingsResult ret = new GetSettingsResult();
    ret._ret_ = com.raritan.json_rpc.zigbee.ZigbeeManager.Settings_Codec.decode(result.getJSONObject("_ret_"), agent);
    return ret;
  }

  @Override
  public AsyncRequest getSettings(final AsyncRpcResponse<GetSettingsResult> rsp) {
    return getSettings(rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest getSettings(final AsyncRpcResponse<GetSettingsResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = null;
    return rpcCall("getSettings", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          GetSettingsResult ret = new GetSettingsResult();
          ret._ret_ = com.raritan.json_rpc.zigbee.ZigbeeManager.Settings_Codec.decode(result.getJSONObject("_ret_"), agent);
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public SetSettingsResult setSettings(final com.raritan.idl.zigbee.ZigbeeManager.Settings settings) throws Exception {
    JSONObject params = new JSONObject();
    params.put("settings", com.raritan.json_rpc.zigbee.ZigbeeManager.Settings_Codec.encode(settings));
    final JSONObject result = rpcCall("setSettings", params);
    SetSettingsResult ret = new SetSettingsResult();
    ret._ret_ = result.getInt("_ret_");
    return ret;
  }

  @Override
  public AsyncRequest setSettings(final com.raritan.idl.zigbee.ZigbeeManager.Settings settings, final AsyncRpcResponse<SetSettingsResult> rsp) {
    return setSettings(settings, rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest setSettings(final com.raritan.idl.zigbee.ZigbeeManager.Settings settings, final AsyncRpcResponse<SetSettingsResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = new JSONObject();
    try {
      params.put("settings", com.raritan.json_rpc.zigbee.ZigbeeManager.Settings_Codec.encode(settings));
    } catch (Exception e) {
      rsp.onFailure(e);
    }
    return rpcCall("setSettings", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          SetSettingsResult ret = new SetSettingsResult();
          ret._ret_ = result.getInt("_ret_");
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public AddDevicesResult addDevices(final java.util.List<com.raritan.idl.zigbee.ZigbeeManager.DeviceRegistration> sensors) throws Exception {
    JSONObject params = new JSONObject();
    params.put("sensors", new JSONArray() {{
      final java.util.List<com.raritan.idl.zigbee.ZigbeeManager.DeviceRegistration> array0 = sensors;
      for (int i0 = 0; i0 < array0.size(); i0++) {
        final int i0_f = i0;
        this.put(com.raritan.json_rpc.zigbee.ZigbeeManager.DeviceRegistration_Codec.encode(array0.get(i0_f)));
      }
    }});
    final JSONObject result = rpcCall("addDevices", params);
    AddDevicesResult ret = new AddDevicesResult();
    ret._ret_ = new java.util.ArrayList<Integer>() {
      private static final long serialVersionUID = 1L;
      {
        final JSONArray array0 = result.getJSONArray("_ret_");
        for (int i0 = 0; i0 < array0.length(); i0++) {
          final int i0_f = i0;
          this.add(array0.getInt(i0_f));
        }
      }
    };
    return ret;
  }

  @Override
  public AsyncRequest addDevices(final java.util.List<com.raritan.idl.zigbee.ZigbeeManager.DeviceRegistration> sensors, final AsyncRpcResponse<AddDevicesResult> rsp) {
    return addDevices(sensors, rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest addDevices(final java.util.List<com.raritan.idl.zigbee.ZigbeeManager.DeviceRegistration> sensors, final AsyncRpcResponse<AddDevicesResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = new JSONObject();
    try {
      params.put("sensors", new JSONArray() {{
        final java.util.List<com.raritan.idl.zigbee.ZigbeeManager.DeviceRegistration> array0 = sensors;
        for (int i0 = 0; i0 < array0.size(); i0++) {
          final int i0_f = i0;
          this.put(com.raritan.json_rpc.zigbee.ZigbeeManager.DeviceRegistration_Codec.encode(array0.get(i0_f)));
        }
      }});
    } catch (Exception e) {
      rsp.onFailure(e);
    }
    return rpcCall("addDevices", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          AddDevicesResult ret = new AddDevicesResult();
          ret._ret_ = new java.util.ArrayList<Integer>() {
            private static final long serialVersionUID = 1L;
            {
              final JSONArray array0 = result.getJSONArray("_ret_");
              for (int i0 = 0; i0 < array0.length(); i0++) {
                final int i0_f = i0;
                this.add(array0.getInt(i0_f));
              }
            }
          };
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public RemoveDeviceResult removeDevice(final int sourceId) throws Exception {
    JSONObject params = new JSONObject();
    params.put("sourceId", sourceId);
    final JSONObject result = rpcCall("removeDevice", params);
    RemoveDeviceResult ret = new RemoveDeviceResult();
    ret._ret_ = result.getInt("_ret_");
    return ret;
  }

  @Override
  public AsyncRequest removeDevice(final int sourceId, final AsyncRpcResponse<RemoveDeviceResult> rsp) {
    return removeDevice(sourceId, rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest removeDevice(final int sourceId, final AsyncRpcResponse<RemoveDeviceResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = new JSONObject();
    try {
      params.put("sourceId", sourceId);
    } catch (Exception e) {
      rsp.onFailure(e);
    }
    return rpcCall("removeDevice", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          RemoveDeviceResult ret = new RemoveDeviceResult();
          ret._ret_ = result.getInt("_ret_");
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public GetRegisteredDevicesResult getRegisteredDevices() throws Exception {
    JSONObject params = null;
    final JSONObject result = rpcCall("getRegisteredDevices", params);
    GetRegisteredDevicesResult ret = new GetRegisteredDevicesResult();
    ret._ret_ = new java.util.ArrayList<com.raritan.idl.zigbee.ZigbeeDevice>() {
      private static final long serialVersionUID = 1L;
      {
        final JSONArray array0 = result.getJSONArray("_ret_");
        for (int i0 = 0; i0 < array0.length(); i0++) {
          final int i0_f = i0;
          this.add(com.raritan.json_rpc.zigbee.ZigbeeDevice_Proxy.staticCast(ObjectProxy.decode((array0.isNull(i0_f) ? null : array0.getJSONObject(i0_f)), agent)));
        }
      }
    };
    return ret;
  }

  @Override
  public AsyncRequest getRegisteredDevices(final AsyncRpcResponse<GetRegisteredDevicesResult> rsp) {
    return getRegisteredDevices(rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest getRegisteredDevices(final AsyncRpcResponse<GetRegisteredDevicesResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = null;
    return rpcCall("getRegisteredDevices", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          GetRegisteredDevicesResult ret = new GetRegisteredDevicesResult();
          ret._ret_ = new java.util.ArrayList<com.raritan.idl.zigbee.ZigbeeDevice>() {
            private static final long serialVersionUID = 1L;
            {
              final JSONArray array0 = result.getJSONArray("_ret_");
              for (int i0 = 0; i0 < array0.length(); i0++) {
                final int i0_f = i0;
                this.add(com.raritan.json_rpc.zigbee.ZigbeeDevice_Proxy.staticCast(ObjectProxy.decode((array0.isNull(i0_f) ? null : array0.getJSONObject(i0_f)), agent)));
              }
            }
          };
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }
}
