// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2025 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from UserManager.idl.

package com.raritan.json_rpc.usermgmt;

import org.json.*;

import com.raritan.idl.*;
import com.raritan.json_rpc.*;
import com.raritan.util.AsyncRequest;

public class UserManager_1_0_4_Proxy extends ObjectProxy implements com.raritan.idl.usermgmt.UserManager_1_0_4 {

  public UserManager_1_0_4_Proxy(Agent agent, String rid, TypeInfo typeInfo) {
    super(agent, rid, typeInfo);
  }

  public UserManager_1_0_4_Proxy(Agent agent, String rid) {
    this(agent, rid, com.raritan.idl.usermgmt.UserManager_1_0_4.typeInfo);
  }

  public static UserManager_1_0_4_Proxy staticCast(ObjectProxy proxy) {
    return proxy == null ? null : new UserManager_1_0_4_Proxy(proxy.getAgent(), proxy.getRid(), proxy.getStaticTypeInfo());
  }


  @Override
  public GetAccountNamesResult getAccountNames() throws Exception {
    JSONObject params = null;
    final JSONObject result = rpcCall("getAccountNames", params);
    GetAccountNamesResult ret = new GetAccountNamesResult();
    ret._ret_ = new java.util.ArrayList<String>() {
      private static final long serialVersionUID = 1L;
      {
        final JSONArray array0 = result.getJSONArray("_ret_");
        for (int i0 = 0; i0 < array0.length(); i0++) {
          final int i0_f = i0;
          this.add(array0.getString(i0_f));
        }
      }
    };
    return ret;
  }

  @Override
  public AsyncRequest getAccountNames(final AsyncRpcResponse<GetAccountNamesResult> rsp) {
    return getAccountNames(rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest getAccountNames(final AsyncRpcResponse<GetAccountNamesResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = null;
    return rpcCall("getAccountNames", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          GetAccountNamesResult ret = new GetAccountNamesResult();
          ret._ret_ = new java.util.ArrayList<String>() {
            private static final long serialVersionUID = 1L;
            {
              final JSONArray array0 = result.getJSONArray("_ret_");
              for (int i0 = 0; i0 < array0.length(); i0++) {
                final int i0_f = i0;
                this.add(array0.getString(i0_f));
              }
            }
          };
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public CreateAccountResult createAccount(final String username, final String password) throws Exception {
    JSONObject params = new JSONObject();
    params.put("username", username);
    params.put("password", password);
    final JSONObject result = rpcCall("createAccount", params);
    CreateAccountResult ret = new CreateAccountResult();
    ret._ret_ = result.getInt("_ret_");
    return ret;
  }

  @Override
  public AsyncRequest createAccount(final String username, final String password, final AsyncRpcResponse<CreateAccountResult> rsp) {
    return createAccount(username, password, rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest createAccount(final String username, final String password, final AsyncRpcResponse<CreateAccountResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = new JSONObject();
    try {
      params.put("username", username);
      params.put("password", password);
    } catch (Exception e) {
      rsp.onFailure(e);
    }
    return rpcCall("createAccount", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          CreateAccountResult ret = new CreateAccountResult();
          ret._ret_ = result.getInt("_ret_");
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public DeleteAccountResult deleteAccount(final String username) throws Exception {
    JSONObject params = new JSONObject();
    params.put("username", username);
    final JSONObject result = rpcCall("deleteAccount", params);
    DeleteAccountResult ret = new DeleteAccountResult();
    ret._ret_ = result.getInt("_ret_");
    return ret;
  }

  @Override
  public AsyncRequest deleteAccount(final String username, final AsyncRpcResponse<DeleteAccountResult> rsp) {
    return deleteAccount(username, rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest deleteAccount(final String username, final AsyncRpcResponse<DeleteAccountResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = new JSONObject();
    try {
      params.put("username", username);
    } catch (Exception e) {
      rsp.onFailure(e);
    }
    return rpcCall("deleteAccount", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          DeleteAccountResult ret = new DeleteAccountResult();
          ret._ret_ = result.getInt("_ret_");
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public GetAllAccountsResult getAllAccounts() throws Exception {
    JSONObject params = null;
    final JSONObject result = rpcCall("getAllAccounts", params);
    GetAllAccountsResult ret = new GetAllAccountsResult();
    ret._ret_ = new java.util.ArrayList<com.raritan.idl.usermgmt.Account>() {
      private static final long serialVersionUID = 1L;
      {
        final JSONArray array0 = result.getJSONArray("_ret_");
        for (int i0 = 0; i0 < array0.length(); i0++) {
          final int i0_f = i0;
          this.add(com.raritan.json_rpc.usermgmt.Account_Codec.decode(array0.getJSONObject(i0_f), agent));
        }
      }
    };
    return ret;
  }

  @Override
  public AsyncRequest getAllAccounts(final AsyncRpcResponse<GetAllAccountsResult> rsp) {
    return getAllAccounts(rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest getAllAccounts(final AsyncRpcResponse<GetAllAccountsResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = null;
    return rpcCall("getAllAccounts", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          GetAllAccountsResult ret = new GetAllAccountsResult();
          ret._ret_ = new java.util.ArrayList<com.raritan.idl.usermgmt.Account>() {
            private static final long serialVersionUID = 1L;
            {
              final JSONArray array0 = result.getJSONArray("_ret_");
              for (int i0 = 0; i0 < array0.length(); i0++) {
                final int i0_f = i0;
                this.add(com.raritan.json_rpc.usermgmt.Account_Codec.decode(array0.getJSONObject(i0_f), agent));
              }
            }
          };
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public CreateAccountFullResult createAccountFull(final String username, final String password, final com.raritan.idl.usermgmt.UserInfo info) throws Exception {
    JSONObject params = new JSONObject();
    params.put("username", username);
    params.put("password", password);
    params.put("info", com.raritan.json_rpc.usermgmt.UserInfo_Codec.encode(info));
    final JSONObject result = rpcCall("createAccountFull", params);
    CreateAccountFullResult ret = new CreateAccountFullResult();
    ret._ret_ = result.getInt("_ret_");
    return ret;
  }

  @Override
  public AsyncRequest createAccountFull(final String username, final String password, final com.raritan.idl.usermgmt.UserInfo info, final AsyncRpcResponse<CreateAccountFullResult> rsp) {
    return createAccountFull(username, password, info, rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest createAccountFull(final String username, final String password, final com.raritan.idl.usermgmt.UserInfo info, final AsyncRpcResponse<CreateAccountFullResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = new JSONObject();
    try {
      params.put("username", username);
      params.put("password", password);
      params.put("info", com.raritan.json_rpc.usermgmt.UserInfo_Codec.encode(info));
    } catch (Exception e) {
      rsp.onFailure(e);
    }
    return rpcCall("createAccountFull", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          CreateAccountFullResult ret = new CreateAccountFullResult();
          ret._ret_ = result.getInt("_ret_");
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public GetAccountsByRoleResult getAccountsByRole(final String roleName) throws Exception {
    JSONObject params = new JSONObject();
    params.put("roleName", roleName);
    final JSONObject result = rpcCall("getAccountsByRole", params);
    GetAccountsByRoleResult ret = new GetAccountsByRoleResult();
    ret._ret_ = new java.util.ArrayList<com.raritan.idl.usermgmt.Account>() {
      private static final long serialVersionUID = 1L;
      {
        final JSONArray array0 = result.getJSONArray("_ret_");
        for (int i0 = 0; i0 < array0.length(); i0++) {
          final int i0_f = i0;
          this.add(com.raritan.json_rpc.usermgmt.Account_Codec.decode(array0.getJSONObject(i0_f), agent));
        }
      }
    };
    return ret;
  }

  @Override
  public AsyncRequest getAccountsByRole(final String roleName, final AsyncRpcResponse<GetAccountsByRoleResult> rsp) {
    return getAccountsByRole(roleName, rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest getAccountsByRole(final String roleName, final AsyncRpcResponse<GetAccountsByRoleResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = new JSONObject();
    try {
      params.put("roleName", roleName);
    } catch (Exception e) {
      rsp.onFailure(e);
    }
    return rpcCall("getAccountsByRole", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          GetAccountsByRoleResult ret = new GetAccountsByRoleResult();
          ret._ret_ = new java.util.ArrayList<com.raritan.idl.usermgmt.Account>() {
            private static final long serialVersionUID = 1L;
            {
              final JSONArray array0 = result.getJSONArray("_ret_");
              for (int i0 = 0; i0 < array0.length(); i0++) {
                final int i0_f = i0;
                this.add(com.raritan.json_rpc.usermgmt.Account_Codec.decode(array0.getJSONObject(i0_f), agent));
              }
            }
          };
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public GetDefaultPreferencesResult getDefaultPreferences() throws Exception {
    JSONObject params = null;
    final JSONObject result = rpcCall("getDefaultPreferences", params);
    GetDefaultPreferencesResult ret = new GetDefaultPreferencesResult();
    ret._ret_ = com.raritan.json_rpc.usermgmt.Preferences_Codec.decode(result.getJSONObject("_ret_"), agent);
    return ret;
  }

  @Override
  public AsyncRequest getDefaultPreferences(final AsyncRpcResponse<GetDefaultPreferencesResult> rsp) {
    return getDefaultPreferences(rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest getDefaultPreferences(final AsyncRpcResponse<GetDefaultPreferencesResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = null;
    return rpcCall("getDefaultPreferences", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          GetDefaultPreferencesResult ret = new GetDefaultPreferencesResult();
          ret._ret_ = com.raritan.json_rpc.usermgmt.Preferences_Codec.decode(result.getJSONObject("_ret_"), agent);
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public SetDefaultPreferencesResult setDefaultPreferences(final com.raritan.idl.usermgmt.Preferences prefs) throws Exception {
    JSONObject params = new JSONObject();
    params.put("prefs", com.raritan.json_rpc.usermgmt.Preferences_Codec.encode(prefs));
    final JSONObject result = rpcCall("setDefaultPreferences", params);
    SetDefaultPreferencesResult ret = new SetDefaultPreferencesResult();
    ret._ret_ = result.getInt("_ret_");
    return ret;
  }

  @Override
  public AsyncRequest setDefaultPreferences(final com.raritan.idl.usermgmt.Preferences prefs, final AsyncRpcResponse<SetDefaultPreferencesResult> rsp) {
    return setDefaultPreferences(prefs, rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest setDefaultPreferences(final com.raritan.idl.usermgmt.Preferences prefs, final AsyncRpcResponse<SetDefaultPreferencesResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = new JSONObject();
    try {
      params.put("prefs", com.raritan.json_rpc.usermgmt.Preferences_Codec.encode(prefs));
    } catch (Exception e) {
      rsp.onFailure(e);
    }
    return rpcCall("setDefaultPreferences", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          SetDefaultPreferencesResult ret = new SetDefaultPreferencesResult();
          ret._ret_ = result.getInt("_ret_");
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }
}
