// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2025 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from PeripheralG2Production.idl.

package com.raritan.json_rpc.peripheral;

import org.json.*;

import com.raritan.idl.*;
import com.raritan.json_rpc.*;
import com.raritan.util.AsyncRequest;

public class G2Production_3_0_0_Proxy extends ObjectProxy implements com.raritan.idl.peripheral.G2Production_3_0_0 {

  public G2Production_3_0_0_Proxy(Agent agent, String rid, TypeInfo typeInfo) {
    super(agent, rid, typeInfo);
  }

  public G2Production_3_0_0_Proxy(Agent agent, String rid) {
    this(agent, rid, com.raritan.idl.peripheral.G2Production_3_0_0.typeInfo);
  }

  public static G2Production_3_0_0_Proxy staticCast(ObjectProxy proxy) {
    return proxy == null ? null : new G2Production_3_0_0_Proxy(proxy.getAgent(), proxy.getRid(), proxy.getStaticTypeInfo());
  }


  @Override
  public UpdateFirmwareResult updateFirmware(final String romcode, final String firmware) throws Exception {
    JSONObject params = new JSONObject();
    params.put("romcode", romcode);
    params.put("firmware", firmware);
    final JSONObject result = rpcCall("updateFirmware", params);
    UpdateFirmwareResult ret = new UpdateFirmwareResult();
    ret._ret_ = result.getInt("_ret_");
    return ret;
  }

  @Override
  public AsyncRequest updateFirmware(final String romcode, final String firmware, final AsyncRpcResponse<UpdateFirmwareResult> rsp) {
    return updateFirmware(romcode, firmware, rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest updateFirmware(final String romcode, final String firmware, final AsyncRpcResponse<UpdateFirmwareResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = new JSONObject();
    try {
      params.put("romcode", romcode);
      params.put("firmware", firmware);
    } catch (Exception e) {
      rsp.onFailure(e);
    }
    return rpcCall("updateFirmware", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          UpdateFirmwareResult ret = new UpdateFirmwareResult();
          ret._ret_ = result.getInt("_ret_");
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public UpdateFirmwarePosResult updateFirmwarePos(final java.util.List<com.raritan.idl.peripheral.PosElement> position, final String firmware) throws Exception {
    JSONObject params = new JSONObject();
    params.put("position", new JSONArray() {{
      final java.util.List<com.raritan.idl.peripheral.PosElement> array0 = position;
      for (int i0 = 0; i0 < array0.size(); i0++) {
        final int i0_f = i0;
        this.put(com.raritan.json_rpc.peripheral.PosElement_Codec.encode(array0.get(i0_f)));
      }
    }});
    params.put("firmware", firmware);
    final JSONObject result = rpcCall("updateFirmwarePos", params);
    UpdateFirmwarePosResult ret = new UpdateFirmwarePosResult();
    ret._ret_ = result.getInt("_ret_");
    return ret;
  }

  @Override
  public AsyncRequest updateFirmwarePos(final java.util.List<com.raritan.idl.peripheral.PosElement> position, final String firmware, final AsyncRpcResponse<UpdateFirmwarePosResult> rsp) {
    return updateFirmwarePos(position, firmware, rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest updateFirmwarePos(final java.util.List<com.raritan.idl.peripheral.PosElement> position, final String firmware, final AsyncRpcResponse<UpdateFirmwarePosResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = new JSONObject();
    try {
      params.put("position", new JSONArray() {{
        final java.util.List<com.raritan.idl.peripheral.PosElement> array0 = position;
        for (int i0 = 0; i0 < array0.size(); i0++) {
          final int i0_f = i0;
          this.put(com.raritan.json_rpc.peripheral.PosElement_Codec.encode(array0.get(i0_f)));
        }
      }});
      params.put("firmware", firmware);
    } catch (Exception e) {
      rsp.onFailure(e);
    }
    return rpcCall("updateFirmwarePos", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          UpdateFirmwarePosResult ret = new UpdateFirmwarePosResult();
          ret._ret_ = result.getInt("_ret_");
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public GetFirmwareInfoResult getFirmwareInfo(final String romcode) throws Exception {
    JSONObject params = new JSONObject();
    params.put("romcode", romcode);
    final JSONObject result = rpcCall("getFirmwareInfo", params);
    GetFirmwareInfoResult ret = new GetFirmwareInfoResult();
    ret._ret_ = result.getInt("_ret_");
    ret.info = com.raritan.json_rpc.peripheral.G2Production_3_0_0.FirmwareInfo_Codec.decode(result.getJSONObject("info"), agent);
    return ret;
  }

  @Override
  public AsyncRequest getFirmwareInfo(final String romcode, final AsyncRpcResponse<GetFirmwareInfoResult> rsp) {
    return getFirmwareInfo(romcode, rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest getFirmwareInfo(final String romcode, final AsyncRpcResponse<GetFirmwareInfoResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = new JSONObject();
    try {
      params.put("romcode", romcode);
    } catch (Exception e) {
      rsp.onFailure(e);
    }
    return rpcCall("getFirmwareInfo", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          GetFirmwareInfoResult ret = new GetFirmwareInfoResult();
          ret._ret_ = result.getInt("_ret_");
          ret.info = com.raritan.json_rpc.peripheral.G2Production_3_0_0.FirmwareInfo_Codec.decode(result.getJSONObject("info"), agent);
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public GetFirmwareInfoPosResult getFirmwareInfoPos(final java.util.List<com.raritan.idl.peripheral.PosElement> position) throws Exception {
    JSONObject params = new JSONObject();
    params.put("position", new JSONArray() {{
      final java.util.List<com.raritan.idl.peripheral.PosElement> array0 = position;
      for (int i0 = 0; i0 < array0.size(); i0++) {
        final int i0_f = i0;
        this.put(com.raritan.json_rpc.peripheral.PosElement_Codec.encode(array0.get(i0_f)));
      }
    }});
    final JSONObject result = rpcCall("getFirmwareInfoPos", params);
    GetFirmwareInfoPosResult ret = new GetFirmwareInfoPosResult();
    ret._ret_ = result.getInt("_ret_");
    ret.info = com.raritan.json_rpc.peripheral.G2Production_3_0_0.FirmwareInfo_Codec.decode(result.getJSONObject("info"), agent);
    return ret;
  }

  @Override
  public AsyncRequest getFirmwareInfoPos(final java.util.List<com.raritan.idl.peripheral.PosElement> position, final AsyncRpcResponse<GetFirmwareInfoPosResult> rsp) {
    return getFirmwareInfoPos(position, rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest getFirmwareInfoPos(final java.util.List<com.raritan.idl.peripheral.PosElement> position, final AsyncRpcResponse<GetFirmwareInfoPosResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = new JSONObject();
    try {
      params.put("position", new JSONArray() {{
        final java.util.List<com.raritan.idl.peripheral.PosElement> array0 = position;
        for (int i0 = 0; i0 < array0.size(); i0++) {
          final int i0_f = i0;
          this.put(com.raritan.json_rpc.peripheral.PosElement_Codec.encode(array0.get(i0_f)));
        }
      }});
    } catch (Exception e) {
      rsp.onFailure(e);
    }
    return rpcCall("getFirmwareInfoPos", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          GetFirmwareInfoPosResult ret = new GetFirmwareInfoPosResult();
          ret._ret_ = result.getInt("_ret_");
          ret.info = com.raritan.json_rpc.peripheral.G2Production_3_0_0.FirmwareInfo_Codec.decode(result.getJSONObject("info"), agent);
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public ReadConfigurationSpaceResult readConfigurationSpace(final String romcode, final com.raritan.idl.peripheral.G2Production_3_0_0.ConfigurationSpace cs) throws Exception {
    JSONObject params = new JSONObject();
    params.put("romcode", romcode);
    params.put("cs", com.raritan.json_rpc.peripheral.G2Production_3_0_0.ConfigurationSpace_Codec.encode(cs));
    final JSONObject result = rpcCall("readConfigurationSpace", params);
    ReadConfigurationSpaceResult ret = new ReadConfigurationSpaceResult();
    ret._ret_ = result.getInt("_ret_");
    ret.cfg = new java.util.ArrayList<Byte>() {
      private static final long serialVersionUID = 1L;
      {
        final JSONArray array0 = result.getJSONArray("cfg");
        for (int i0 = 0; i0 < array0.length(); i0++) {
          final int i0_f = i0;
          this.add((byte) array0.getInt(i0_f));
        }
      }
    };
    return ret;
  }

  @Override
  public AsyncRequest readConfigurationSpace(final String romcode, final com.raritan.idl.peripheral.G2Production_3_0_0.ConfigurationSpace cs, final AsyncRpcResponse<ReadConfigurationSpaceResult> rsp) {
    return readConfigurationSpace(romcode, cs, rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest readConfigurationSpace(final String romcode, final com.raritan.idl.peripheral.G2Production_3_0_0.ConfigurationSpace cs, final AsyncRpcResponse<ReadConfigurationSpaceResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = new JSONObject();
    try {
      params.put("romcode", romcode);
      params.put("cs", com.raritan.json_rpc.peripheral.G2Production_3_0_0.ConfigurationSpace_Codec.encode(cs));
    } catch (Exception e) {
      rsp.onFailure(e);
    }
    return rpcCall("readConfigurationSpace", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          ReadConfigurationSpaceResult ret = new ReadConfigurationSpaceResult();
          ret._ret_ = result.getInt("_ret_");
          ret.cfg = new java.util.ArrayList<Byte>() {
            private static final long serialVersionUID = 1L;
            {
              final JSONArray array0 = result.getJSONArray("cfg");
              for (int i0 = 0; i0 < array0.length(); i0++) {
                final int i0_f = i0;
                this.add((byte) array0.getInt(i0_f));
              }
            }
          };
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public ReadConfigurationSpacePosResult readConfigurationSpacePos(final java.util.List<com.raritan.idl.peripheral.PosElement> position, final com.raritan.idl.peripheral.G2Production_3_0_0.ConfigurationSpace cs) throws Exception {
    JSONObject params = new JSONObject();
    params.put("position", new JSONArray() {{
      final java.util.List<com.raritan.idl.peripheral.PosElement> array0 = position;
      for (int i0 = 0; i0 < array0.size(); i0++) {
        final int i0_f = i0;
        this.put(com.raritan.json_rpc.peripheral.PosElement_Codec.encode(array0.get(i0_f)));
      }
    }});
    params.put("cs", com.raritan.json_rpc.peripheral.G2Production_3_0_0.ConfigurationSpace_Codec.encode(cs));
    final JSONObject result = rpcCall("readConfigurationSpacePos", params);
    ReadConfigurationSpacePosResult ret = new ReadConfigurationSpacePosResult();
    ret._ret_ = result.getInt("_ret_");
    ret.cfg = new java.util.ArrayList<Byte>() {
      private static final long serialVersionUID = 1L;
      {
        final JSONArray array0 = result.getJSONArray("cfg");
        for (int i0 = 0; i0 < array0.length(); i0++) {
          final int i0_f = i0;
          this.add((byte) array0.getInt(i0_f));
        }
      }
    };
    return ret;
  }

  @Override
  public AsyncRequest readConfigurationSpacePos(final java.util.List<com.raritan.idl.peripheral.PosElement> position, final com.raritan.idl.peripheral.G2Production_3_0_0.ConfigurationSpace cs, final AsyncRpcResponse<ReadConfigurationSpacePosResult> rsp) {
    return readConfigurationSpacePos(position, cs, rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest readConfigurationSpacePos(final java.util.List<com.raritan.idl.peripheral.PosElement> position, final com.raritan.idl.peripheral.G2Production_3_0_0.ConfigurationSpace cs, final AsyncRpcResponse<ReadConfigurationSpacePosResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = new JSONObject();
    try {
      params.put("position", new JSONArray() {{
        final java.util.List<com.raritan.idl.peripheral.PosElement> array0 = position;
        for (int i0 = 0; i0 < array0.size(); i0++) {
          final int i0_f = i0;
          this.put(com.raritan.json_rpc.peripheral.PosElement_Codec.encode(array0.get(i0_f)));
        }
      }});
      params.put("cs", com.raritan.json_rpc.peripheral.G2Production_3_0_0.ConfigurationSpace_Codec.encode(cs));
    } catch (Exception e) {
      rsp.onFailure(e);
    }
    return rpcCall("readConfigurationSpacePos", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          ReadConfigurationSpacePosResult ret = new ReadConfigurationSpacePosResult();
          ret._ret_ = result.getInt("_ret_");
          ret.cfg = new java.util.ArrayList<Byte>() {
            private static final long serialVersionUID = 1L;
            {
              final JSONArray array0 = result.getJSONArray("cfg");
              for (int i0 = 0; i0 < array0.length(); i0++) {
                final int i0_f = i0;
                this.add((byte) array0.getInt(i0_f));
              }
            }
          };
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public EraseConfigurationSpaceResult eraseConfigurationSpace(final String romcode, final com.raritan.idl.peripheral.G2Production_3_0_0.ConfigurationSpace cs) throws Exception {
    JSONObject params = new JSONObject();
    params.put("romcode", romcode);
    params.put("cs", com.raritan.json_rpc.peripheral.G2Production_3_0_0.ConfigurationSpace_Codec.encode(cs));
    final JSONObject result = rpcCall("eraseConfigurationSpace", params);
    EraseConfigurationSpaceResult ret = new EraseConfigurationSpaceResult();
    ret._ret_ = result.getInt("_ret_");
    return ret;
  }

  @Override
  public AsyncRequest eraseConfigurationSpace(final String romcode, final com.raritan.idl.peripheral.G2Production_3_0_0.ConfigurationSpace cs, final AsyncRpcResponse<EraseConfigurationSpaceResult> rsp) {
    return eraseConfigurationSpace(romcode, cs, rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest eraseConfigurationSpace(final String romcode, final com.raritan.idl.peripheral.G2Production_3_0_0.ConfigurationSpace cs, final AsyncRpcResponse<EraseConfigurationSpaceResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = new JSONObject();
    try {
      params.put("romcode", romcode);
      params.put("cs", com.raritan.json_rpc.peripheral.G2Production_3_0_0.ConfigurationSpace_Codec.encode(cs));
    } catch (Exception e) {
      rsp.onFailure(e);
    }
    return rpcCall("eraseConfigurationSpace", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          EraseConfigurationSpaceResult ret = new EraseConfigurationSpaceResult();
          ret._ret_ = result.getInt("_ret_");
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public EraseConfigurationSpacePosResult eraseConfigurationSpacePos(final java.util.List<com.raritan.idl.peripheral.PosElement> position, final com.raritan.idl.peripheral.G2Production_3_0_0.ConfigurationSpace cs) throws Exception {
    JSONObject params = new JSONObject();
    params.put("position", new JSONArray() {{
      final java.util.List<com.raritan.idl.peripheral.PosElement> array0 = position;
      for (int i0 = 0; i0 < array0.size(); i0++) {
        final int i0_f = i0;
        this.put(com.raritan.json_rpc.peripheral.PosElement_Codec.encode(array0.get(i0_f)));
      }
    }});
    params.put("cs", com.raritan.json_rpc.peripheral.G2Production_3_0_0.ConfigurationSpace_Codec.encode(cs));
    final JSONObject result = rpcCall("eraseConfigurationSpacePos", params);
    EraseConfigurationSpacePosResult ret = new EraseConfigurationSpacePosResult();
    ret._ret_ = result.getInt("_ret_");
    return ret;
  }

  @Override
  public AsyncRequest eraseConfigurationSpacePos(final java.util.List<com.raritan.idl.peripheral.PosElement> position, final com.raritan.idl.peripheral.G2Production_3_0_0.ConfigurationSpace cs, final AsyncRpcResponse<EraseConfigurationSpacePosResult> rsp) {
    return eraseConfigurationSpacePos(position, cs, rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest eraseConfigurationSpacePos(final java.util.List<com.raritan.idl.peripheral.PosElement> position, final com.raritan.idl.peripheral.G2Production_3_0_0.ConfigurationSpace cs, final AsyncRpcResponse<EraseConfigurationSpacePosResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = new JSONObject();
    try {
      params.put("position", new JSONArray() {{
        final java.util.List<com.raritan.idl.peripheral.PosElement> array0 = position;
        for (int i0 = 0; i0 < array0.size(); i0++) {
          final int i0_f = i0;
          this.put(com.raritan.json_rpc.peripheral.PosElement_Codec.encode(array0.get(i0_f)));
        }
      }});
      params.put("cs", com.raritan.json_rpc.peripheral.G2Production_3_0_0.ConfigurationSpace_Codec.encode(cs));
    } catch (Exception e) {
      rsp.onFailure(e);
    }
    return rpcCall("eraseConfigurationSpacePos", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          EraseConfigurationSpacePosResult ret = new EraseConfigurationSpacePosResult();
          ret._ret_ = result.getInt("_ret_");
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public WriteConfigurationSpaceResult writeConfigurationSpace(final String romcode, final com.raritan.idl.peripheral.G2Production_3_0_0.ConfigurationSpace cs, final java.util.List<Byte> cfg) throws Exception {
    JSONObject params = new JSONObject();
    params.put("romcode", romcode);
    params.put("cs", com.raritan.json_rpc.peripheral.G2Production_3_0_0.ConfigurationSpace_Codec.encode(cs));
    params.put("cfg", new JSONArray() {{
      final java.util.List<Byte> array0 = cfg;
      for (int i0 = 0; i0 < array0.size(); i0++) {
        final int i0_f = i0;
        this.put(array0.get(i0_f));
      }
    }});
    final JSONObject result = rpcCall("writeConfigurationSpace", params);
    WriteConfigurationSpaceResult ret = new WriteConfigurationSpaceResult();
    ret._ret_ = result.getInt("_ret_");
    return ret;
  }

  @Override
  public AsyncRequest writeConfigurationSpace(final String romcode, final com.raritan.idl.peripheral.G2Production_3_0_0.ConfigurationSpace cs, final java.util.List<Byte> cfg, final AsyncRpcResponse<WriteConfigurationSpaceResult> rsp) {
    return writeConfigurationSpace(romcode, cs, cfg, rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest writeConfigurationSpace(final String romcode, final com.raritan.idl.peripheral.G2Production_3_0_0.ConfigurationSpace cs, final java.util.List<Byte> cfg, final AsyncRpcResponse<WriteConfigurationSpaceResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = new JSONObject();
    try {
      params.put("romcode", romcode);
      params.put("cs", com.raritan.json_rpc.peripheral.G2Production_3_0_0.ConfigurationSpace_Codec.encode(cs));
      params.put("cfg", new JSONArray() {{
        final java.util.List<Byte> array0 = cfg;
        for (int i0 = 0; i0 < array0.size(); i0++) {
          final int i0_f = i0;
          this.put(array0.get(i0_f));
        }
      }});
    } catch (Exception e) {
      rsp.onFailure(e);
    }
    return rpcCall("writeConfigurationSpace", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          WriteConfigurationSpaceResult ret = new WriteConfigurationSpaceResult();
          ret._ret_ = result.getInt("_ret_");
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public WriteConfigurationSpacePosResult writeConfigurationSpacePos(final java.util.List<com.raritan.idl.peripheral.PosElement> position, final com.raritan.idl.peripheral.G2Production_3_0_0.ConfigurationSpace cs, final java.util.List<Byte> cfg) throws Exception {
    JSONObject params = new JSONObject();
    params.put("position", new JSONArray() {{
      final java.util.List<com.raritan.idl.peripheral.PosElement> array0 = position;
      for (int i0 = 0; i0 < array0.size(); i0++) {
        final int i0_f = i0;
        this.put(com.raritan.json_rpc.peripheral.PosElement_Codec.encode(array0.get(i0_f)));
      }
    }});
    params.put("cs", com.raritan.json_rpc.peripheral.G2Production_3_0_0.ConfigurationSpace_Codec.encode(cs));
    params.put("cfg", new JSONArray() {{
      final java.util.List<Byte> array0 = cfg;
      for (int i0 = 0; i0 < array0.size(); i0++) {
        final int i0_f = i0;
        this.put(array0.get(i0_f));
      }
    }});
    final JSONObject result = rpcCall("writeConfigurationSpacePos", params);
    WriteConfigurationSpacePosResult ret = new WriteConfigurationSpacePosResult();
    ret._ret_ = result.getInt("_ret_");
    return ret;
  }

  @Override
  public AsyncRequest writeConfigurationSpacePos(final java.util.List<com.raritan.idl.peripheral.PosElement> position, final com.raritan.idl.peripheral.G2Production_3_0_0.ConfigurationSpace cs, final java.util.List<Byte> cfg, final AsyncRpcResponse<WriteConfigurationSpacePosResult> rsp) {
    return writeConfigurationSpacePos(position, cs, cfg, rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest writeConfigurationSpacePos(final java.util.List<com.raritan.idl.peripheral.PosElement> position, final com.raritan.idl.peripheral.G2Production_3_0_0.ConfigurationSpace cs, final java.util.List<Byte> cfg, final AsyncRpcResponse<WriteConfigurationSpacePosResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = new JSONObject();
    try {
      params.put("position", new JSONArray() {{
        final java.util.List<com.raritan.idl.peripheral.PosElement> array0 = position;
        for (int i0 = 0; i0 < array0.size(); i0++) {
          final int i0_f = i0;
          this.put(com.raritan.json_rpc.peripheral.PosElement_Codec.encode(array0.get(i0_f)));
        }
      }});
      params.put("cs", com.raritan.json_rpc.peripheral.G2Production_3_0_0.ConfigurationSpace_Codec.encode(cs));
      params.put("cfg", new JSONArray() {{
        final java.util.List<Byte> array0 = cfg;
        for (int i0 = 0; i0 < array0.size(); i0++) {
          final int i0_f = i0;
          this.put(array0.get(i0_f));
        }
      }});
    } catch (Exception e) {
      rsp.onFailure(e);
    }
    return rpcCall("writeConfigurationSpacePos", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          WriteConfigurationSpacePosResult ret = new WriteConfigurationSpacePosResult();
          ret._ret_ = result.getInt("_ret_");
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public ReadRegistersResult readRegisters(final String romcode, final int address, final int count) throws Exception {
    JSONObject params = new JSONObject();
    params.put("romcode", romcode);
    params.put("address", address);
    params.put("count", count);
    final JSONObject result = rpcCall("readRegisters", params);
    ReadRegistersResult ret = new ReadRegistersResult();
    ret._ret_ = result.getInt("_ret_");
    ret.data = new java.util.ArrayList<Byte>() {
      private static final long serialVersionUID = 1L;
      {
        final JSONArray array0 = result.getJSONArray("data");
        for (int i0 = 0; i0 < array0.length(); i0++) {
          final int i0_f = i0;
          this.add((byte) array0.getInt(i0_f));
        }
      }
    };
    return ret;
  }

  @Override
  public AsyncRequest readRegisters(final String romcode, final int address, final int count, final AsyncRpcResponse<ReadRegistersResult> rsp) {
    return readRegisters(romcode, address, count, rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest readRegisters(final String romcode, final int address, final int count, final AsyncRpcResponse<ReadRegistersResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = new JSONObject();
    try {
      params.put("romcode", romcode);
      params.put("address", address);
      params.put("count", count);
    } catch (Exception e) {
      rsp.onFailure(e);
    }
    return rpcCall("readRegisters", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          ReadRegistersResult ret = new ReadRegistersResult();
          ret._ret_ = result.getInt("_ret_");
          ret.data = new java.util.ArrayList<Byte>() {
            private static final long serialVersionUID = 1L;
            {
              final JSONArray array0 = result.getJSONArray("data");
              for (int i0 = 0; i0 < array0.length(); i0++) {
                final int i0_f = i0;
                this.add((byte) array0.getInt(i0_f));
              }
            }
          };
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public ReadRegistersPosResult readRegistersPos(final java.util.List<com.raritan.idl.peripheral.PosElement> position, final int address, final int count) throws Exception {
    JSONObject params = new JSONObject();
    params.put("position", new JSONArray() {{
      final java.util.List<com.raritan.idl.peripheral.PosElement> array0 = position;
      for (int i0 = 0; i0 < array0.size(); i0++) {
        final int i0_f = i0;
        this.put(com.raritan.json_rpc.peripheral.PosElement_Codec.encode(array0.get(i0_f)));
      }
    }});
    params.put("address", address);
    params.put("count", count);
    final JSONObject result = rpcCall("readRegistersPos", params);
    ReadRegistersPosResult ret = new ReadRegistersPosResult();
    ret._ret_ = result.getInt("_ret_");
    ret.data = new java.util.ArrayList<Byte>() {
      private static final long serialVersionUID = 1L;
      {
        final JSONArray array0 = result.getJSONArray("data");
        for (int i0 = 0; i0 < array0.length(); i0++) {
          final int i0_f = i0;
          this.add((byte) array0.getInt(i0_f));
        }
      }
    };
    return ret;
  }

  @Override
  public AsyncRequest readRegistersPos(final java.util.List<com.raritan.idl.peripheral.PosElement> position, final int address, final int count, final AsyncRpcResponse<ReadRegistersPosResult> rsp) {
    return readRegistersPos(position, address, count, rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest readRegistersPos(final java.util.List<com.raritan.idl.peripheral.PosElement> position, final int address, final int count, final AsyncRpcResponse<ReadRegistersPosResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = new JSONObject();
    try {
      params.put("position", new JSONArray() {{
        final java.util.List<com.raritan.idl.peripheral.PosElement> array0 = position;
        for (int i0 = 0; i0 < array0.size(); i0++) {
          final int i0_f = i0;
          this.put(com.raritan.json_rpc.peripheral.PosElement_Codec.encode(array0.get(i0_f)));
        }
      }});
      params.put("address", address);
      params.put("count", count);
    } catch (Exception e) {
      rsp.onFailure(e);
    }
    return rpcCall("readRegistersPos", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          ReadRegistersPosResult ret = new ReadRegistersPosResult();
          ret._ret_ = result.getInt("_ret_");
          ret.data = new java.util.ArrayList<Byte>() {
            private static final long serialVersionUID = 1L;
            {
              final JSONArray array0 = result.getJSONArray("data");
              for (int i0 = 0; i0 < array0.length(); i0++) {
                final int i0_f = i0;
                this.add((byte) array0.getInt(i0_f));
              }
            }
          };
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public WriteRegistersResult writeRegisters(final String romcode, final int address, final java.util.List<Byte> data) throws Exception {
    JSONObject params = new JSONObject();
    params.put("romcode", romcode);
    params.put("address", address);
    params.put("data", new JSONArray() {{
      final java.util.List<Byte> array0 = data;
      for (int i0 = 0; i0 < array0.size(); i0++) {
        final int i0_f = i0;
        this.put(array0.get(i0_f));
      }
    }});
    final JSONObject result = rpcCall("writeRegisters", params);
    WriteRegistersResult ret = new WriteRegistersResult();
    ret._ret_ = result.getInt("_ret_");
    return ret;
  }

  @Override
  public AsyncRequest writeRegisters(final String romcode, final int address, final java.util.List<Byte> data, final AsyncRpcResponse<WriteRegistersResult> rsp) {
    return writeRegisters(romcode, address, data, rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest writeRegisters(final String romcode, final int address, final java.util.List<Byte> data, final AsyncRpcResponse<WriteRegistersResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = new JSONObject();
    try {
      params.put("romcode", romcode);
      params.put("address", address);
      params.put("data", new JSONArray() {{
        final java.util.List<Byte> array0 = data;
        for (int i0 = 0; i0 < array0.size(); i0++) {
          final int i0_f = i0;
          this.put(array0.get(i0_f));
        }
      }});
    } catch (Exception e) {
      rsp.onFailure(e);
    }
    return rpcCall("writeRegisters", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          WriteRegistersResult ret = new WriteRegistersResult();
          ret._ret_ = result.getInt("_ret_");
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public WriteRegistersPosResult writeRegistersPos(final java.util.List<com.raritan.idl.peripheral.PosElement> position, final int address, final java.util.List<Byte> data) throws Exception {
    JSONObject params = new JSONObject();
    params.put("position", new JSONArray() {{
      final java.util.List<com.raritan.idl.peripheral.PosElement> array0 = position;
      for (int i0 = 0; i0 < array0.size(); i0++) {
        final int i0_f = i0;
        this.put(com.raritan.json_rpc.peripheral.PosElement_Codec.encode(array0.get(i0_f)));
      }
    }});
    params.put("address", address);
    params.put("data", new JSONArray() {{
      final java.util.List<Byte> array0 = data;
      for (int i0 = 0; i0 < array0.size(); i0++) {
        final int i0_f = i0;
        this.put(array0.get(i0_f));
      }
    }});
    final JSONObject result = rpcCall("writeRegistersPos", params);
    WriteRegistersPosResult ret = new WriteRegistersPosResult();
    ret._ret_ = result.getInt("_ret_");
    return ret;
  }

  @Override
  public AsyncRequest writeRegistersPos(final java.util.List<com.raritan.idl.peripheral.PosElement> position, final int address, final java.util.List<Byte> data, final AsyncRpcResponse<WriteRegistersPosResult> rsp) {
    return writeRegistersPos(position, address, data, rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest writeRegistersPos(final java.util.List<com.raritan.idl.peripheral.PosElement> position, final int address, final java.util.List<Byte> data, final AsyncRpcResponse<WriteRegistersPosResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = new JSONObject();
    try {
      params.put("position", new JSONArray() {{
        final java.util.List<com.raritan.idl.peripheral.PosElement> array0 = position;
        for (int i0 = 0; i0 < array0.size(); i0++) {
          final int i0_f = i0;
          this.put(com.raritan.json_rpc.peripheral.PosElement_Codec.encode(array0.get(i0_f)));
        }
      }});
      params.put("address", address);
      params.put("data", new JSONArray() {{
        final java.util.List<Byte> array0 = data;
        for (int i0 = 0; i0 < array0.size(); i0++) {
          final int i0_f = i0;
          this.put(array0.get(i0_f));
        }
      }});
    } catch (Exception e) {
      rsp.onFailure(e);
    }
    return rpcCall("writeRegistersPos", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          WriteRegistersPosResult ret = new WriteRegistersPosResult();
          ret._ret_ = result.getInt("_ret_");
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public WriteRegisterBitsResult writeRegisterBits(final String romcode, final int address, final byte mask, final byte bits) throws Exception {
    JSONObject params = new JSONObject();
    params.put("romcode", romcode);
    params.put("address", address);
    params.put("mask", mask);
    params.put("bits", bits);
    final JSONObject result = rpcCall("writeRegisterBits", params);
    WriteRegisterBitsResult ret = new WriteRegisterBitsResult();
    ret._ret_ = result.getInt("_ret_");
    return ret;
  }

  @Override
  public AsyncRequest writeRegisterBits(final String romcode, final int address, final byte mask, final byte bits, final AsyncRpcResponse<WriteRegisterBitsResult> rsp) {
    return writeRegisterBits(romcode, address, mask, bits, rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest writeRegisterBits(final String romcode, final int address, final byte mask, final byte bits, final AsyncRpcResponse<WriteRegisterBitsResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = new JSONObject();
    try {
      params.put("romcode", romcode);
      params.put("address", address);
      params.put("mask", mask);
      params.put("bits", bits);
    } catch (Exception e) {
      rsp.onFailure(e);
    }
    return rpcCall("writeRegisterBits", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          WriteRegisterBitsResult ret = new WriteRegisterBitsResult();
          ret._ret_ = result.getInt("_ret_");
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public WriteRegisterBitsPosResult writeRegisterBitsPos(final java.util.List<com.raritan.idl.peripheral.PosElement> position, final int address, final byte mask, final byte bits) throws Exception {
    JSONObject params = new JSONObject();
    params.put("position", new JSONArray() {{
      final java.util.List<com.raritan.idl.peripheral.PosElement> array0 = position;
      for (int i0 = 0; i0 < array0.size(); i0++) {
        final int i0_f = i0;
        this.put(com.raritan.json_rpc.peripheral.PosElement_Codec.encode(array0.get(i0_f)));
      }
    }});
    params.put("address", address);
    params.put("mask", mask);
    params.put("bits", bits);
    final JSONObject result = rpcCall("writeRegisterBitsPos", params);
    WriteRegisterBitsPosResult ret = new WriteRegisterBitsPosResult();
    ret._ret_ = result.getInt("_ret_");
    return ret;
  }

  @Override
  public AsyncRequest writeRegisterBitsPos(final java.util.List<com.raritan.idl.peripheral.PosElement> position, final int address, final byte mask, final byte bits, final AsyncRpcResponse<WriteRegisterBitsPosResult> rsp) {
    return writeRegisterBitsPos(position, address, mask, bits, rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest writeRegisterBitsPos(final java.util.List<com.raritan.idl.peripheral.PosElement> position, final int address, final byte mask, final byte bits, final AsyncRpcResponse<WriteRegisterBitsPosResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = new JSONObject();
    try {
      params.put("position", new JSONArray() {{
        final java.util.List<com.raritan.idl.peripheral.PosElement> array0 = position;
        for (int i0 = 0; i0 < array0.size(); i0++) {
          final int i0_f = i0;
          this.put(com.raritan.json_rpc.peripheral.PosElement_Codec.encode(array0.get(i0_f)));
        }
      }});
      params.put("address", address);
      params.put("mask", mask);
      params.put("bits", bits);
    } catch (Exception e) {
      rsp.onFailure(e);
    }
    return rpcCall("writeRegisterBitsPos", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          WriteRegisterBitsPosResult ret = new WriteRegisterBitsPosResult();
          ret._ret_ = result.getInt("_ret_");
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public ResetResult reset(final String romcode, final com.raritan.idl.peripheral.G2Production_3_0_0.ResetMethod method) throws Exception {
    JSONObject params = new JSONObject();
    params.put("romcode", romcode);
    params.put("method", com.raritan.json_rpc.peripheral.G2Production_3_0_0.ResetMethod_Codec.encode(method));
    final JSONObject result = rpcCall("reset", params);
    ResetResult ret = new ResetResult();
    ret._ret_ = result.getInt("_ret_");
    return ret;
  }

  @Override
  public AsyncRequest reset(final String romcode, final com.raritan.idl.peripheral.G2Production_3_0_0.ResetMethod method, final AsyncRpcResponse<ResetResult> rsp) {
    return reset(romcode, method, rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest reset(final String romcode, final com.raritan.idl.peripheral.G2Production_3_0_0.ResetMethod method, final AsyncRpcResponse<ResetResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = new JSONObject();
    try {
      params.put("romcode", romcode);
      params.put("method", com.raritan.json_rpc.peripheral.G2Production_3_0_0.ResetMethod_Codec.encode(method));
    } catch (Exception e) {
      rsp.onFailure(e);
    }
    return rpcCall("reset", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          ResetResult ret = new ResetResult();
          ret._ret_ = result.getInt("_ret_");
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public ResetPosResult resetPos(final java.util.List<com.raritan.idl.peripheral.PosElement> position, final com.raritan.idl.peripheral.G2Production_3_0_0.ResetMethod method) throws Exception {
    JSONObject params = new JSONObject();
    params.put("position", new JSONArray() {{
      final java.util.List<com.raritan.idl.peripheral.PosElement> array0 = position;
      for (int i0 = 0; i0 < array0.size(); i0++) {
        final int i0_f = i0;
        this.put(com.raritan.json_rpc.peripheral.PosElement_Codec.encode(array0.get(i0_f)));
      }
    }});
    params.put("method", com.raritan.json_rpc.peripheral.G2Production_3_0_0.ResetMethod_Codec.encode(method));
    final JSONObject result = rpcCall("resetPos", params);
    ResetPosResult ret = new ResetPosResult();
    ret._ret_ = result.getInt("_ret_");
    return ret;
  }

  @Override
  public AsyncRequest resetPos(final java.util.List<com.raritan.idl.peripheral.PosElement> position, final com.raritan.idl.peripheral.G2Production_3_0_0.ResetMethod method, final AsyncRpcResponse<ResetPosResult> rsp) {
    return resetPos(position, method, rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest resetPos(final java.util.List<com.raritan.idl.peripheral.PosElement> position, final com.raritan.idl.peripheral.G2Production_3_0_0.ResetMethod method, final AsyncRpcResponse<ResetPosResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = new JSONObject();
    try {
      params.put("position", new JSONArray() {{
        final java.util.List<com.raritan.idl.peripheral.PosElement> array0 = position;
        for (int i0 = 0; i0 < array0.size(); i0++) {
          final int i0_f = i0;
          this.put(com.raritan.json_rpc.peripheral.PosElement_Codec.encode(array0.get(i0_f)));
        }
      }});
      params.put("method", com.raritan.json_rpc.peripheral.G2Production_3_0_0.ResetMethod_Codec.encode(method));
    } catch (Exception e) {
      rsp.onFailure(e);
    }
    return rpcCall("resetPos", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          ResetPosResult ret = new ResetPosResult();
          ret._ret_ = result.getInt("_ret_");
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }
}
