// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2025 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from PeripheralDeviceSlot.idl.

package com.raritan.json_rpc.peripheral;

import org.json.*;

import com.raritan.idl.*;
import com.raritan.json_rpc.*;
import com.raritan.util.AsyncRequest;

public class DeviceSlot_5_0_1_Proxy extends ObjectProxy implements com.raritan.idl.peripheral.DeviceSlot_5_0_1 {

  public DeviceSlot_5_0_1_Proxy(Agent agent, String rid, TypeInfo typeInfo) {
    super(agent, rid, typeInfo);
  }

  public DeviceSlot_5_0_1_Proxy(Agent agent, String rid) {
    this(agent, rid, com.raritan.idl.peripheral.DeviceSlot_5_0_1.typeInfo);
  }

  public static DeviceSlot_5_0_1_Proxy staticCast(ObjectProxy proxy) {
    return proxy == null ? null : new DeviceSlot_5_0_1_Proxy(proxy.getAgent(), proxy.getRid(), proxy.getStaticTypeInfo());
  }


  @Override
  public GetDeviceResult getDevice() throws Exception {
    JSONObject params = null;
    final JSONObject result = rpcCall("getDevice", params);
    GetDeviceResult ret = new GetDeviceResult();
    ret._ret_ = (com.raritan.idl.peripheral.Device_7_0_1)ValueObjectCodec.decodeAs((result.isNull("_ret_") ? null : result.getJSONObject("_ret_")), agent, new TypeInfo("peripheral.Device:7.0.1", null));
    return ret;
  }

  @Override
  public AsyncRequest getDevice(final AsyncRpcResponse<GetDeviceResult> rsp) {
    return getDevice(rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest getDevice(final AsyncRpcResponse<GetDeviceResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = null;
    return rpcCall("getDevice", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          GetDeviceResult ret = new GetDeviceResult();
          ret._ret_ = (com.raritan.idl.peripheral.Device_7_0_1)ValueObjectCodec.decodeAs((result.isNull("_ret_") ? null : result.getJSONObject("_ret_")), agent, new TypeInfo("peripheral.Device:7.0.1", null));
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public AssignResult assign(final com.raritan.idl.peripheral.DeviceID_6_0_0 devid) throws Exception {
    JSONObject params = new JSONObject();
    params.put("devid", com.raritan.json_rpc.peripheral.DeviceID_6_0_0_Codec.encode(devid));
    final JSONObject result = rpcCall("assign", params);
    AssignResult ret = new AssignResult();
    ret._ret_ = result.getInt("_ret_");
    return ret;
  }

  @Override
  public AsyncRequest assign(final com.raritan.idl.peripheral.DeviceID_6_0_0 devid, final AsyncRpcResponse<AssignResult> rsp) {
    return assign(devid, rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest assign(final com.raritan.idl.peripheral.DeviceID_6_0_0 devid, final AsyncRpcResponse<AssignResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = new JSONObject();
    try {
      params.put("devid", com.raritan.json_rpc.peripheral.DeviceID_6_0_0_Codec.encode(devid));
    } catch (Exception e) {
      rsp.onFailure(e);
    }
    return rpcCall("assign", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          AssignResult ret = new AssignResult();
          ret._ret_ = result.getInt("_ret_");
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public AssignAddressResult assignAddress(final String packageClass, final com.raritan.idl.peripheral.Address_9_0_0 address) throws Exception {
    JSONObject params = new JSONObject();
    params.put("packageClass", packageClass);
    params.put("address", com.raritan.json_rpc.peripheral.Address_9_0_0_Codec.encode(address));
    final JSONObject result = rpcCall("assignAddress", params);
    AssignAddressResult ret = new AssignAddressResult();
    ret._ret_ = result.getInt("_ret_");
    return ret;
  }

  @Override
  public AsyncRequest assignAddress(final String packageClass, final com.raritan.idl.peripheral.Address_9_0_0 address, final AsyncRpcResponse<AssignAddressResult> rsp) {
    return assignAddress(packageClass, address, rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest assignAddress(final String packageClass, final com.raritan.idl.peripheral.Address_9_0_0 address, final AsyncRpcResponse<AssignAddressResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = new JSONObject();
    try {
      params.put("packageClass", packageClass);
      params.put("address", com.raritan.json_rpc.peripheral.Address_9_0_0_Codec.encode(address));
    } catch (Exception e) {
      rsp.onFailure(e);
    }
    return rpcCall("assignAddress", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          AssignAddressResult ret = new AssignAddressResult();
          ret._ret_ = result.getInt("_ret_");
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public UnassignResult unassign() throws Exception {
    JSONObject params = null;
    final JSONObject result = rpcCall("unassign", params);
    UnassignResult ret = new UnassignResult();
    ret._ret_ = result.getInt("_ret_");
    return ret;
  }

  @Override
  public AsyncRequest unassign(final AsyncRpcResponse<UnassignResult> rsp) {
    return unassign(rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest unassign(final AsyncRpcResponse<UnassignResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = null;
    return rpcCall("unassign", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          UnassignResult ret = new UnassignResult();
          ret._ret_ = result.getInt("_ret_");
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public GetSettingsResult getSettings() throws Exception {
    JSONObject params = null;
    final JSONObject result = rpcCall("getSettings", params);
    GetSettingsResult ret = new GetSettingsResult();
    ret._ret_ = com.raritan.json_rpc.peripheral.DeviceSlot_5_0_1.Settings_Codec.decode(result.getJSONObject("_ret_"), agent);
    return ret;
  }

  @Override
  public AsyncRequest getSettings(final AsyncRpcResponse<GetSettingsResult> rsp) {
    return getSettings(rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest getSettings(final AsyncRpcResponse<GetSettingsResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = null;
    return rpcCall("getSettings", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          GetSettingsResult ret = new GetSettingsResult();
          ret._ret_ = com.raritan.json_rpc.peripheral.DeviceSlot_5_0_1.Settings_Codec.decode(result.getJSONObject("_ret_"), agent);
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public SetSettingsResult setSettings(final com.raritan.idl.peripheral.DeviceSlot_5_0_1.Settings settings) throws Exception {
    JSONObject params = new JSONObject();
    params.put("settings", com.raritan.json_rpc.peripheral.DeviceSlot_5_0_1.Settings_Codec.encode(settings));
    final JSONObject result = rpcCall("setSettings", params);
    SetSettingsResult ret = new SetSettingsResult();
    ret._ret_ = result.getInt("_ret_");
    return ret;
  }

  @Override
  public AsyncRequest setSettings(final com.raritan.idl.peripheral.DeviceSlot_5_0_1.Settings settings, final AsyncRpcResponse<SetSettingsResult> rsp) {
    return setSettings(settings, rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest setSettings(final com.raritan.idl.peripheral.DeviceSlot_5_0_1.Settings settings, final AsyncRpcResponse<SetSettingsResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = new JSONObject();
    try {
      params.put("settings", com.raritan.json_rpc.peripheral.DeviceSlot_5_0_1.Settings_Codec.encode(settings));
    } catch (Exception e) {
      rsp.onFailure(e);
    }
    return rpcCall("setSettings", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          SetSettingsResult ret = new SetSettingsResult();
          ret._ret_ = result.getInt("_ret_");
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }
}
