// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2025 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from Unit.idl.

package com.raritan.json_rpc.pdumodel;

import org.json.*;

import com.raritan.idl.*;
import com.raritan.json_rpc.*;
import com.raritan.util.AsyncRequest;

public class Unit_Proxy extends ObjectProxy implements com.raritan.idl.pdumodel.Unit {

  public Unit_Proxy(Agent agent, String rid, TypeInfo typeInfo) {
    super(agent, rid, typeInfo);
  }

  public Unit_Proxy(Agent agent, String rid) {
    this(agent, rid, com.raritan.idl.pdumodel.Unit.typeInfo);
  }

  public static Unit_Proxy staticCast(ObjectProxy proxy) {
    return proxy == null ? null : new Unit_Proxy(proxy.getAgent(), proxy.getRid(), proxy.getStaticTypeInfo());
  }


  @Override
  public Void identify(final int seconds) throws Exception {
    JSONObject params = new JSONObject();
    params.put("seconds", seconds);
    rpcCall("identify", params);
    Void ret = null;
    return ret;
  }

  @Override
  public AsyncRequest identify(final int seconds, final AsyncRpcResponse<Void> rsp) {
    return identify(seconds, rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest identify(final int seconds, final AsyncRpcResponse<Void> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = new JSONObject();
    try {
      params.put("seconds", seconds);
    } catch (Exception e) {
      rsp.onFailure(e);
    }
    return rpcCall("identify", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          Void ret = null;
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public Void muteBuzzer(final boolean mute) throws Exception {
    JSONObject params = new JSONObject();
    params.put("mute", mute);
    rpcCall("muteBuzzer", params);
    Void ret = null;
    return ret;
  }

  @Override
  public AsyncRequest muteBuzzer(final boolean mute, final AsyncRpcResponse<Void> rsp) {
    return muteBuzzer(mute, rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest muteBuzzer(final boolean mute, final AsyncRpcResponse<Void> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = new JSONObject();
    try {
      params.put("mute", mute);
    } catch (Exception e) {
      rsp.onFailure(e);
    }
    return rpcCall("muteBuzzer", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          Void ret = null;
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public Void testBuzzer(final boolean on) throws Exception {
    JSONObject params = new JSONObject();
    params.put("on", on);
    rpcCall("testBuzzer", params);
    Void ret = null;
    return ret;
  }

  @Override
  public AsyncRequest testBuzzer(final boolean on, final AsyncRpcResponse<Void> rsp) {
    return testBuzzer(on, rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest testBuzzer(final boolean on, final AsyncRpcResponse<Void> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = new JSONObject();
    try {
      params.put("on", on);
    } catch (Exception e) {
      rsp.onFailure(e);
    }
    return rpcCall("testBuzzer", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          Void ret = null;
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public TestButtonStateResult testButtonState(final int button) throws Exception {
    JSONObject params = new JSONObject();
    params.put("button", button);
    final JSONObject result = rpcCall("testButtonState", params);
    TestButtonStateResult ret = new TestButtonStateResult();
    ret._ret_ = result.getBoolean("_ret_");
    return ret;
  }

  @Override
  public AsyncRequest testButtonState(final int button, final AsyncRpcResponse<TestButtonStateResult> rsp) {
    return testButtonState(button, rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest testButtonState(final int button, final AsyncRpcResponse<TestButtonStateResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = new JSONObject();
    try {
      params.put("button", button);
    } catch (Exception e) {
      rsp.onFailure(e);
    }
    return rpcCall("testButtonState", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          TestButtonStateResult ret = new TestButtonStateResult();
          ret._ret_ = result.getBoolean("_ret_");
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public Void testLEDSequence() throws Exception {
    JSONObject params = null;
    rpcCall("testLEDSequence", params);
    Void ret = null;
    return ret;
  }

  @Override
  public AsyncRequest testLEDSequence(final AsyncRpcResponse<Void> rsp) {
    return testLEDSequence(rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest testLEDSequence(final AsyncRpcResponse<Void> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = null;
    return rpcCall("testLEDSequence", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          Void ret = null;
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public GetDisplayInfoResult getDisplayInfo() throws Exception {
    JSONObject params = null;
    final JSONObject result = rpcCall("getDisplayInfo", params);
    GetDisplayInfoResult ret = new GetDisplayInfoResult();
    ret._ret_ = new java.util.ArrayList<com.raritan.idl.pdumodel.Unit.DisplayInfo>() {
      private static final long serialVersionUID = 1L;
      {
        final JSONArray array0 = result.getJSONArray("_ret_");
        for (int i0 = 0; i0 < array0.length(); i0++) {
          final int i0_f = i0;
          this.add(com.raritan.json_rpc.pdumodel.Unit.DisplayInfo_Codec.decode(array0.getJSONObject(i0_f), agent));
        }
      }
    };
    return ret;
  }

  @Override
  public AsyncRequest getDisplayInfo(final AsyncRpcResponse<GetDisplayInfoResult> rsp) {
    return getDisplayInfo(rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest getDisplayInfo(final AsyncRpcResponse<GetDisplayInfoResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = null;
    return rpcCall("getDisplayInfo", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          GetDisplayInfoResult ret = new GetDisplayInfoResult();
          ret._ret_ = new java.util.ArrayList<com.raritan.idl.pdumodel.Unit.DisplayInfo>() {
            private static final long serialVersionUID = 1L;
            {
              final JSONArray array0 = result.getJSONArray("_ret_");
              for (int i0 = 0; i0 < array0.length(); i0++) {
                final int i0_f = i0;
                this.add(com.raritan.json_rpc.pdumodel.Unit.DisplayInfo_Codec.decode(array0.getJSONObject(i0_f), agent));
              }
            }
          };
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }
}
