// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2025 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from Cascading.idl.

package com.raritan.json_rpc.cascading;

import org.json.*;

import com.raritan.idl.*;
import com.raritan.json_rpc.*;
import com.raritan.util.AsyncRequest;

public class Cascading_Proxy extends ObjectProxy implements com.raritan.idl.cascading.Cascading {

  public Cascading_Proxy(Agent agent, String rid, TypeInfo typeInfo) {
    super(agent, rid, typeInfo);
  }

  public Cascading_Proxy(Agent agent, String rid) {
    this(agent, rid, com.raritan.idl.cascading.Cascading.typeInfo);
  }

  public static Cascading_Proxy staticCast(ObjectProxy proxy) {
    return proxy == null ? null : new Cascading_Proxy(proxy.getAgent(), proxy.getRid(), proxy.getStaticTypeInfo());
  }


  @Override
  public SetTypeResult setType(final com.raritan.idl.cascading.Cascading.Type type) throws Exception {
    JSONObject params = new JSONObject();
    params.put("type", com.raritan.json_rpc.cascading.Cascading.Type_Codec.encode(type));
    final JSONObject result = rpcCall("setType", params);
    SetTypeResult ret = new SetTypeResult();
    ret._ret_ = result.getInt("_ret_");
    return ret;
  }

  @Override
  public AsyncRequest setType(final com.raritan.idl.cascading.Cascading.Type type, final AsyncRpcResponse<SetTypeResult> rsp) {
    return setType(type, rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest setType(final com.raritan.idl.cascading.Cascading.Type type, final AsyncRpcResponse<SetTypeResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = new JSONObject();
    try {
      params.put("type", com.raritan.json_rpc.cascading.Cascading.Type_Codec.encode(type));
    } catch (Exception e) {
      rsp.onFailure(e);
    }
    return rpcCall("setType", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          SetTypeResult ret = new SetTypeResult();
          ret._ret_ = result.getInt("_ret_");
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public GetTypeResult getType() throws Exception {
    JSONObject params = null;
    final JSONObject result = rpcCall("getType", params);
    GetTypeResult ret = new GetTypeResult();
    ret._ret_ = result.getInt("_ret_");
    ret.type = com.raritan.json_rpc.cascading.Cascading.Type_Codec.decode(result.getInt("type"));
    return ret;
  }

  @Override
  public AsyncRequest getType(final AsyncRpcResponse<GetTypeResult> rsp) {
    return getType(rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest getType(final AsyncRpcResponse<GetTypeResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = null;
    return rpcCall("getType", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          GetTypeResult ret = new GetTypeResult();
          ret._ret_ = result.getInt("_ret_");
          ret.type = com.raritan.json_rpc.cascading.Cascading.Type_Codec.decode(result.getInt("type"));
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public GetIndexResult getIndex() throws Exception {
    JSONObject params = null;
    final JSONObject result = rpcCall("getIndex", params);
    GetIndexResult ret = new GetIndexResult();
    ret.idx = result.getInt("idx");
    return ret;
  }

  @Override
  public AsyncRequest getIndex(final AsyncRpcResponse<GetIndexResult> rsp) {
    return getIndex(rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest getIndex(final AsyncRpcResponse<GetIndexResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = null;
    return rpcCall("getIndex", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          GetIndexResult ret = new GetIndexResult();
          ret.idx = result.getInt("idx");
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public GetMasterIpAddressResult getMasterIpAddress() throws Exception {
    JSONObject params = null;
    final JSONObject result = rpcCall("getMasterIpAddress", params);
    GetMasterIpAddressResult ret = new GetMasterIpAddressResult();
    ret.masterIpAddress = result.getString("masterIpAddress");
    return ret;
  }

  @Override
  public AsyncRequest getMasterIpAddress(final AsyncRpcResponse<GetMasterIpAddressResult> rsp) {
    return getMasterIpAddress(rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest getMasterIpAddress(final AsyncRpcResponse<GetMasterIpAddressResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = null;
    return rpcCall("getMasterIpAddress", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          GetMasterIpAddressResult ret = new GetMasterIpAddressResult();
          ret.masterIpAddress = result.getString("masterIpAddress");
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public GetProtocolMappingsResult getProtocolMappings() throws Exception {
    JSONObject params = null;
    final JSONObject result = rpcCall("getProtocolMappings", params);
    GetProtocolMappingsResult ret = new GetProtocolMappingsResult();
    ret.mappings = new java.util.ArrayList<com.raritan.idl.cascading.Cascading.ProtocolMapping>() {
      private static final long serialVersionUID = 1L;
      {
        final JSONArray array0 = result.getJSONArray("mappings");
        for (int i0 = 0; i0 < array0.length(); i0++) {
          final int i0_f = i0;
          this.add(com.raritan.json_rpc.cascading.Cascading.ProtocolMapping_Codec.decode(array0.getJSONObject(i0_f), agent));
        }
      }
    };
    return ret;
  }

  @Override
  public AsyncRequest getProtocolMappings(final AsyncRpcResponse<GetProtocolMappingsResult> rsp) {
    return getProtocolMappings(rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest getProtocolMappings(final AsyncRpcResponse<GetProtocolMappingsResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = null;
    return rpcCall("getProtocolMappings", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          GetProtocolMappingsResult ret = new GetProtocolMappingsResult();
          ret.mappings = new java.util.ArrayList<com.raritan.idl.cascading.Cascading.ProtocolMapping>() {
            private static final long serialVersionUID = 1L;
            {
              final JSONArray array0 = result.getJSONArray("mappings");
              for (int i0 = 0; i0 < array0.length(); i0++) {
                final int i0_f = i0;
                this.add(com.raritan.json_rpc.cascading.Cascading.ProtocolMapping_Codec.decode(array0.getJSONObject(i0_f), agent));
              }
            }
          };
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }
}
