// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2025 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from CascadeManager.idl.

package com.raritan.json_rpc.cascading;

import org.json.*;

import com.raritan.idl.*;
import com.raritan.json_rpc.*;
import com.raritan.util.AsyncRequest;

public class CascadeManager_Proxy extends ObjectProxy implements com.raritan.idl.cascading.CascadeManager {

  public CascadeManager_Proxy(Agent agent, String rid, TypeInfo typeInfo) {
    super(agent, rid, typeInfo);
  }

  public CascadeManager_Proxy(Agent agent, String rid) {
    this(agent, rid, com.raritan.idl.cascading.CascadeManager.typeInfo);
  }

  public static CascadeManager_Proxy staticCast(ObjectProxy proxy) {
    return proxy == null ? null : new CascadeManager_Proxy(proxy.getAgent(), proxy.getRid(), proxy.getStaticTypeInfo());
  }


  @Override
  public GetStatusResult getStatus() throws Exception {
    JSONObject params = null;
    final JSONObject result = rpcCall("getStatus", params);
    GetStatusResult ret = new GetStatusResult();
    ret._ret_ = com.raritan.json_rpc.cascading.CascadeManager.Status_Codec.decode(result.getJSONObject("_ret_"), agent);
    return ret;
  }

  @Override
  public AsyncRequest getStatus(final AsyncRpcResponse<GetStatusResult> rsp) {
    return getStatus(rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest getStatus(final AsyncRpcResponse<GetStatusResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = null;
    return rpcCall("getStatus", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          GetStatusResult ret = new GetStatusResult();
          ret._ret_ = com.raritan.json_rpc.cascading.CascadeManager.Status_Codec.decode(result.getJSONObject("_ret_"), agent);
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public AddLinkUnitResult addLinkUnit(final int linkId, final String host, final String login, final String password, final String newPassword) throws Exception {
    JSONObject params = new JSONObject();
    params.put("linkId", linkId);
    params.put("host", host);
    params.put("login", login);
    params.put("password", password);
    params.put("newPassword", newPassword);
    final JSONObject result = rpcCall("addLinkUnit", params);
    AddLinkUnitResult ret = new AddLinkUnitResult();
    ret._ret_ = result.getInt("_ret_");
    return ret;
  }

  @Override
  public AsyncRequest addLinkUnit(final int linkId, final String host, final String login, final String password, final String newPassword, final AsyncRpcResponse<AddLinkUnitResult> rsp) {
    return addLinkUnit(linkId, host, login, password, newPassword, rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest addLinkUnit(final int linkId, final String host, final String login, final String password, final String newPassword, final AsyncRpcResponse<AddLinkUnitResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = new JSONObject();
    try {
      params.put("linkId", linkId);
      params.put("host", host);
      params.put("login", login);
      params.put("password", password);
      params.put("newPassword", newPassword);
    } catch (Exception e) {
      rsp.onFailure(e);
    }
    return rpcCall("addLinkUnit", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          AddLinkUnitResult ret = new AddLinkUnitResult();
          ret._ret_ = result.getInt("_ret_");
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public ReleaseLinkUnitResult releaseLinkUnit(final int linkId) throws Exception {
    JSONObject params = new JSONObject();
    params.put("linkId", linkId);
    final JSONObject result = rpcCall("releaseLinkUnit", params);
    ReleaseLinkUnitResult ret = new ReleaseLinkUnitResult();
    ret._ret_ = result.getInt("_ret_");
    return ret;
  }

  @Override
  public AsyncRequest releaseLinkUnit(final int linkId, final AsyncRpcResponse<ReleaseLinkUnitResult> rsp) {
    return releaseLinkUnit(linkId, rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest releaseLinkUnit(final int linkId, final AsyncRpcResponse<ReleaseLinkUnitResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = new JSONObject();
    try {
      params.put("linkId", linkId);
    } catch (Exception e) {
      rsp.onFailure(e);
    }
    return rpcCall("releaseLinkUnit", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          ReleaseLinkUnitResult ret = new ReleaseLinkUnitResult();
          ret._ret_ = result.getInt("_ret_");
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public RequestLinkResult requestLink(final String token) throws Exception {
    JSONObject params = new JSONObject();
    params.put("token", token);
    final JSONObject result = rpcCall("requestLink", params);
    RequestLinkResult ret = new RequestLinkResult();
    ret._ret_ = result.getInt("_ret_");
    return ret;
  }

  @Override
  public AsyncRequest requestLink(final String token, final AsyncRpcResponse<RequestLinkResult> rsp) {
    return requestLink(token, rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest requestLink(final String token, final AsyncRpcResponse<RequestLinkResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = new JSONObject();
    try {
      params.put("token", token);
    } catch (Exception e) {
      rsp.onFailure(e);
    }
    return rpcCall("requestLink", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          RequestLinkResult ret = new RequestLinkResult();
          ret._ret_ = result.getInt("_ret_");
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public Void finalizeLink(final String token) throws Exception {
    JSONObject params = new JSONObject();
    params.put("token", token);
    rpcCall("finalizeLink", params);
    Void ret = null;
    return ret;
  }

  @Override
  public AsyncRequest finalizeLink(final String token, final AsyncRpcResponse<Void> rsp) {
    return finalizeLink(token, rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest finalizeLink(final String token, final AsyncRpcResponse<Void> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = new JSONObject();
    try {
      params.put("token", token);
    } catch (Exception e) {
      rsp.onFailure(e);
    }
    return rpcCall("finalizeLink", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          Void ret = null;
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public Void unlink() throws Exception {
    JSONObject params = null;
    rpcCall("unlink", params);
    Void ret = null;
    return ret;
  }

  @Override
  public AsyncRequest unlink(final AsyncRpcResponse<Void> rsp) {
    return unlink(rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest unlink(final AsyncRpcResponse<Void> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = null;
    return rpcCall("unlink", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          Void ret = null;
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }
}
