// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2009 Raritan Inc. All rights reserved.

package com.raritan.json_rpc;

public class RpcRequestException extends RpcException {

    private final int responseCode;

    public RpcRequestException(int responseCode) {
        super("Request response code " + responseCode);
        this.responseCode = responseCode;
    }

    public int getResponseCode() {
        return responseCode;
    }

}
