// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2009 Raritan Inc. All rights reserved.

package com.raritan.json_rpc;

public class RpcErrorException extends RpcException {

    private final int errroNumber;
    private final String errorString;

    public RpcErrorException(int errorNumber, String errorString) {
        super("" + errorNumber + " - " + errorString);
        this.errroNumber = errorNumber;
        this.errorString = errorString;
    }

    public int getErrroNumber() {
        return errroNumber;
    }

    public String getErrorString() {
        return errorString;
    }

}
