// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2025 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from ZigbeeManager.idl.

package com.raritan.idl.zigbee;

import com.raritan.idl.*;
import com.raritan.util.AsyncRequest;

public interface ZigbeeManager {
  static public final TypeInfo typeInfo = new TypeInfo("zigbee.ZigbeeManager:1.0.0", null);

  public static final int ERR_DEVICE_EXISTS = 1;

  public static final int ERR_MAX_DEVICE_REACHED = 2;

  public static final int ERR_DEVICE_NOT_FOUND = 3;

  public static final int ERR_INVALID_PARAMS = 4;

  public static final int ERR_INVALID_KEY = 5;

  public static final int ERR_INVALID_CHANNEL = 6;

  public enum DongleState {
    NOT_INIT,
    READY,
    ERROR,
    INIT_IN_PROGRESS,
    FW_UPGRADE,
    IN_MODEM_STATE;
  }

  static public class MetaData implements Cloneable {
    public String firmwareVersion = new String();
    public String stackVersion = new String();

    public Object clone() {
      MetaData copy = new MetaData();

      copy.firmwareVersion = this.firmwareVersion;
      copy.stackVersion = this.stackVersion;

      return copy;
    }

  }

  static public class Settings implements Cloneable {
    public int channel = 0;

    public Object clone() {
      Settings copy = new Settings();

      copy.channel = this.channel;

      return copy;
    }

  }

  static public class DeviceRegistration implements Cloneable {
    public int sourceId = 0;
    public String key = new String();
    public int slot = 0;

    public Object clone() {
      DeviceRegistration copy = new DeviceRegistration();

      copy.sourceId = this.sourceId;
      copy.key = this.key;
      copy.slot = this.slot;

      return copy;
    }

  }

  public class DeviceEvent extends com.raritan.idl.idl.Event {

    static public final TypeInfo typeInfo = new TypeInfo("zigbee.ZigbeeManager.DeviceEvent:1.0.0", com.raritan.idl.idl.Event.typeInfo);

    @Override
    protected TypeInfo getClassTypeInfo() {
      return typeInfo;
    }

    public int sourceId = 0;
  }

  public class DeviceAddedEvent extends com.raritan.idl.zigbee.ZigbeeManager.DeviceEvent {

    static public final TypeInfo typeInfo = new TypeInfo("zigbee.ZigbeeManager.DeviceAddedEvent:1.0.0", com.raritan.idl.zigbee.ZigbeeManager.DeviceEvent.typeInfo);

    @Override
    protected TypeInfo getClassTypeInfo() {
      return typeInfo;
    }

  }

  public class DeviceRemovedEvent extends com.raritan.idl.zigbee.ZigbeeManager.DeviceEvent {

    static public final TypeInfo typeInfo = new TypeInfo("zigbee.ZigbeeManager.DeviceRemovedEvent:1.0.0", com.raritan.idl.zigbee.ZigbeeManager.DeviceEvent.typeInfo);

    @Override
    protected TypeInfo getClassTypeInfo() {
      return typeInfo;
    }

  }

  public class SettingsChangedEvent extends com.raritan.idl.idl.Event {

    static public final TypeInfo typeInfo = new TypeInfo("zigbee.ZigbeeManager.SettingsChangedEvent:1.0.0", com.raritan.idl.idl.Event.typeInfo);

    @Override
    protected TypeInfo getClassTypeInfo() {
      return typeInfo;
    }

    public com.raritan.idl.zigbee.ZigbeeManager.Settings oldSettings = new com.raritan.idl.zigbee.ZigbeeManager.Settings();
    public com.raritan.idl.zigbee.ZigbeeManager.Settings newSettings = new com.raritan.idl.zigbee.ZigbeeManager.Settings();
  }

  public class StateChangedEvent extends com.raritan.idl.idl.Event {

    static public final TypeInfo typeInfo = new TypeInfo("zigbee.ZigbeeManager.StateChangedEvent:1.0.0", com.raritan.idl.idl.Event.typeInfo);

    @Override
    protected TypeInfo getClassTypeInfo() {
      return typeInfo;
    }

    public com.raritan.idl.zigbee.ZigbeeManager.DongleState oldState = com.raritan.idl.zigbee.ZigbeeManager.DongleState.values()[0];
    public com.raritan.idl.zigbee.ZigbeeManager.DongleState newState = com.raritan.idl.zigbee.ZigbeeManager.DongleState.values()[0];
  }

  public class GetMetaDataResult {
    public com.raritan.idl.zigbee.ZigbeeManager.MetaData _ret_;
  }

  GetMetaDataResult getMetaData() throws Exception;

  AsyncRequest getMetaData(AsyncRpcResponse<GetMetaDataResult> rsp);

  AsyncRequest getMetaData(AsyncRpcResponse<GetMetaDataResult> rsp, RpcCtrl rpcCtrl);


  public class GetDongleStateResult {
    public com.raritan.idl.zigbee.ZigbeeManager.DongleState _ret_;
  }

  GetDongleStateResult getDongleState() throws Exception;

  AsyncRequest getDongleState(AsyncRpcResponse<GetDongleStateResult> rsp);

  AsyncRequest getDongleState(AsyncRpcResponse<GetDongleStateResult> rsp, RpcCtrl rpcCtrl);


  public class GetSettingsResult {
    public com.raritan.idl.zigbee.ZigbeeManager.Settings _ret_;
  }

  GetSettingsResult getSettings() throws Exception;

  AsyncRequest getSettings(AsyncRpcResponse<GetSettingsResult> rsp);

  AsyncRequest getSettings(AsyncRpcResponse<GetSettingsResult> rsp, RpcCtrl rpcCtrl);


  public class SetSettingsResult {
    public int _ret_;
  }

  SetSettingsResult setSettings(com.raritan.idl.zigbee.ZigbeeManager.Settings settings) throws Exception;

  AsyncRequest setSettings(com.raritan.idl.zigbee.ZigbeeManager.Settings settings, AsyncRpcResponse<SetSettingsResult> rsp);

  AsyncRequest setSettings(com.raritan.idl.zigbee.ZigbeeManager.Settings settings, AsyncRpcResponse<SetSettingsResult> rsp, RpcCtrl rpcCtrl);


  public class AddDevicesResult {
    public java.util.List<Integer> _ret_;
  }

  AddDevicesResult addDevices(java.util.List<com.raritan.idl.zigbee.ZigbeeManager.DeviceRegistration> sensors) throws Exception;

  AsyncRequest addDevices(java.util.List<com.raritan.idl.zigbee.ZigbeeManager.DeviceRegistration> sensors, AsyncRpcResponse<AddDevicesResult> rsp);

  AsyncRequest addDevices(java.util.List<com.raritan.idl.zigbee.ZigbeeManager.DeviceRegistration> sensors, AsyncRpcResponse<AddDevicesResult> rsp, RpcCtrl rpcCtrl);


  public class RemoveDeviceResult {
    public int _ret_;
  }

  RemoveDeviceResult removeDevice(int sourceId) throws Exception;

  AsyncRequest removeDevice(int sourceId, AsyncRpcResponse<RemoveDeviceResult> rsp);

  AsyncRequest removeDevice(int sourceId, AsyncRpcResponse<RemoveDeviceResult> rsp, RpcCtrl rpcCtrl);


  public class GetRegisteredDevicesResult {
    public java.util.List<com.raritan.idl.zigbee.ZigbeeDevice> _ret_;
  }

  GetRegisteredDevicesResult getRegisteredDevices() throws Exception;

  AsyncRequest getRegisteredDevices(AsyncRpcResponse<GetRegisteredDevicesResult> rsp);

  AsyncRequest getRegisteredDevices(AsyncRpcResponse<GetRegisteredDevicesResult> rsp, RpcCtrl rpcCtrl);

}
