// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2025 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from ServerMonitor.idl.

package com.raritan.idl.servermon;

import com.raritan.idl.*;
import com.raritan.util.AsyncRequest;

public interface ServerMonitor_2_0_1 {
  static public final TypeInfo typeInfo = new TypeInfo("servermon.ServerMonitor:2.0.1", null);

  public enum ServerReachability {
    WAITING,
    REACHABLE,
    UNREACHABLE,
    ERROR;
  }

  public enum ServerPowerState {
    UNKNOWN,
    ON,
    OFF,
    SHUTTING_DOWN;
  }

  public enum ServerPowerControlResult {
    NO_ERROR,
    SHUTDOWN_CMD_FAILED,
    SWITCHING_OFF_FAILED,
    SWITCHING_ON_FAILED,
    POWER_CHECK_TIMEOUT;
  }

  public enum ServerPowerCheckMethod {
    TIMER,
    POWER_DROP;
  }

  static public class ServerPowerSettings implements Cloneable {
    public boolean enabled = false;
    public Object target = null;
    public com.raritan.idl.servermon.ServerMonitor_2_0_1.ServerPowerCheckMethod powerCheck = com.raritan.idl.servermon.ServerMonitor_2_0_1.ServerPowerCheckMethod.values()[0];
    public double powerThreshold = 0.0;
    public int timeout = 0;
    public String shutdownCmd = new String();
    public String username = new String();
    public String password = new String();
    public int sshPort = 0;

    public Object clone() {
      ServerPowerSettings copy = new ServerPowerSettings();

      copy.enabled = this.enabled;
      copy.target = this.target;
      copy.powerCheck = this.powerCheck;
      copy.powerThreshold = this.powerThreshold;
      copy.timeout = this.timeout;
      copy.shutdownCmd = this.shutdownCmd;
      copy.username = this.username;
      copy.password = this.password;
      copy.sshPort = this.sshPort;

      return copy;
    }

  }

  static public class ServerSettings implements Cloneable {
    public String host = new String();
    public boolean enabled = false;
    public int pingInterval = 0;
    public int retryInterval = 0;
    public int activationCount = 0;
    public int failureCount = 0;
    public int resumeDelay = 0;
    public int resumeCount = 0;
    public com.raritan.idl.servermon.ServerMonitor_2_0_1.ServerPowerSettings powerSettings = new com.raritan.idl.servermon.ServerMonitor_2_0_1.ServerPowerSettings();

    public Object clone() {
      ServerSettings copy = new ServerSettings();

      copy.host = this.host;
      copy.enabled = this.enabled;
      copy.pingInterval = this.pingInterval;
      copy.retryInterval = this.retryInterval;
      copy.activationCount = this.activationCount;
      copy.failureCount = this.failureCount;
      copy.resumeDelay = this.resumeDelay;
      copy.resumeCount = this.resumeCount;
      Object powerSettingsCopy = this.powerSettings.clone();
      copy.powerSettings = (com.raritan.idl.servermon.ServerMonitor_2_0_1.ServerPowerSettings) powerSettingsCopy;

      return copy;
    }

  }

  static public class ServerStatus implements Cloneable {
    public com.raritan.idl.servermon.ServerMonitor_2_0_1.ServerPowerState powerState = com.raritan.idl.servermon.ServerMonitor_2_0_1.ServerPowerState.values()[0];
    public com.raritan.idl.servermon.ServerMonitor_2_0_1.ServerPowerControlResult lastPowerControlResult = com.raritan.idl.servermon.ServerMonitor_2_0_1.ServerPowerControlResult.values()[0];
    public com.raritan.idl.servermon.ServerMonitor_2_0_1.ServerReachability reachable = com.raritan.idl.servermon.ServerMonitor_2_0_1.ServerReachability.values()[0];
    public java.util.Date lastRequest = new java.util.Date();
    public java.util.Date lastResponse = new java.util.Date();
    public int requests = 0;
    public int responses = 0;
    public int failures = 0;
    public int resumes = 0;

    public Object clone() {
      ServerStatus copy = new ServerStatus();

      copy.powerState = this.powerState;
      copy.lastPowerControlResult = this.lastPowerControlResult;
      copy.reachable = this.reachable;
      copy.lastRequest = this.lastRequest;
      copy.lastResponse = this.lastResponse;
      copy.requests = this.requests;
      copy.responses = this.responses;
      copy.failures = this.failures;
      copy.resumes = this.resumes;

      return copy;
    }

  }

  public class ServerPowerStateEvent extends com.raritan.idl.idl.Event {

    static public final TypeInfo typeInfo = new TypeInfo("servermon.ServerMonitor_2_0_1.ServerPowerStateEvent:1.0.0", com.raritan.idl.idl.Event.typeInfo);

    @Override
    protected TypeInfo getClassTypeInfo() {
      return typeInfo;
    }

    public int id = 0;
    public String host = new String();
    public com.raritan.idl.servermon.ServerMonitor_2_0_1.ServerPowerState oldPowerState = com.raritan.idl.servermon.ServerMonitor_2_0_1.ServerPowerState.values()[0];
    public com.raritan.idl.servermon.ServerMonitor_2_0_1.ServerPowerState newPowerState = com.raritan.idl.servermon.ServerMonitor_2_0_1.ServerPowerState.values()[0];
  }

  public class ServerPowerControlInitiatedEvent extends com.raritan.idl.event.UserEvent {

    static public final TypeInfo typeInfo = new TypeInfo("servermon.ServerMonitor_2_0_1.ServerPowerControlInitiatedEvent:1.0.0", com.raritan.idl.event.UserEvent.typeInfo);

    @Override
    protected TypeInfo getClassTypeInfo() {
      return typeInfo;
    }

    public int id = 0;
    public String host = new String();
    public boolean on = false;
  }

  public class ServerPowerControlCompletedEvent extends com.raritan.idl.idl.Event {

    static public final TypeInfo typeInfo = new TypeInfo("servermon.ServerMonitor_2_0_1.ServerPowerControlCompletedEvent:1.0.0", com.raritan.idl.idl.Event.typeInfo);

    @Override
    protected TypeInfo getClassTypeInfo() {
      return typeInfo;
    }

    public int id = 0;
    public String host = new String();
    public com.raritan.idl.servermon.ServerMonitor_2_0_1.ServerPowerControlResult result = com.raritan.idl.servermon.ServerMonitor_2_0_1.ServerPowerControlResult.values()[0];
  }

  public class ServerReachabilityEvent extends com.raritan.idl.idl.Event {

    static public final TypeInfo typeInfo = new TypeInfo("servermon.ServerMonitor_2_0_1.ServerReachabilityEvent:1.0.0", com.raritan.idl.idl.Event.typeInfo);

    @Override
    protected TypeInfo getClassTypeInfo() {
      return typeInfo;
    }

    public int id = 0;
    public String host = new String();
    public com.raritan.idl.servermon.ServerMonitor_2_0_1.ServerReachability reachable = com.raritan.idl.servermon.ServerMonitor_2_0_1.ServerReachability.values()[0];
  }

  public class ServerAddedEvent extends com.raritan.idl.event.UserEvent {

    static public final TypeInfo typeInfo = new TypeInfo("servermon.ServerMonitor_2_0_1.ServerAddedEvent:1.0.0", com.raritan.idl.event.UserEvent.typeInfo);

    @Override
    protected TypeInfo getClassTypeInfo() {
      return typeInfo;
    }

    public int id = 0;
    public com.raritan.idl.servermon.ServerMonitor_2_0_1.ServerSettings settings = new com.raritan.idl.servermon.ServerMonitor_2_0_1.ServerSettings();
  }

  public class ServerSettingsChangedEvent extends com.raritan.idl.event.UserEvent {

    static public final TypeInfo typeInfo = new TypeInfo("servermon.ServerMonitor_2_0_1.ServerSettingsChangedEvent:1.0.0", com.raritan.idl.event.UserEvent.typeInfo);

    @Override
    protected TypeInfo getClassTypeInfo() {
      return typeInfo;
    }

    public int id = 0;
    public com.raritan.idl.servermon.ServerMonitor_2_0_1.ServerSettings oldSettings = new com.raritan.idl.servermon.ServerMonitor_2_0_1.ServerSettings();
    public com.raritan.idl.servermon.ServerMonitor_2_0_1.ServerSettings newSettings = new com.raritan.idl.servermon.ServerMonitor_2_0_1.ServerSettings();
  }

  public class ServerDeletedEvent extends com.raritan.idl.event.UserEvent {

    static public final TypeInfo typeInfo = new TypeInfo("servermon.ServerMonitor_2_0_1.ServerDeletedEvent:1.0.0", com.raritan.idl.event.UserEvent.typeInfo);

    @Override
    protected TypeInfo getClassTypeInfo() {
      return typeInfo;
    }

    public int id = 0;
  }

  static public class Server implements Cloneable {
    public com.raritan.idl.servermon.ServerMonitor_2_0_1.ServerSettings settings = new com.raritan.idl.servermon.ServerMonitor_2_0_1.ServerSettings();
    public com.raritan.idl.servermon.ServerMonitor_2_0_1.ServerStatus status = new com.raritan.idl.servermon.ServerMonitor_2_0_1.ServerStatus();

    public Object clone() {
      Server copy = new Server();

      Object settingsCopy = this.settings.clone();
      copy.settings = (com.raritan.idl.servermon.ServerMonitor_2_0_1.ServerSettings) settingsCopy;
      Object statusCopy = this.status.clone();
      copy.status = (com.raritan.idl.servermon.ServerMonitor_2_0_1.ServerStatus) statusCopy;

      return copy;
    }

  }

  public static final int ERR_NO_SUCH_ID = 1;

  public static final int ERR_INVALID_SETTINGS = 2;

  public static final int ERR_DUPLICATE_HOSTNAME = 3;

  public static final int ERR_MAX_SERVERS_REACHED = 4;

  public class AddServerResult {
    public int _ret_;
    public int id;
  }

  AddServerResult addServer(com.raritan.idl.servermon.ServerMonitor_2_0_1.ServerSettings settings) throws Exception;

  AsyncRequest addServer(com.raritan.idl.servermon.ServerMonitor_2_0_1.ServerSettings settings, AsyncRpcResponse<AddServerResult> rsp);

  AsyncRequest addServer(com.raritan.idl.servermon.ServerMonitor_2_0_1.ServerSettings settings, AsyncRpcResponse<AddServerResult> rsp, RpcCtrl rpcCtrl);


  public class ModifyServerResult {
    public int _ret_;
  }

  ModifyServerResult modifyServer(int id, com.raritan.idl.servermon.ServerMonitor_2_0_1.ServerSettings settings) throws Exception;

  AsyncRequest modifyServer(int id, com.raritan.idl.servermon.ServerMonitor_2_0_1.ServerSettings settings, AsyncRpcResponse<ModifyServerResult> rsp);

  AsyncRequest modifyServer(int id, com.raritan.idl.servermon.ServerMonitor_2_0_1.ServerSettings settings, AsyncRpcResponse<ModifyServerResult> rsp, RpcCtrl rpcCtrl);


  public class DeleteServerResult {
    public int _ret_;
  }

  DeleteServerResult deleteServer(int id) throws Exception;

  AsyncRequest deleteServer(int id, AsyncRpcResponse<DeleteServerResult> rsp);

  AsyncRequest deleteServer(int id, AsyncRpcResponse<DeleteServerResult> rsp, RpcCtrl rpcCtrl);


  public class GetServerResult {
    public int _ret_;
    public com.raritan.idl.servermon.ServerMonitor_2_0_1.Server server;
  }

  GetServerResult getServer(int id) throws Exception;

  AsyncRequest getServer(int id, AsyncRpcResponse<GetServerResult> rsp);

  AsyncRequest getServer(int id, AsyncRpcResponse<GetServerResult> rsp, RpcCtrl rpcCtrl);


  public class ListServersResult {
    public java.util.Map<Integer, com.raritan.idl.servermon.ServerMonitor_2_0_1.Server> _ret_;
  }

  ListServersResult listServers() throws Exception;

  AsyncRequest listServers(AsyncRpcResponse<ListServersResult> rsp);

  AsyncRequest listServers(AsyncRpcResponse<ListServersResult> rsp, RpcCtrl rpcCtrl);


  public class PowerControlResult {
    public int _ret_;
  }

  PowerControlResult powerControl(int id, boolean on) throws Exception;

  AsyncRequest powerControl(int id, boolean on, AsyncRpcResponse<PowerControlResult> rsp);

  AsyncRequest powerControl(int id, boolean on, AsyncRpcResponse<PowerControlResult> rsp, RpcCtrl rpcCtrl);

}
