// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2025 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from Security.idl.

package com.raritan.idl.security;

import com.raritan.idl.*;
import com.raritan.util.AsyncRequest;

public interface Security {
  static public final TypeInfo typeInfo = new TypeInfo("security.Security:1.0.0", null);

  public static final int ERR_INVALID_VALUE = 1;

  static public class Settings implements Cloneable {
    public boolean http2httpsRedir = false;
    public int userBlockTimeout = 0;
    public int userMaxFailedLogins = 0;
    public com.raritan.idl.security.IpFw ipFw = new com.raritan.idl.security.IpFw();
    public com.raritan.idl.security.RoleAccessControl roleAccessControl = new com.raritan.idl.security.RoleAccessControl();
    public com.raritan.idl.security.PasswordSettings pwSettings = new com.raritan.idl.security.PasswordSettings();
    public int idleTimeout = 0;
    public boolean singleLogin = false;
    public com.raritan.idl.security.SSHSettings sshSettings = new com.raritan.idl.security.SSHSettings();

    public Object clone() {
      Settings copy = new Settings();

      copy.http2httpsRedir = this.http2httpsRedir;
      copy.userBlockTimeout = this.userBlockTimeout;
      copy.userMaxFailedLogins = this.userMaxFailedLogins;
      Object ipFwCopy = this.ipFw.clone();
      copy.ipFw = (com.raritan.idl.security.IpFw) ipFwCopy;
      Object roleAccessControlCopy = this.roleAccessControl.clone();
      copy.roleAccessControl = (com.raritan.idl.security.RoleAccessControl) roleAccessControlCopy;
      Object pwSettingsCopy = this.pwSettings.clone();
      copy.pwSettings = (com.raritan.idl.security.PasswordSettings) pwSettingsCopy;
      copy.idleTimeout = this.idleTimeout;
      copy.singleLogin = this.singleLogin;
      Object sshSettingsCopy = this.sshSettings.clone();
      copy.sshSettings = (com.raritan.idl.security.SSHSettings) sshSettingsCopy;

      return copy;
    }

  }

  public class GetSettingsResult {
    public com.raritan.idl.security.Security.Settings _ret_;
  }

  GetSettingsResult getSettings() throws Exception;

  AsyncRequest getSettings(AsyncRpcResponse<GetSettingsResult> rsp);

  AsyncRequest getSettings(AsyncRpcResponse<GetSettingsResult> rsp, RpcCtrl rpcCtrl);


  public class SetSettingsResult {
    public int _ret_;
  }

  SetSettingsResult setSettings(com.raritan.idl.security.Security.Settings settings) throws Exception;

  AsyncRequest setSettings(com.raritan.idl.security.Security.Settings settings, AsyncRpcResponse<SetSettingsResult> rsp);

  AsyncRequest setSettings(com.raritan.idl.security.Security.Settings settings, AsyncRpcResponse<SetSettingsResult> rsp, RpcCtrl rpcCtrl);

  Void setHttpRedirSettings(boolean http2httpsRedir) throws Exception;

  AsyncRequest setHttpRedirSettings(boolean http2httpsRedir, AsyncRpcResponse<Void> rsp);

  AsyncRequest setHttpRedirSettings(boolean http2httpsRedir, AsyncRpcResponse<Void> rsp, RpcCtrl rpcCtrl);


  public class SetIpFwSettingsResult {
    public int _ret_;
  }

  SetIpFwSettingsResult setIpFwSettings(com.raritan.idl.security.IpFw ipFw) throws Exception;

  AsyncRequest setIpFwSettings(com.raritan.idl.security.IpFw ipFw, AsyncRpcResponse<SetIpFwSettingsResult> rsp);

  AsyncRequest setIpFwSettings(com.raritan.idl.security.IpFw ipFw, AsyncRpcResponse<SetIpFwSettingsResult> rsp, RpcCtrl rpcCtrl);


  public class SetRoleAccessControlSettingsResult {
    public int _ret_;
  }

  SetRoleAccessControlSettingsResult setRoleAccessControlSettings(com.raritan.idl.security.RoleAccessControl settings) throws Exception;

  AsyncRequest setRoleAccessControlSettings(com.raritan.idl.security.RoleAccessControl settings, AsyncRpcResponse<SetRoleAccessControlSettingsResult> rsp);

  AsyncRequest setRoleAccessControlSettings(com.raritan.idl.security.RoleAccessControl settings, AsyncRpcResponse<SetRoleAccessControlSettingsResult> rsp, RpcCtrl rpcCtrl);


  public class SetBlockSettingsResult {
    public int _ret_;
  }

  SetBlockSettingsResult setBlockSettings(int blockTimeout, int maxFailedLogins) throws Exception;

  AsyncRequest setBlockSettings(int blockTimeout, int maxFailedLogins, AsyncRpcResponse<SetBlockSettingsResult> rsp);

  AsyncRequest setBlockSettings(int blockTimeout, int maxFailedLogins, AsyncRpcResponse<SetBlockSettingsResult> rsp, RpcCtrl rpcCtrl);


  public class SetPwSettingsResult {
    public int _ret_;
  }

  SetPwSettingsResult setPwSettings(com.raritan.idl.security.PasswordSettings pwSettings) throws Exception;

  AsyncRequest setPwSettings(com.raritan.idl.security.PasswordSettings pwSettings, AsyncRpcResponse<SetPwSettingsResult> rsp);

  AsyncRequest setPwSettings(com.raritan.idl.security.PasswordSettings pwSettings, AsyncRpcResponse<SetPwSettingsResult> rsp, RpcCtrl rpcCtrl);


  public class SetIdleTimeoutSettingsResult {
    public int _ret_;
  }

  SetIdleTimeoutSettingsResult setIdleTimeoutSettings(int idleTimeout) throws Exception;

  AsyncRequest setIdleTimeoutSettings(int idleTimeout, AsyncRpcResponse<SetIdleTimeoutSettingsResult> rsp);

  AsyncRequest setIdleTimeoutSettings(int idleTimeout, AsyncRpcResponse<SetIdleTimeoutSettingsResult> rsp, RpcCtrl rpcCtrl);

  Void setSingleLoginLimitation(boolean singleLogin) throws Exception;

  AsyncRequest setSingleLoginLimitation(boolean singleLogin, AsyncRpcResponse<Void> rsp);

  AsyncRequest setSingleLoginLimitation(boolean singleLogin, AsyncRpcResponse<Void> rsp, RpcCtrl rpcCtrl);


  public class GetIdleTimeoutSettingsResult {
    public int _ret_;
  }

  GetIdleTimeoutSettingsResult getIdleTimeoutSettings() throws Exception;

  AsyncRequest getIdleTimeoutSettings(AsyncRpcResponse<GetIdleTimeoutSettingsResult> rsp);

  AsyncRequest getIdleTimeoutSettings(AsyncRpcResponse<GetIdleTimeoutSettingsResult> rsp, RpcCtrl rpcCtrl);


  public class GetHttpRedirSettingsResult {
    public boolean _ret_;
  }

  GetHttpRedirSettingsResult getHttpRedirSettings() throws Exception;

  AsyncRequest getHttpRedirSettings(AsyncRpcResponse<GetHttpRedirSettingsResult> rsp);

  AsyncRequest getHttpRedirSettings(AsyncRpcResponse<GetHttpRedirSettingsResult> rsp, RpcCtrl rpcCtrl);


  public class GetBlockSettingsResult {
    public int blockTimeout;
    public int maxFailedLogins;
  }

  GetBlockSettingsResult getBlockSettings() throws Exception;

  AsyncRequest getBlockSettings(AsyncRpcResponse<GetBlockSettingsResult> rsp);

  AsyncRequest getBlockSettings(AsyncRpcResponse<GetBlockSettingsResult> rsp, RpcCtrl rpcCtrl);


  public class GetSSHSettingsResult {
    public com.raritan.idl.security.SSHSettings _ret_;
  }

  GetSSHSettingsResult getSSHSettings() throws Exception;

  AsyncRequest getSSHSettings(AsyncRpcResponse<GetSSHSettingsResult> rsp);

  AsyncRequest getSSHSettings(AsyncRpcResponse<GetSSHSettingsResult> rsp, RpcCtrl rpcCtrl);

  Void setSSHSettings(com.raritan.idl.security.SSHSettings settings) throws Exception;

  AsyncRequest setSSHSettings(com.raritan.idl.security.SSHSettings settings, AsyncRpcResponse<Void> rsp);

  AsyncRequest setSSHSettings(com.raritan.idl.security.SSHSettings settings, AsyncRpcResponse<Void> rsp, RpcCtrl rpcCtrl);

}
