// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2025 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from VoltageMonitoringSensor.idl.

package com.raritan.idl.pdumodel;

import com.raritan.idl.*;
import com.raritan.util.AsyncRequest;

public interface VoltageMonitoringSensor extends com.raritan.idl.sensors.NumericSensor_4_0_5 {
  static public final TypeInfo typeInfo = new TypeInfo("pdumodel.VoltageMonitoringSensor:1.0.0", com.raritan.idl.sensors.NumericSensor_4_0_5.typeInfo);

  public enum EventType {
    DIP,
    SWELL,
    UNKNOWN;
  }

  static public class DipSwellThresholds implements Cloneable {
    public boolean dipActive = false;
    public double dipThreshold = 0.0;
    public boolean swellActive = false;
    public double swellThreshold = 0.0;
    public float deassertionHysteresis = 0.0f;

    public Object clone() {
      DipSwellThresholds copy = new DipSwellThresholds();

      copy.dipActive = this.dipActive;
      copy.dipThreshold = this.dipThreshold;
      copy.swellActive = this.swellActive;
      copy.swellThreshold = this.swellThreshold;
      copy.deassertionHysteresis = this.deassertionHysteresis;

      return copy;
    }

  }

  static public class Event implements Cloneable {
    public com.raritan.idl.pdumodel.VoltageMonitoringSensor.EventType type = com.raritan.idl.pdumodel.VoltageMonitoringSensor.EventType.values()[0];
    public java.util.Date timestamp = new java.util.Date();
    public int duration = 0;
    public double voltage = 0.0;
    public com.raritan.idl.pdumodel.Waveform waveform = new com.raritan.idl.pdumodel.Waveform();

    public Object clone() {
      Event copy = new Event();

      copy.type = this.type;
      copy.timestamp = this.timestamp;
      copy.duration = this.duration;
      copy.voltage = this.voltage;
      Object waveformCopy = this.waveform.clone();
      copy.waveform = (com.raritan.idl.pdumodel.Waveform) waveformCopy;

      return copy;
    }

  }

  public class EventOccurredEvent extends com.raritan.idl.idl.Event {

    static public final TypeInfo typeInfo = new TypeInfo("pdumodel.VoltageMonitoringSensor.EventOccurredEvent:1.0.0", com.raritan.idl.idl.Event.typeInfo);

    @Override
    protected TypeInfo getClassTypeInfo() {
      return typeInfo;
    }

    public com.raritan.idl.pdumodel.VoltageMonitoringSensor.Event event = new com.raritan.idl.pdumodel.VoltageMonitoringSensor.Event();
  }

  public class EventListClearedEvent extends com.raritan.idl.event.UserEvent {

    static public final TypeInfo typeInfo = new TypeInfo("pdumodel.VoltageMonitoringSensor.EventListClearedEvent:1.0.0", com.raritan.idl.event.UserEvent.typeInfo);

    @Override
    protected TypeInfo getClassTypeInfo() {
      return typeInfo;
    }

  }

  public class DipSwellThresholdsChangedEvent extends com.raritan.idl.event.UserEvent {

    static public final TypeInfo typeInfo = new TypeInfo("pdumodel.VoltageMonitoringSensor.DipSwellThresholdsChangedEvent:1.0.0", com.raritan.idl.event.UserEvent.typeInfo);

    @Override
    protected TypeInfo getClassTypeInfo() {
      return typeInfo;
    }

    public com.raritan.idl.pdumodel.VoltageMonitoringSensor.DipSwellThresholds oldThresholds = new com.raritan.idl.pdumodel.VoltageMonitoringSensor.DipSwellThresholds();
    public com.raritan.idl.pdumodel.VoltageMonitoringSensor.DipSwellThresholds newThresholds = new com.raritan.idl.pdumodel.VoltageMonitoringSensor.DipSwellThresholds();
  }

  public class GetRecentEventsResult {
    public java.util.List<com.raritan.idl.pdumodel.VoltageMonitoringSensor.Event> _ret_;
  }

  GetRecentEventsResult getRecentEvents() throws Exception;

  AsyncRequest getRecentEvents(AsyncRpcResponse<GetRecentEventsResult> rsp);

  AsyncRequest getRecentEvents(AsyncRpcResponse<GetRecentEventsResult> rsp, RpcCtrl rpcCtrl);

  Void clearRecentEvents() throws Exception;

  AsyncRequest clearRecentEvents(AsyncRpcResponse<Void> rsp);

  AsyncRequest clearRecentEvents(AsyncRpcResponse<Void> rsp, RpcCtrl rpcCtrl);


  public class GetDipSwellThresholdsResult {
    public com.raritan.idl.pdumodel.VoltageMonitoringSensor.DipSwellThresholds _ret_;
  }

  GetDipSwellThresholdsResult getDipSwellThresholds() throws Exception;

  AsyncRequest getDipSwellThresholds(AsyncRpcResponse<GetDipSwellThresholdsResult> rsp);

  AsyncRequest getDipSwellThresholds(AsyncRpcResponse<GetDipSwellThresholdsResult> rsp, RpcCtrl rpcCtrl);


  public class SetDipSwellThresholdsResult {
    public int _ret_;
  }

  SetDipSwellThresholdsResult setDipSwellThresholds(com.raritan.idl.pdumodel.VoltageMonitoringSensor.DipSwellThresholds thresholds) throws Exception;

  AsyncRequest setDipSwellThresholds(com.raritan.idl.pdumodel.VoltageMonitoringSensor.DipSwellThresholds thresholds, AsyncRpcResponse<SetDipSwellThresholdsResult> rsp);

  AsyncRequest setDipSwellThresholds(com.raritan.idl.pdumodel.VoltageMonitoringSensor.DipSwellThresholds thresholds, AsyncRpcResponse<SetDipSwellThresholdsResult> rsp, RpcCtrl rpcCtrl);

}
