// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2025 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from PowerMeter.idl.

package com.raritan.idl.pdumodel;

import com.raritan.idl.*;
import com.raritan.util.AsyncRequest;

public interface PowerMeter_1_1_4 {
  static public final TypeInfo typeInfo = new TypeInfo("pdumodel.PowerMeter:1.1.4", null);

  public static final int ERR_INVALID_PARAM = 1;

  public static final int ERR_MODBUS_UNIT_IN_USE = 2;

  public enum Type {
    ONE_PHASE,
    SPLIT_PHASE,
    THREE_PHASE;
  }

  static public class Config implements Cloneable {
    public int powerMeterId = 0;
    public com.raritan.idl.pdumodel.PowerMeter_1_1_4.Type type = com.raritan.idl.pdumodel.PowerMeter_1_1_4.Type.values()[0];

    public Object clone() {
      Config copy = new Config();

      copy.powerMeterId = this.powerMeterId;
      copy.type = this.type;

      return copy;
    }

  }

  public class GetConfigResult {
    public com.raritan.idl.pdumodel.PowerMeter_1_1_4.Config _ret_;
  }

  GetConfigResult getConfig() throws Exception;

  AsyncRequest getConfig(AsyncRpcResponse<GetConfigResult> rsp);

  AsyncRequest getConfig(AsyncRpcResponse<GetConfigResult> rsp, RpcCtrl rpcCtrl);


  static public class Sensors implements Cloneable {
    public com.raritan.idl.sensors.NumericSensor_4_0_2 voltage = null;
    public com.raritan.idl.sensors.NumericSensor_4_0_2 lineFrequency = null;
    public com.raritan.idl.sensors.NumericSensor_4_0_2 current = null;
    public com.raritan.idl.sensors.NumericSensor_4_0_2 activePower = null;
    public com.raritan.idl.sensors.NumericSensor_4_0_2 reactivePower = null;
    public com.raritan.idl.sensors.NumericSensor_4_0_2 apparentPower = null;
    public com.raritan.idl.sensors.NumericSensor_4_0_2 powerFactor = null;
    public com.raritan.idl.sensors.NumericSensor_4_0_2 phaseAngle = null;
    public com.raritan.idl.sensors.NumericSensor_4_0_2 displacementPowerFactor = null;
    public com.raritan.idl.sensors.NumericSensor_4_0_2 activeEnergy = null;
    public com.raritan.idl.sensors.NumericSensor_4_0_2 unbalancedCurrent = null;
    public com.raritan.idl.sensors.StateSensor_4_0_2 powerQuality = null;

    public Object clone() {
      Sensors copy = new Sensors();

      copy.voltage = this.voltage;
      copy.lineFrequency = this.lineFrequency;
      copy.current = this.current;
      copy.activePower = this.activePower;
      copy.reactivePower = this.reactivePower;
      copy.apparentPower = this.apparentPower;
      copy.powerFactor = this.powerFactor;
      copy.phaseAngle = this.phaseAngle;
      copy.displacementPowerFactor = this.displacementPowerFactor;
      copy.activeEnergy = this.activeEnergy;
      copy.unbalancedCurrent = this.unbalancedCurrent;
      copy.powerQuality = this.powerQuality;

      return copy;
    }

  }

  public class GetSensorsResult {
    public com.raritan.idl.pdumodel.PowerMeter_1_1_4.Sensors _ret_;
  }

  GetSensorsResult getSensors() throws Exception;

  AsyncRequest getSensors(AsyncRpcResponse<GetSensorsResult> rsp);

  AsyncRequest getSensors(AsyncRpcResponse<GetSensorsResult> rsp, RpcCtrl rpcCtrl);


  public class GetPolesResult {
    public java.util.List<com.raritan.idl.pdumodel.Pole_4_0_2> _ret_;
  }

  GetPolesResult getPoles() throws Exception;

  AsyncRequest getPoles(AsyncRpcResponse<GetPolesResult> rsp);

  AsyncRequest getPoles(AsyncRpcResponse<GetPolesResult> rsp, RpcCtrl rpcCtrl);


  public class GetControllersResult {
    public java.util.List<com.raritan.idl.pdumodel.Controller_4_0_1> _ret_;
  }

  GetControllersResult getControllers() throws Exception;

  AsyncRequest getControllers(AsyncRpcResponse<GetControllersResult> rsp);

  AsyncRequest getControllers(AsyncRpcResponse<GetControllersResult> rsp, RpcCtrl rpcCtrl);


  static public class Settings implements Cloneable {
    public String name = new String();
    public int currentRating = 0;
    public int phaseCtRating = 0;
    public int neutralCtRating = 0;
    public int earthCtRating = 0;
    public int modbusUnitAddress = 0;

    public Object clone() {
      Settings copy = new Settings();

      copy.name = this.name;
      copy.currentRating = this.currentRating;
      copy.phaseCtRating = this.phaseCtRating;
      copy.neutralCtRating = this.neutralCtRating;
      copy.earthCtRating = this.earthCtRating;
      copy.modbusUnitAddress = this.modbusUnitAddress;

      return copy;
    }

  }

  public class SettingsChangedEvent extends com.raritan.idl.event.UserEvent {

    static public final TypeInfo typeInfo = new TypeInfo("pdumodel.PowerMeter_1_1_4.SettingsChangedEvent:1.0.0", com.raritan.idl.event.UserEvent.typeInfo);

    @Override
    protected TypeInfo getClassTypeInfo() {
      return typeInfo;
    }

    public com.raritan.idl.pdumodel.PowerMeter_1_1_4.Settings oldSettings = new com.raritan.idl.pdumodel.PowerMeter_1_1_4.Settings();
    public com.raritan.idl.pdumodel.PowerMeter_1_1_4.Settings newSettings = new com.raritan.idl.pdumodel.PowerMeter_1_1_4.Settings();
  }

  public class GetSettingsResult {
    public com.raritan.idl.pdumodel.PowerMeter_1_1_4.Settings _ret_;
  }

  GetSettingsResult getSettings() throws Exception;

  AsyncRequest getSettings(AsyncRpcResponse<GetSettingsResult> rsp);

  AsyncRequest getSettings(AsyncRpcResponse<GetSettingsResult> rsp, RpcCtrl rpcCtrl);


  public class SetSettingsResult {
    public int _ret_;
  }

  SetSettingsResult setSettings(com.raritan.idl.pdumodel.PowerMeter_1_1_4.Settings settings) throws Exception;

  AsyncRequest setSettings(com.raritan.idl.pdumodel.PowerMeter_1_1_4.Settings settings, AsyncRpcResponse<SetSettingsResult> rsp);

  AsyncRequest setSettings(com.raritan.idl.pdumodel.PowerMeter_1_1_4.Settings settings, AsyncRpcResponse<SetSettingsResult> rsp, RpcCtrl rpcCtrl);


  static public class EnergyPulseSettings implements Cloneable {
    public boolean pulseEnabled = false;
    public java.util.List<Integer> poles = new java.util.ArrayList<>();
    public int pulsesPerKWh = 0;

    public Object clone() {
      EnergyPulseSettings copy = new EnergyPulseSettings();

      copy.pulseEnabled = this.pulseEnabled;
      copy.poles = new java.util.ArrayList<Integer>(this.poles);
      copy.pulsesPerKWh = this.pulsesPerKWh;

      return copy;
    }

  }

  public class EnergyPulseSettingsChangedEvent extends com.raritan.idl.event.UserEvent {

    static public final TypeInfo typeInfo = new TypeInfo("pdumodel.PowerMeter_1_1_4.EnergyPulseSettingsChangedEvent:1.0.0", com.raritan.idl.event.UserEvent.typeInfo);

    @Override
    protected TypeInfo getClassTypeInfo() {
      return typeInfo;
    }

    public com.raritan.idl.pdumodel.PowerMeter_1_1_4.EnergyPulseSettings oldSettings = new com.raritan.idl.pdumodel.PowerMeter_1_1_4.EnergyPulseSettings();
    public com.raritan.idl.pdumodel.PowerMeter_1_1_4.EnergyPulseSettings newSettings = new com.raritan.idl.pdumodel.PowerMeter_1_1_4.EnergyPulseSettings();
  }

  public class GetEnergyPulseSettingsResult {
    public com.raritan.idl.pdumodel.PowerMeter_1_1_4.EnergyPulseSettings _ret_;
  }

  GetEnergyPulseSettingsResult getEnergyPulseSettings() throws Exception;

  AsyncRequest getEnergyPulseSettings(AsyncRpcResponse<GetEnergyPulseSettingsResult> rsp);

  AsyncRequest getEnergyPulseSettings(AsyncRpcResponse<GetEnergyPulseSettingsResult> rsp, RpcCtrl rpcCtrl);


  public class SetEnergyPulseSettingsResult {
    public int _ret_;
  }

  SetEnergyPulseSettingsResult setEnergyPulseSettings(com.raritan.idl.pdumodel.PowerMeter_1_1_4.EnergyPulseSettings settings) throws Exception;

  AsyncRequest setEnergyPulseSettings(com.raritan.idl.pdumodel.PowerMeter_1_1_4.EnergyPulseSettings settings, AsyncRpcResponse<SetEnergyPulseSettingsResult> rsp);

  AsyncRequest setEnergyPulseSettings(com.raritan.idl.pdumodel.PowerMeter_1_1_4.EnergyPulseSettings settings, AsyncRpcResponse<SetEnergyPulseSettingsResult> rsp, RpcCtrl rpcCtrl);

}
