// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2025 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from PowerMeterController.idl.

package com.raritan.idl.pdumodel;

import com.raritan.idl.*;
import com.raritan.util.AsyncRequest;

public interface PowerMeterController {
  static public final TypeInfo typeInfo = new TypeInfo("pdumodel.PowerMeterController:1.0.0", null);

  public static final int ERR_INVALID_PARAM = 1;

  public static final int ERR_METER_BOARD_BUSY = 2;

  static public class ScanResult implements Cloneable {
    public boolean present = false;
    public int meterCount = 0;

    public Object clone() {
      ScanResult copy = new ScanResult();

      copy.present = this.present;
      copy.meterCount = this.meterCount;

      return copy;
    }

  }

  public class ScanMeterBoardResult {
    public int _ret_;
    public com.raritan.idl.pdumodel.PowerMeterController.ScanResult result;
  }

  ScanMeterBoardResult scanMeterBoard(int powerMeterId) throws Exception;

  AsyncRequest scanMeterBoard(int powerMeterId, AsyncRpcResponse<ScanMeterBoardResult> rsp);

  AsyncRequest scanMeterBoard(int powerMeterId, AsyncRpcResponse<ScanMeterBoardResult> rsp, RpcCtrl rpcCtrl);


  public class PowerMeterCreatedEvent extends com.raritan.idl.event.UserEvent {

    static public final TypeInfo typeInfo = new TypeInfo("pdumodel.PowerMeterController.PowerMeterCreatedEvent:1.0.0", com.raritan.idl.event.UserEvent.typeInfo);

    @Override
    protected TypeInfo getClassTypeInfo() {
      return typeInfo;
    }

    public com.raritan.idl.pdumodel.PowerMeter powerMeter = null;
    public com.raritan.idl.pdumodel.PowerMeter.Config config = new com.raritan.idl.pdumodel.PowerMeter.Config();
    public com.raritan.idl.pdumodel.PowerMeter.Settings settings = new com.raritan.idl.pdumodel.PowerMeter.Settings();
  }

  public class PowerMeterDeletedEvent extends com.raritan.idl.event.UserEvent {

    static public final TypeInfo typeInfo = new TypeInfo("pdumodel.PowerMeterController.PowerMeterDeletedEvent:1.0.0", com.raritan.idl.event.UserEvent.typeInfo);

    @Override
    protected TypeInfo getClassTypeInfo() {
      return typeInfo;
    }

    public com.raritan.idl.pdumodel.PowerMeter.Config config = new com.raritan.idl.pdumodel.PowerMeter.Config();
    public com.raritan.idl.pdumodel.PowerMeter.Settings settings = new com.raritan.idl.pdumodel.PowerMeter.Settings();
  }

  public class PanelCreatedEvent extends com.raritan.idl.pdumodel.PowerMeterController.PowerMeterCreatedEvent {

    static public final TypeInfo typeInfo = new TypeInfo("pdumodel.PowerMeterController.PanelCreatedEvent:1.0.0", com.raritan.idl.pdumodel.PowerMeterController.PowerMeterCreatedEvent.typeInfo);

    @Override
    protected TypeInfo getClassTypeInfo() {
      return typeInfo;
    }

    public com.raritan.idl.pdumodel.Panel.PanelSettings panelSettings = new com.raritan.idl.pdumodel.Panel.PanelSettings();
  }

  public class PanelDeletedEvent extends com.raritan.idl.pdumodel.PowerMeterController.PowerMeterDeletedEvent {

    static public final TypeInfo typeInfo = new TypeInfo("pdumodel.PowerMeterController.PanelDeletedEvent:1.0.0", com.raritan.idl.pdumodel.PowerMeterController.PowerMeterDeletedEvent.typeInfo);

    @Override
    protected TypeInfo getClassTypeInfo() {
      return typeInfo;
    }

    public com.raritan.idl.pdumodel.Panel.PanelSettings panelSettings = new com.raritan.idl.pdumodel.Panel.PanelSettings();
  }

  public class GetPowerMetersResult {
    public java.util.Map<Integer, com.raritan.idl.pdumodel.PowerMeter> _ret_;
  }

  GetPowerMetersResult getPowerMeters() throws Exception;

  AsyncRequest getPowerMeters(AsyncRpcResponse<GetPowerMetersResult> rsp);

  AsyncRequest getPowerMeters(AsyncRpcResponse<GetPowerMetersResult> rsp, RpcCtrl rpcCtrl);


  public class CreatePowerMeterResult {
    public int _ret_;
    public com.raritan.idl.pdumodel.PowerMeter powerMeter;
  }

  CreatePowerMeterResult createPowerMeter(com.raritan.idl.pdumodel.PowerMeter.Config config, com.raritan.idl.pdumodel.PowerMeter.Settings settings) throws Exception;

  AsyncRequest createPowerMeter(com.raritan.idl.pdumodel.PowerMeter.Config config, com.raritan.idl.pdumodel.PowerMeter.Settings settings, AsyncRpcResponse<CreatePowerMeterResult> rsp);

  AsyncRequest createPowerMeter(com.raritan.idl.pdumodel.PowerMeter.Config config, com.raritan.idl.pdumodel.PowerMeter.Settings settings, AsyncRpcResponse<CreatePowerMeterResult> rsp, RpcCtrl rpcCtrl);


  public class CreatePanelResult {
    public int _ret_;
    public com.raritan.idl.pdumodel.Panel panel;
  }

  CreatePanelResult createPanel(com.raritan.idl.pdumodel.PowerMeter.Config config, com.raritan.idl.pdumodel.PowerMeter.Settings powerMeterSettings, com.raritan.idl.pdumodel.Panel.PanelSettings panelSettings) throws Exception;

  AsyncRequest createPanel(com.raritan.idl.pdumodel.PowerMeter.Config config, com.raritan.idl.pdumodel.PowerMeter.Settings powerMeterSettings, com.raritan.idl.pdumodel.Panel.PanelSettings panelSettings, AsyncRpcResponse<CreatePanelResult> rsp);

  AsyncRequest createPanel(com.raritan.idl.pdumodel.PowerMeter.Config config, com.raritan.idl.pdumodel.PowerMeter.Settings powerMeterSettings, com.raritan.idl.pdumodel.Panel.PanelSettings panelSettings, AsyncRpcResponse<CreatePanelResult> rsp, RpcCtrl rpcCtrl);


  public class DeletePowerMeterResult {
    public int _ret_;
  }

  DeletePowerMeterResult deletePowerMeter(int powerMeterId) throws Exception;

  AsyncRequest deletePowerMeter(int powerMeterId, AsyncRpcResponse<DeletePowerMeterResult> rsp);

  AsyncRequest deletePowerMeter(int powerMeterId, AsyncRpcResponse<DeletePowerMeterResult> rsp, RpcCtrl rpcCtrl);

}
