// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2025 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from DataPushService.idl.

package com.raritan.idl.event;

import com.raritan.idl.*;
import com.raritan.util.AsyncRequest;

public interface DataPushService {
  static public final TypeInfo typeInfo = new TypeInfo("event.DataPushService:1.0.0", null);

  public enum EntryType {
    SENSORLIST,
    SENSORLOG,
    AMSLIST,
    AMSLOG,
    AUDITLOG;
  }

  public static final int ERR_NO_SUCH_ID = 1;

  public static final int ERR_INVALID_PARAMS = 2;

  public static final int ERR_MAX_ENTRIES_REACHED = 3;

  static public class EntrySettings implements Cloneable {
    public String url = new String();
    public boolean allowOffTimeRangeCerts = false;
    public String caCertChain = new String();
    public boolean useAuth = false;
    public String username = new String();
    public String password = new String();
    public com.raritan.idl.event.DataPushService.EntryType type = com.raritan.idl.event.DataPushService.EntryType.values()[0];
    public java.util.List<String> items = new java.util.ArrayList<>();

    public Object clone() {
      EntrySettings copy = new EntrySettings();

      copy.url = this.url;
      copy.allowOffTimeRangeCerts = this.allowOffTimeRangeCerts;
      copy.caCertChain = this.caCertChain;
      copy.useAuth = this.useAuth;
      copy.username = this.username;
      copy.password = this.password;
      copy.type = this.type;
      copy.items = new java.util.ArrayList<String>(this.items);

      return copy;
    }

  }

  public class AddEntryResult {
    public int _ret_;
    public int entryId;
  }

  AddEntryResult addEntry(com.raritan.idl.event.DataPushService.EntrySettings entrySettings) throws Exception;

  AsyncRequest addEntry(com.raritan.idl.event.DataPushService.EntrySettings entrySettings, AsyncRpcResponse<AddEntryResult> rsp);

  AsyncRequest addEntry(com.raritan.idl.event.DataPushService.EntrySettings entrySettings, AsyncRpcResponse<AddEntryResult> rsp, RpcCtrl rpcCtrl);


  public class ModifyEntryResult {
    public int _ret_;
  }

  ModifyEntryResult modifyEntry(int entryId, com.raritan.idl.event.DataPushService.EntrySettings entrySettings) throws Exception;

  AsyncRequest modifyEntry(int entryId, com.raritan.idl.event.DataPushService.EntrySettings entrySettings, AsyncRpcResponse<ModifyEntryResult> rsp);

  AsyncRequest modifyEntry(int entryId, com.raritan.idl.event.DataPushService.EntrySettings entrySettings, AsyncRpcResponse<ModifyEntryResult> rsp, RpcCtrl rpcCtrl);


  public class DeleteEntryResult {
    public int _ret_;
  }

  DeleteEntryResult deleteEntry(int entryId) throws Exception;

  AsyncRequest deleteEntry(int entryId, AsyncRpcResponse<DeleteEntryResult> rsp);

  AsyncRequest deleteEntry(int entryId, AsyncRpcResponse<DeleteEntryResult> rsp, RpcCtrl rpcCtrl);


  public class GetEntryResult {
    public int _ret_;
    public com.raritan.idl.event.DataPushService.EntrySettings entrySettings;
  }

  GetEntryResult getEntry(int entryId) throws Exception;

  AsyncRequest getEntry(int entryId, AsyncRpcResponse<GetEntryResult> rsp);

  AsyncRequest getEntry(int entryId, AsyncRpcResponse<GetEntryResult> rsp, RpcCtrl rpcCtrl);


  public class ListEntriesResult {
    public java.util.Map<Integer, com.raritan.idl.event.DataPushService.EntrySettings> _ret_;
  }

  ListEntriesResult listEntries() throws Exception;

  AsyncRequest listEntries(AsyncRpcResponse<ListEntriesResult> rsp);

  AsyncRequest listEntries(AsyncRpcResponse<ListEntriesResult> rsp, RpcCtrl rpcCtrl);


  public class PushDataResult {
    public int _ret_;
  }

  PushDataResult pushData(int entryId) throws Exception;

  AsyncRequest pushData(int entryId, AsyncRpcResponse<PushDataResult> rsp);

  AsyncRequest pushData(int entryId, AsyncRpcResponse<PushDataResult> rsp, RpcCtrl rpcCtrl);

}
