// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2025 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from DateTime.idl.

package com.raritan.idl.datetime;

import com.raritan.idl.*;
import com.raritan.util.AsyncRequest;

public interface DateTime {
  static public final TypeInfo typeInfo = new TypeInfo("datetime.DateTime:1.0.0", null);

  static public class ZoneInfo implements Cloneable {
    public int id = 0;
    public String name = new String();
    public boolean hasDSTInfo = false;

    public Object clone() {
      ZoneInfo copy = new ZoneInfo();

      copy.id = this.id;
      copy.name = this.name;
      copy.hasDSTInfo = this.hasDSTInfo;

      return copy;
    }

  }

  static public class ZoneCfg implements Cloneable {
    public int id = 0;
    public String name = new String();
    public boolean enableAutoDST = false;

    public Object clone() {
      ZoneCfg copy = new ZoneCfg();

      copy.id = this.id;
      copy.name = this.name;
      copy.enableAutoDST = this.enableAutoDST;

      return copy;
    }

  }

  public enum Protocol {
    STATIC,
    NTP;
  }

  static public class NtpCfg implements Cloneable {
    public boolean forceStatic = false;
    public String server1 = new String();
    public String server2 = new String();

    public Object clone() {
      NtpCfg copy = new NtpCfg();

      copy.forceStatic = this.forceStatic;
      copy.server1 = this.server1;
      copy.server2 = this.server2;

      return copy;
    }

  }

  static public class Cfg implements Cloneable {
    public com.raritan.idl.datetime.DateTime.ZoneCfg zoneCfg = new com.raritan.idl.datetime.DateTime.ZoneCfg();
    public com.raritan.idl.datetime.DateTime.Protocol protocol = com.raritan.idl.datetime.DateTime.Protocol.values()[0];
    public java.util.Date deviceTime = new java.util.Date();
    public com.raritan.idl.datetime.DateTime.NtpCfg ntpCfg = new com.raritan.idl.datetime.DateTime.NtpCfg();

    public Object clone() {
      Cfg copy = new Cfg();

      Object zoneCfgCopy = this.zoneCfg.clone();
      copy.zoneCfg = (com.raritan.idl.datetime.DateTime.ZoneCfg) zoneCfgCopy;
      copy.protocol = this.protocol;
      copy.deviceTime = this.deviceTime;
      Object ntpCfgCopy = this.ntpCfg.clone();
      copy.ntpCfg = (com.raritan.idl.datetime.DateTime.NtpCfg) ntpCfgCopy;

      return copy;
    }

  }

  public class GetZoneInfosResult {
    public java.util.List<com.raritan.idl.datetime.DateTime.ZoneInfo> zoneInfos;
  }

  GetZoneInfosResult getZoneInfos(boolean useOlson) throws Exception;

  AsyncRequest getZoneInfos(boolean useOlson, AsyncRpcResponse<GetZoneInfosResult> rsp);

  AsyncRequest getZoneInfos(boolean useOlson, AsyncRpcResponse<GetZoneInfosResult> rsp, RpcCtrl rpcCtrl);


  public class TestNtpResult {
    public boolean _ret_;
  }

  TestNtpResult testNtp(com.raritan.idl.datetime.DateTime.NtpCfg ntpCfg) throws Exception;

  AsyncRequest testNtp(com.raritan.idl.datetime.DateTime.NtpCfg ntpCfg, AsyncRpcResponse<TestNtpResult> rsp);

  AsyncRequest testNtp(com.raritan.idl.datetime.DateTime.NtpCfg ntpCfg, AsyncRpcResponse<TestNtpResult> rsp, RpcCtrl rpcCtrl);


  public class GetCfgResult {
    public com.raritan.idl.datetime.DateTime.Cfg cfg;
  }

  GetCfgResult getCfg() throws Exception;

  AsyncRequest getCfg(AsyncRpcResponse<GetCfgResult> rsp);

  AsyncRequest getCfg(AsyncRpcResponse<GetCfgResult> rsp, RpcCtrl rpcCtrl);


  public class SetCfgResult {
    public int _ret_;
  }

  SetCfgResult setCfg(com.raritan.idl.datetime.DateTime.Cfg cfg) throws Exception;

  AsyncRequest setCfg(com.raritan.idl.datetime.DateTime.Cfg cfg, AsyncRpcResponse<SetCfgResult> rsp);

  AsyncRequest setCfg(com.raritan.idl.datetime.DateTime.Cfg cfg, AsyncRpcResponse<SetCfgResult> rsp, RpcCtrl rpcCtrl);


  public class GetTimeResult {
    public com.raritan.idl.datetime.DateTime.ZoneInfo zone;
    public boolean dstEnabled;
    public int utcOffset;
    public java.util.Date currentTime;
  }

  GetTimeResult getTime(boolean useOlson) throws Exception;

  AsyncRequest getTime(boolean useOlson, AsyncRpcResponse<GetTimeResult> rsp);

  AsyncRequest getTime(boolean useOlson, AsyncRpcResponse<GetTimeResult> rsp, RpcCtrl rpcCtrl);

}
