// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2025 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from CascadeManager.idl.

package com.raritan.idl.cascading;

import com.raritan.idl.*;
import com.raritan.util.AsyncRequest;

public interface CascadeManager_2_0_1 {
  static public final TypeInfo typeInfo = new TypeInfo("cascading.CascadeManager:2.0.1", null);

  public static final int NO_ERROR = 0;

  public static final int ERR_INVALID_PARAM = 1;

  public static final int ERR_UNSUPPORTED_ON_PRIMARY_UNIT = 2;

  public static final int ERR_UNSUPPORTED_ON_LINK_UNIT = 3;

  public static final int ERR_LINK_ID_IN_USE = 4;

  public static final int ERR_HOST_IN_USE = 5;

  public static final int ERR_LINK_UNIT_UNREACHABLE = 6;

  public static final int ERR_LINK_UNIT_ACCESS_DENIED = 7;

  public static final int ERR_LINK_UNIT_REFUSED = 8;

  public static final int ERR_UNIT_BUSY = 9;

  public static final int ERR_NOT_SUPPORTED = 10;

  public static final int ERR_PASSWORD_CHANGE_REQUIRED = 11;

  public static final int ERR_PASSWORD_POLICY = 12;

  public static final int ERR_LINK_UNIT_COMM_FAILED = 13;

  public static final int ERR_LINK_UNIT_NOT_SUPPORTED = 14;

  public static final int ERR_FIRMWARE_VERSION_MISMATCH = 15;

  static public class PrimaryUnitSettings implements Cloneable {
    public String caCertChain = new String();
    public boolean allowOffTimeRangeCerts = false;

    public Object clone() {
      PrimaryUnitSettings copy = new PrimaryUnitSettings();

      copy.caCertChain = this.caCertChain;
      copy.allowOffTimeRangeCerts = this.allowOffTimeRangeCerts;

      return copy;
    }

  }

  public enum Role {
    STANDALONE,
    PRIMARY_UNIT,
    LINK_UNIT;
  }

  public enum LinkUnitType {
    NETWORK,
    SECURE_SERIAL;
  }

  public enum LinkUnitStatus {
    UNKNOWN,
    OK,
    UNREACHABLE,
    ACCESS_DENIED,
    FIRMWARE_UPDATE,
    FIRMWARE_MISMATCH,
    PENDING;
  }

  static public class LinkUnit implements Cloneable {
    public com.raritan.idl.cascading.CascadeManager_2_0_1.LinkUnitType type = com.raritan.idl.cascading.CascadeManager_2_0_1.LinkUnitType.values()[0];
    public String host = new String();
    public com.raritan.idl.cascading.CascadeManager_2_0_1.LinkUnitStatus status = com.raritan.idl.cascading.CascadeManager_2_0_1.LinkUnitStatus.values()[0];
    public String fwVersion = new String();

    public Object clone() {
      LinkUnit copy = new LinkUnit();

      copy.type = this.type;
      copy.host = this.host;
      copy.status = this.status;
      copy.fwVersion = this.fwVersion;

      return copy;
    }

  }

  static public class Status implements Cloneable {
    public com.raritan.idl.cascading.CascadeManager_2_0_1.Role role = com.raritan.idl.cascading.CascadeManager_2_0_1.Role.values()[0];
    public String primaryUnit = new String();
    public java.util.Map<Integer, com.raritan.idl.cascading.CascadeManager_2_0_1.LinkUnit> linkUnits = new java.util.HashMap<>();

    public Object clone() {
      Status copy = new Status();

      copy.role = this.role;
      copy.primaryUnit = this.primaryUnit;
      copy.linkUnits = new java.util.HashMap<Integer, com.raritan.idl.cascading.CascadeManager_2_0_1.LinkUnit>(this.linkUnits);

      return copy;
    }

  }

  static public class LinkPortStatus implements Cloneable {
    public boolean isSupported = false;
    public boolean isLinkDetected = false;
    public boolean isLinkingConfirmationNeeded = false;

    public Object clone() {
      LinkPortStatus copy = new LinkPortStatus();

      copy.isSupported = this.isSupported;
      copy.isLinkDetected = this.isLinkDetected;
      copy.isLinkingConfirmationNeeded = this.isLinkingConfirmationNeeded;

      return copy;
    }

  }

  public class RoleChangedEvent extends com.raritan.idl.idl.Event {

    static public final TypeInfo typeInfo = new TypeInfo("cascading.CascadeManager_2_0_1.RoleChangedEvent:1.0.0", com.raritan.idl.idl.Event.typeInfo);

    @Override
    protected TypeInfo getClassTypeInfo() {
      return typeInfo;
    }

    public com.raritan.idl.cascading.CascadeManager_2_0_1.Role oldRole = com.raritan.idl.cascading.CascadeManager_2_0_1.Role.values()[0];
    public com.raritan.idl.cascading.CascadeManager_2_0_1.Role newRole = com.raritan.idl.cascading.CascadeManager_2_0_1.Role.values()[0];
    public String primaryUnit = new String();
  }

  public class LinkUnitAddedEvent extends com.raritan.idl.event.UserEvent {

    static public final TypeInfo typeInfo = new TypeInfo("cascading.CascadeManager_2_0_1.LinkUnitAddedEvent:1.0.0", com.raritan.idl.event.UserEvent.typeInfo);

    @Override
    protected TypeInfo getClassTypeInfo() {
      return typeInfo;
    }

    public int linkId = 0;
    public com.raritan.idl.cascading.CascadeManager_2_0_1.LinkUnitType type = com.raritan.idl.cascading.CascadeManager_2_0_1.LinkUnitType.values()[0];
    public String host = new String();
  }

  public class LinkUnitReleasedEvent extends com.raritan.idl.event.UserEvent {

    static public final TypeInfo typeInfo = new TypeInfo("cascading.CascadeManager_2_0_1.LinkUnitReleasedEvent:1.0.0", com.raritan.idl.event.UserEvent.typeInfo);

    @Override
    protected TypeInfo getClassTypeInfo() {
      return typeInfo;
    }

    public int linkId = 0;
    public com.raritan.idl.cascading.CascadeManager_2_0_1.LinkUnitType type = com.raritan.idl.cascading.CascadeManager_2_0_1.LinkUnitType.values()[0];
    public String host = new String();
  }

  public class LinkUnitStatusChangedEvent extends com.raritan.idl.idl.Event {

    static public final TypeInfo typeInfo = new TypeInfo("cascading.CascadeManager_2_0_1.LinkUnitStatusChangedEvent:1.0.0", com.raritan.idl.idl.Event.typeInfo);

    @Override
    protected TypeInfo getClassTypeInfo() {
      return typeInfo;
    }

    public int linkId = 0;
    public com.raritan.idl.cascading.CascadeManager_2_0_1.LinkUnitType type = com.raritan.idl.cascading.CascadeManager_2_0_1.LinkUnitType.values()[0];
    public String host = new String();
    public com.raritan.idl.cascading.CascadeManager_2_0_1.LinkUnitStatus oldStatus = com.raritan.idl.cascading.CascadeManager_2_0_1.LinkUnitStatus.values()[0];
    public com.raritan.idl.cascading.CascadeManager_2_0_1.LinkUnitStatus newStatus = com.raritan.idl.cascading.CascadeManager_2_0_1.LinkUnitStatus.values()[0];
  }

  public class LinkPortStatusChangedEvent extends com.raritan.idl.idl.Event {

    static public final TypeInfo typeInfo = new TypeInfo("cascading.CascadeManager_2_0_1.LinkPortStatusChangedEvent:1.0.0", com.raritan.idl.idl.Event.typeInfo);

    @Override
    protected TypeInfo getClassTypeInfo() {
      return typeInfo;
    }

    public com.raritan.idl.cascading.CascadeManager_2_0_1.LinkPortStatus oldStatus = new com.raritan.idl.cascading.CascadeManager_2_0_1.LinkPortStatus();
    public com.raritan.idl.cascading.CascadeManager_2_0_1.LinkPortStatus newStatus = new com.raritan.idl.cascading.CascadeManager_2_0_1.LinkPortStatus();
  }

  public class GetPrimaryUnitSettingsResult {
    public com.raritan.idl.cascading.CascadeManager_2_0_1.PrimaryUnitSettings _ret_;
  }

  GetPrimaryUnitSettingsResult getPrimaryUnitSettings() throws Exception;

  AsyncRequest getPrimaryUnitSettings(AsyncRpcResponse<GetPrimaryUnitSettingsResult> rsp);

  AsyncRequest getPrimaryUnitSettings(AsyncRpcResponse<GetPrimaryUnitSettingsResult> rsp, RpcCtrl rpcCtrl);


  public class SetPrimaryUnitSettingsResult {
    public int _ret_;
  }

  SetPrimaryUnitSettingsResult setPrimaryUnitSettings(com.raritan.idl.cascading.CascadeManager_2_0_1.PrimaryUnitSettings primaryUnitSettings) throws Exception;

  AsyncRequest setPrimaryUnitSettings(com.raritan.idl.cascading.CascadeManager_2_0_1.PrimaryUnitSettings primaryUnitSettings, AsyncRpcResponse<SetPrimaryUnitSettingsResult> rsp);

  AsyncRequest setPrimaryUnitSettings(com.raritan.idl.cascading.CascadeManager_2_0_1.PrimaryUnitSettings primaryUnitSettings, AsyncRpcResponse<SetPrimaryUnitSettingsResult> rsp, RpcCtrl rpcCtrl);


  public class GetStatusResult {
    public com.raritan.idl.cascading.CascadeManager_2_0_1.Status _ret_;
  }

  GetStatusResult getStatus() throws Exception;

  AsyncRequest getStatus(AsyncRpcResponse<GetStatusResult> rsp);

  AsyncRequest getStatus(AsyncRpcResponse<GetStatusResult> rsp, RpcCtrl rpcCtrl);


  public class GetLinkPortStatusResult {
    public com.raritan.idl.cascading.CascadeManager_2_0_1.LinkPortStatus _ret_;
  }

  GetLinkPortStatusResult getLinkPortStatus() throws Exception;

  AsyncRequest getLinkPortStatus(AsyncRpcResponse<GetLinkPortStatusResult> rsp);

  AsyncRequest getLinkPortStatus(AsyncRpcResponse<GetLinkPortStatusResult> rsp, RpcCtrl rpcCtrl);


  public class AddLinkUnitResult {
    public int _ret_;
  }

  AddLinkUnitResult addLinkUnit(int linkId, String host, String login, String password, String newPassword) throws Exception;

  AsyncRequest addLinkUnit(int linkId, String host, String login, String password, String newPassword, AsyncRpcResponse<AddLinkUnitResult> rsp);

  AsyncRequest addLinkUnit(int linkId, String host, String login, String password, String newPassword, AsyncRpcResponse<AddLinkUnitResult> rsp, RpcCtrl rpcCtrl);


  public class ReleaseLinkUnitResult {
    public int _ret_;
  }

  ReleaseLinkUnitResult releaseLinkUnit(int linkId) throws Exception;

  AsyncRequest releaseLinkUnit(int linkId, AsyncRpcResponse<ReleaseLinkUnitResult> rsp);

  AsyncRequest releaseLinkUnit(int linkId, AsyncRpcResponse<ReleaseLinkUnitResult> rsp, RpcCtrl rpcCtrl);


  public class RequestLinkResult {
    public int _ret_;
  }

  RequestLinkResult requestLink(String token) throws Exception;

  AsyncRequest requestLink(String token, AsyncRpcResponse<RequestLinkResult> rsp);

  AsyncRequest requestLink(String token, AsyncRpcResponse<RequestLinkResult> rsp, RpcCtrl rpcCtrl);

  Void finalizeLink(String token) throws Exception;

  AsyncRequest finalizeLink(String token, AsyncRpcResponse<Void> rsp);

  AsyncRequest finalizeLink(String token, AsyncRpcResponse<Void> rsp, RpcCtrl rpcCtrl);

  Void unlink() throws Exception;

  AsyncRequest unlink(AsyncRpcResponse<Void> rsp);

  AsyncRequest unlink(AsyncRpcResponse<Void> rsp, RpcCtrl rpcCtrl);


  public class GetSupportedRolesResult {
    public java.util.List<com.raritan.idl.cascading.CascadeManager_2_0_1.Role> _ret_;
  }

  GetSupportedRolesResult getSupportedRoles() throws Exception;

  AsyncRequest getSupportedRoles(AsyncRpcResponse<GetSupportedRolesResult> rsp);

  AsyncRequest getSupportedRoles(AsyncRpcResponse<GetSupportedRolesResult> rsp, RpcCtrl rpcCtrl);


  public class GetSupportedLinkUnitTypesResult {
    public java.util.List<com.raritan.idl.cascading.CascadeManager_2_0_1.LinkUnitType> _ret_;
  }

  GetSupportedLinkUnitTypesResult getSupportedLinkUnitTypes() throws Exception;

  AsyncRequest getSupportedLinkUnitTypes(AsyncRpcResponse<GetSupportedLinkUnitTypesResult> rsp);

  AsyncRequest getSupportedLinkUnitTypes(AsyncRpcResponse<GetSupportedLinkUnitTypesResult> rsp, RpcCtrl rpcCtrl);


  public class AddCascadeLinkUnitResult {
    public int _ret_;
  }

  AddCascadeLinkUnitResult addCascadeLinkUnit(int linkId, int nodeIndex, String login, String password, boolean positionDependent) throws Exception;

  AsyncRequest addCascadeLinkUnit(int linkId, int nodeIndex, String login, String password, boolean positionDependent, AsyncRpcResponse<AddCascadeLinkUnitResult> rsp);

  AsyncRequest addCascadeLinkUnit(int linkId, int nodeIndex, String login, String password, boolean positionDependent, AsyncRpcResponse<AddCascadeLinkUnitResult> rsp, RpcCtrl rpcCtrl);


  public class AddLinkPortLinkUnitResult {
    public int _ret_;
  }

  AddLinkPortLinkUnitResult addLinkPortLinkUnit() throws Exception;

  AsyncRequest addLinkPortLinkUnit(AsyncRpcResponse<AddLinkPortLinkUnitResult> rsp);

  AsyncRequest addLinkPortLinkUnit(AsyncRpcResponse<AddLinkPortLinkUnitResult> rsp, RpcCtrl rpcCtrl);


  public class AddSecureSerialLinkUnitResult {
    public int _ret_;
  }

  AddSecureSerialLinkUnitResult addSecureSerialLinkUnit(int linkId, String installKey) throws Exception;

  AsyncRequest addSecureSerialLinkUnit(int linkId, String installKey, AsyncRpcResponse<AddSecureSerialLinkUnitResult> rsp);

  AsyncRequest addSecureSerialLinkUnit(int linkId, String installKey, AsyncRpcResponse<AddSecureSerialLinkUnitResult> rsp, RpcCtrl rpcCtrl);

}
