// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2025 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from CascadeManager.idl.

package com.raritan.idl.cascading;

import com.raritan.idl.*;
import com.raritan.util.AsyncRequest;

public interface CascadeManager {
  static public final TypeInfo typeInfo = new TypeInfo("cascading.CascadeManager:1.0.0", null);

  public static final int NO_ERROR = 0;

  public static final int ERR_INVALID_PARAM = 1;

  public static final int ERR_UNSUPPORTED_ON_MASTER = 2;

  public static final int ERR_UNSUPPORTED_ON_LINK_UNIT = 3;

  public static final int ERR_LINK_ID_IN_USE = 4;

  public static final int ERR_HOST_IN_USE = 5;

  public static final int ERR_LINK_UNIT_UNREACHABLE = 6;

  public static final int ERR_LINK_UNIT_ACCESS_DENIED = 7;

  public static final int ERR_LINK_UNIT_REFUSED = 8;

  public static final int ERR_UNIT_BUSY = 9;

  public static final int ERR_NOT_SUPPORTED = 10;

  public static final int ERR_PASSWORD_CHANGE_REQUIRED = 11;

  public static final int ERR_PASSWORD_POLICY = 12;

  public enum Role {
    STANDALONE,
    MASTER,
    LINK_UNIT;
  }

  public enum LinkUnitStatus {
    UNKNOWN,
    OK,
    UNREACHABLE,
    ACCESS_DENIED,
    FIRMWARE_UPDATE;
  }

  static public class LinkUnit implements Cloneable {
    public String host = new String();
    public com.raritan.idl.cascading.CascadeManager.LinkUnitStatus status = com.raritan.idl.cascading.CascadeManager.LinkUnitStatus.values()[0];

    public Object clone() {
      LinkUnit copy = new LinkUnit();

      copy.host = this.host;
      copy.status = this.status;

      return copy;
    }

  }

  static public class Status implements Cloneable {
    public com.raritan.idl.cascading.CascadeManager.Role role = com.raritan.idl.cascading.CascadeManager.Role.values()[0];
    public String master = new String();
    public java.util.Map<Integer, com.raritan.idl.cascading.CascadeManager.LinkUnit> linkUnits = new java.util.HashMap<>();

    public Object clone() {
      Status copy = new Status();

      copy.role = this.role;
      copy.master = this.master;
      copy.linkUnits = new java.util.HashMap<Integer, com.raritan.idl.cascading.CascadeManager.LinkUnit>(this.linkUnits);

      return copy;
    }

  }

  public class RoleChangedEvent extends com.raritan.idl.idl.Event {

    static public final TypeInfo typeInfo = new TypeInfo("cascading.CascadeManager.RoleChangedEvent:1.0.0", com.raritan.idl.idl.Event.typeInfo);

    @Override
    protected TypeInfo getClassTypeInfo() {
      return typeInfo;
    }

    public com.raritan.idl.cascading.CascadeManager.Role oldRole = com.raritan.idl.cascading.CascadeManager.Role.values()[0];
    public com.raritan.idl.cascading.CascadeManager.Role newRole = com.raritan.idl.cascading.CascadeManager.Role.values()[0];
    public String master = new String();
  }

  public class LinkUnitAddedEvent extends com.raritan.idl.event.UserEvent {

    static public final TypeInfo typeInfo = new TypeInfo("cascading.CascadeManager.LinkUnitAddedEvent:1.0.0", com.raritan.idl.event.UserEvent.typeInfo);

    @Override
    protected TypeInfo getClassTypeInfo() {
      return typeInfo;
    }

    public int linkId = 0;
    public String host = new String();
  }

  public class LinkUnitReleasedEvent extends com.raritan.idl.event.UserEvent {

    static public final TypeInfo typeInfo = new TypeInfo("cascading.CascadeManager.LinkUnitReleasedEvent:1.0.0", com.raritan.idl.event.UserEvent.typeInfo);

    @Override
    protected TypeInfo getClassTypeInfo() {
      return typeInfo;
    }

    public int linkId = 0;
    public String host = new String();
  }

  public class LinkUnitStatusChangedEvent extends com.raritan.idl.idl.Event {

    static public final TypeInfo typeInfo = new TypeInfo("cascading.CascadeManager.LinkUnitStatusChangedEvent:1.0.0", com.raritan.idl.idl.Event.typeInfo);

    @Override
    protected TypeInfo getClassTypeInfo() {
      return typeInfo;
    }

    public int linkId = 0;
    public String host = new String();
    public com.raritan.idl.cascading.CascadeManager.LinkUnitStatus oldStatus = com.raritan.idl.cascading.CascadeManager.LinkUnitStatus.values()[0];
    public com.raritan.idl.cascading.CascadeManager.LinkUnitStatus newStatus = com.raritan.idl.cascading.CascadeManager.LinkUnitStatus.values()[0];
  }

  public class GetStatusResult {
    public com.raritan.idl.cascading.CascadeManager.Status _ret_;
  }

  GetStatusResult getStatus() throws Exception;

  AsyncRequest getStatus(AsyncRpcResponse<GetStatusResult> rsp);

  AsyncRequest getStatus(AsyncRpcResponse<GetStatusResult> rsp, RpcCtrl rpcCtrl);


  public class AddLinkUnitResult {
    public int _ret_;
  }

  AddLinkUnitResult addLinkUnit(int linkId, String host, String login, String password, String newPassword) throws Exception;

  AsyncRequest addLinkUnit(int linkId, String host, String login, String password, String newPassword, AsyncRpcResponse<AddLinkUnitResult> rsp);

  AsyncRequest addLinkUnit(int linkId, String host, String login, String password, String newPassword, AsyncRpcResponse<AddLinkUnitResult> rsp, RpcCtrl rpcCtrl);


  public class ReleaseLinkUnitResult {
    public int _ret_;
  }

  ReleaseLinkUnitResult releaseLinkUnit(int linkId) throws Exception;

  AsyncRequest releaseLinkUnit(int linkId, AsyncRpcResponse<ReleaseLinkUnitResult> rsp);

  AsyncRequest releaseLinkUnit(int linkId, AsyncRpcResponse<ReleaseLinkUnitResult> rsp, RpcCtrl rpcCtrl);


  public class RequestLinkResult {
    public int _ret_;
  }

  RequestLinkResult requestLink(String token) throws Exception;

  AsyncRequest requestLink(String token, AsyncRpcResponse<RequestLinkResult> rsp);

  AsyncRequest requestLink(String token, AsyncRpcResponse<RequestLinkResult> rsp, RpcCtrl rpcCtrl);

  Void finalizeLink(String token) throws Exception;

  AsyncRequest finalizeLink(String token, AsyncRpcResponse<Void> rsp);

  AsyncRequest finalizeLink(String token, AsyncRpcResponse<Void> rsp, RpcCtrl rpcCtrl);

  Void unlink() throws Exception;

  AsyncRequest unlink(AsyncRpcResponse<Void> rsp);

  AsyncRequest unlink(AsyncRpcResponse<Void> rsp, RpcCtrl rpcCtrl);

}
