// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2025 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from RadiusManager.idl.

package com.raritan.idl.auth;

import com.raritan.idl.*;
import com.raritan.util.AsyncRequest;

public interface RadiusManager_3_0_1 {
  static public final TypeInfo typeInfo = new TypeInfo("auth.RadiusManager:3.0.1", null);

  public enum AuthType {
    PAP,
    CHAP,
    MSCHAPv2;
  }

  static public class ServerSettings implements Cloneable {
    public String id = new String();
    public String server = new String();
    public String sharedSecret = new String();
    public int udpAuthPort = 0;
    public int udpAccountPort = 0;
    public int timeout = 0;
    public int retries = 0;
    public com.raritan.idl.auth.RadiusManager_3_0_1.AuthType authType = com.raritan.idl.auth.RadiusManager_3_0_1.AuthType.values()[0];
    public boolean disableAccounting = false;

    public Object clone() {
      ServerSettings copy = new ServerSettings();

      copy.id = this.id;
      copy.server = this.server;
      copy.sharedSecret = this.sharedSecret;
      copy.udpAuthPort = this.udpAuthPort;
      copy.udpAccountPort = this.udpAccountPort;
      copy.timeout = this.timeout;
      copy.retries = this.retries;
      copy.authType = this.authType;
      copy.disableAccounting = this.disableAccounting;

      return copy;
    }

  }

  public static final int ERR_INVALID_CFG = 1;

  public static final int ERR_SERVER_UNSPECIFIED = 2;

  public static final int ERR_INVALID_SHARED_SECRET = 3;

  public static final int ERR_SERVER_UNREACHABLE = 4;

  public static final int ERR_AUTHENTICATION_FAILED = 5;

  public static final int ERR_NO_ROLES = 6;

  public static final int ERR_NO_KNOWN_ROLES = 7;

  public class GetRadiusServersResult {
    public java.util.List<com.raritan.idl.auth.RadiusManager_3_0_1.ServerSettings> _ret_;
  }

  GetRadiusServersResult getRadiusServers() throws Exception;

  AsyncRequest getRadiusServers(AsyncRpcResponse<GetRadiusServersResult> rsp);

  AsyncRequest getRadiusServers(AsyncRpcResponse<GetRadiusServersResult> rsp, RpcCtrl rpcCtrl);


  public class SetRadiusServersResult {
    public int _ret_;
  }

  SetRadiusServersResult setRadiusServers(java.util.List<com.raritan.idl.auth.RadiusManager_3_0_1.ServerSettings> serverList) throws Exception;

  AsyncRequest setRadiusServers(java.util.List<com.raritan.idl.auth.RadiusManager_3_0_1.ServerSettings> serverList, AsyncRpcResponse<SetRadiusServersResult> rsp);

  AsyncRequest setRadiusServers(java.util.List<com.raritan.idl.auth.RadiusManager_3_0_1.ServerSettings> serverList, AsyncRpcResponse<SetRadiusServersResult> rsp, RpcCtrl rpcCtrl);


  public class TestRadiusServerResult {
    public int _ret_;
  }

  TestRadiusServerResult testRadiusServer(String username, String password, com.raritan.idl.auth.RadiusManager_3_0_1.ServerSettings settings) throws Exception;

  AsyncRequest testRadiusServer(String username, String password, com.raritan.idl.auth.RadiusManager_3_0_1.ServerSettings settings, AsyncRpcResponse<TestRadiusServerResult> rsp);

  AsyncRequest testRadiusServer(String username, String password, com.raritan.idl.auth.RadiusManager_3_0_1.ServerSettings settings, AsyncRpcResponse<TestRadiusServerResult> rsp, RpcCtrl rpcCtrl);

}
