// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2025 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from RoleManager.idl.

package com.raritan.json_rpc.usermgmt;

import org.json.*;

import com.raritan.idl.*;
import com.raritan.json_rpc.*;
import com.raritan.util.AsyncRequest;

public class RoleManager_Proxy extends ObjectProxy implements com.raritan.idl.usermgmt.RoleManager {

  public RoleManager_Proxy(Agent agent, String rid, TypeInfo typeInfo) {
    super(agent, rid, typeInfo);
  }

  public RoleManager_Proxy(Agent agent, String rid) {
    this(agent, rid, com.raritan.idl.usermgmt.RoleManager.typeInfo);
  }

  public static RoleManager_Proxy staticCast(ObjectProxy proxy) {
    return proxy == null ? null : new RoleManager_Proxy(proxy.getAgent(), proxy.getRid(), proxy.getStaticTypeInfo());
  }


  @Override
  public CreateRoleFullResult createRoleFull(final String name, final com.raritan.idl.usermgmt.Role.Info info) throws Exception {
    JSONObject params = new JSONObject();
    params.put("name", name);
    params.put("info", com.raritan.json_rpc.usermgmt.Role.Info_Codec.encode(info));
    final JSONObject result = rpcCall("createRoleFull", params);
    CreateRoleFullResult ret = new CreateRoleFullResult();
    ret._ret_ = result.getInt("_ret_");
    return ret;
  }

  @Override
  public AsyncRequest createRoleFull(final String name, final com.raritan.idl.usermgmt.Role.Info info, final AsyncRpcResponse<CreateRoleFullResult> rsp) {
    return createRoleFull(name, info, rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest createRoleFull(final String name, final com.raritan.idl.usermgmt.Role.Info info, final AsyncRpcResponse<CreateRoleFullResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = new JSONObject();
    try {
      params.put("name", name);
      params.put("info", com.raritan.json_rpc.usermgmt.Role.Info_Codec.encode(info));
    } catch (Exception e) {
      rsp.onFailure(e);
    }
    return rpcCall("createRoleFull", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          CreateRoleFullResult ret = new CreateRoleFullResult();
          ret._ret_ = result.getInt("_ret_");
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public DeleteRoleResult deleteRole(final String name) throws Exception {
    JSONObject params = new JSONObject();
    params.put("name", name);
    final JSONObject result = rpcCall("deleteRole", params);
    DeleteRoleResult ret = new DeleteRoleResult();
    ret._ret_ = result.getInt("_ret_");
    return ret;
  }

  @Override
  public AsyncRequest deleteRole(final String name, final AsyncRpcResponse<DeleteRoleResult> rsp) {
    return deleteRole(name, rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest deleteRole(final String name, final AsyncRpcResponse<DeleteRoleResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = new JSONObject();
    try {
      params.put("name", name);
    } catch (Exception e) {
      rsp.onFailure(e);
    }
    return rpcCall("deleteRole", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          DeleteRoleResult ret = new DeleteRoleResult();
          ret._ret_ = result.getInt("_ret_");
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public GetAllRoleNamesResult getAllRoleNames() throws Exception {
    JSONObject params = null;
    final JSONObject result = rpcCall("getAllRoleNames", params);
    GetAllRoleNamesResult ret = new GetAllRoleNamesResult();
    ret._ret_ = new java.util.ArrayList<String>() {
      private static final long serialVersionUID = 1L;
      {
        final JSONArray array0 = result.getJSONArray("_ret_");
        for (int i0 = 0; i0 < array0.length(); i0++) {
          final int i0_f = i0;
          this.add(array0.getString(i0_f));
        }
      }
    };
    return ret;
  }

  @Override
  public AsyncRequest getAllRoleNames(final AsyncRpcResponse<GetAllRoleNamesResult> rsp) {
    return getAllRoleNames(rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest getAllRoleNames(final AsyncRpcResponse<GetAllRoleNamesResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = null;
    return rpcCall("getAllRoleNames", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          GetAllRoleNamesResult ret = new GetAllRoleNamesResult();
          ret._ret_ = new java.util.ArrayList<String>() {
            private static final long serialVersionUID = 1L;
            {
              final JSONArray array0 = result.getJSONArray("_ret_");
              for (int i0 = 0; i0 < array0.length(); i0++) {
                final int i0_f = i0;
                this.add(array0.getString(i0_f));
              }
            }
          };
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public GetAllRolesResult getAllRoles() throws Exception {
    JSONObject params = null;
    final JSONObject result = rpcCall("getAllRoles", params);
    GetAllRolesResult ret = new GetAllRolesResult();
    ret._ret_ = new java.util.ArrayList<com.raritan.idl.usermgmt.RoleManager.RoleAccount>() {
      private static final long serialVersionUID = 1L;
      {
        final JSONArray array0 = result.getJSONArray("_ret_");
        for (int i0 = 0; i0 < array0.length(); i0++) {
          final int i0_f = i0;
          this.add(com.raritan.json_rpc.usermgmt.RoleManager.RoleAccount_Codec.decode(array0.getJSONObject(i0_f), agent));
        }
      }
    };
    return ret;
  }

  @Override
  public AsyncRequest getAllRoles(final AsyncRpcResponse<GetAllRolesResult> rsp) {
    return getAllRoles(rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest getAllRoles(final AsyncRpcResponse<GetAllRolesResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = null;
    return rpcCall("getAllRoles", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          GetAllRolesResult ret = new GetAllRolesResult();
          ret._ret_ = new java.util.ArrayList<com.raritan.idl.usermgmt.RoleManager.RoleAccount>() {
            private static final long serialVersionUID = 1L;
            {
              final JSONArray array0 = result.getJSONArray("_ret_");
              for (int i0 = 0; i0 < array0.length(); i0++) {
                final int i0_f = i0;
                this.add(com.raritan.json_rpc.usermgmt.RoleManager.RoleAccount_Codec.decode(array0.getJSONObject(i0_f), agent));
              }
            }
          };
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public GetAllPrivilegesResult getAllPrivileges() throws Exception {
    JSONObject params = null;
    final JSONObject result = rpcCall("getAllPrivileges", params);
    GetAllPrivilegesResult ret = new GetAllPrivilegesResult();
    ret._ret_ = new java.util.ArrayList<com.raritan.idl.usermgmt.RoleManager.PrivilegeDesc>() {
      private static final long serialVersionUID = 1L;
      {
        final JSONArray array0 = result.getJSONArray("_ret_");
        for (int i0 = 0; i0 < array0.length(); i0++) {
          final int i0_f = i0;
          this.add(com.raritan.json_rpc.usermgmt.RoleManager.PrivilegeDesc_Codec.decode(array0.getJSONObject(i0_f), agent));
        }
      }
    };
    return ret;
  }

  @Override
  public AsyncRequest getAllPrivileges(final AsyncRpcResponse<GetAllPrivilegesResult> rsp) {
    return getAllPrivileges(rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest getAllPrivileges(final AsyncRpcResponse<GetAllPrivilegesResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = null;
    return rpcCall("getAllPrivileges", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          GetAllPrivilegesResult ret = new GetAllPrivilegesResult();
          ret._ret_ = new java.util.ArrayList<com.raritan.idl.usermgmt.RoleManager.PrivilegeDesc>() {
            private static final long serialVersionUID = 1L;
            {
              final JSONArray array0 = result.getJSONArray("_ret_");
              for (int i0 = 0; i0 < array0.length(); i0++) {
                final int i0_f = i0;
                this.add(com.raritan.json_rpc.usermgmt.RoleManager.PrivilegeDesc_Codec.decode(array0.getJSONObject(i0_f), agent));
              }
            }
          };
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public GetInfoResult getInfo() throws Exception {
    JSONObject params = null;
    final JSONObject result = rpcCall("getInfo", params);
    GetInfoResult ret = new GetInfoResult();
    ret._ret_ = com.raritan.json_rpc.usermgmt.RoleManager.Info_Codec.decode(result.getJSONObject("_ret_"), agent);
    return ret;
  }

  @Override
  public AsyncRequest getInfo(final AsyncRpcResponse<GetInfoResult> rsp) {
    return getInfo(rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest getInfo(final AsyncRpcResponse<GetInfoResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = null;
    return rpcCall("getInfo", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          GetInfoResult ret = new GetInfoResult();
          ret._ret_ = com.raritan.json_rpc.usermgmt.RoleManager.Info_Codec.decode(result.getJSONObject("_ret_"), agent);
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }
}
