// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2025 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from Diagnostics.idl.

package com.raritan.json_rpc.net;

import org.json.*;

import com.raritan.idl.*;
import com.raritan.json_rpc.*;
import com.raritan.util.AsyncRequest;

public class Diagnostics_Proxy extends ObjectProxy implements com.raritan.idl.net.Diagnostics {

  public Diagnostics_Proxy(Agent agent, String rid, TypeInfo typeInfo) {
    super(agent, rid, typeInfo);
  }

  public Diagnostics_Proxy(Agent agent, String rid) {
    this(agent, rid, com.raritan.idl.net.Diagnostics.typeInfo);
  }

  public static Diagnostics_Proxy staticCast(ObjectProxy proxy) {
    return proxy == null ? null : new Diagnostics_Proxy(proxy.getAgent(), proxy.getRid(), proxy.getStaticTypeInfo());
  }


  @Override
  public PingResult ping(final String hostName, final int count) throws Exception {
    JSONObject params = new JSONObject();
    params.put("hostName", hostName);
    params.put("count", count);
    final JSONObject result = rpcCall("ping", params);
    PingResult ret = new PingResult();
    ret._ret_ = result.getInt("_ret_");
    ret.results = new java.util.ArrayList<String>() {
      private static final long serialVersionUID = 1L;
      {
        final JSONArray array0 = result.getJSONArray("results");
        for (int i0 = 0; i0 < array0.length(); i0++) {
          final int i0_f = i0;
          this.add(array0.getString(i0_f));
        }
      }
    };
    return ret;
  }

  @Override
  public AsyncRequest ping(final String hostName, final int count, final AsyncRpcResponse<PingResult> rsp) {
    return ping(hostName, count, rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest ping(final String hostName, final int count, final AsyncRpcResponse<PingResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = new JSONObject();
    try {
      params.put("hostName", hostName);
      params.put("count", count);
    } catch (Exception e) {
      rsp.onFailure(e);
    }
    return rpcCall("ping", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          PingResult ret = new PingResult();
          ret._ret_ = result.getInt("_ret_");
          ret.results = new java.util.ArrayList<String>() {
            private static final long serialVersionUID = 1L;
            {
              final JSONArray array0 = result.getJSONArray("results");
              for (int i0 = 0; i0 < array0.length(); i0++) {
                final int i0_f = i0;
                this.add(array0.getString(i0_f));
              }
            }
          };
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public TraceRouteResult traceRoute(final String hostName, final int timeout, final boolean useIcmp) throws Exception {
    JSONObject params = new JSONObject();
    params.put("hostName", hostName);
    params.put("timeout", timeout);
    params.put("useIcmp", useIcmp);
    final JSONObject result = rpcCall("traceRoute", params);
    TraceRouteResult ret = new TraceRouteResult();
    ret._ret_ = result.getInt("_ret_");
    ret.results = new java.util.ArrayList<String>() {
      private static final long serialVersionUID = 1L;
      {
        final JSONArray array0 = result.getJSONArray("results");
        for (int i0 = 0; i0 < array0.length(); i0++) {
          final int i0_f = i0;
          this.add(array0.getString(i0_f));
        }
      }
    };
    return ret;
  }

  @Override
  public AsyncRequest traceRoute(final String hostName, final int timeout, final boolean useIcmp, final AsyncRpcResponse<TraceRouteResult> rsp) {
    return traceRoute(hostName, timeout, useIcmp, rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest traceRoute(final String hostName, final int timeout, final boolean useIcmp, final AsyncRpcResponse<TraceRouteResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = new JSONObject();
    try {
      params.put("hostName", hostName);
      params.put("timeout", timeout);
      params.put("useIcmp", useIcmp);
    } catch (Exception e) {
      rsp.onFailure(e);
    }
    return rpcCall("traceRoute", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          TraceRouteResult ret = new TraceRouteResult();
          ret._ret_ = result.getInt("_ret_");
          ret.results = new java.util.ArrayList<String>() {
            private static final long serialVersionUID = 1L;
            {
              final JSONArray array0 = result.getJSONArray("results");
              for (int i0 = 0; i0 < array0.length(); i0++) {
                final int i0_f = i0;
                this.add(array0.getString(i0_f));
              }
            }
          };
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public ListTcpConnectionsResult listTcpConnections() throws Exception {
    JSONObject params = null;
    final JSONObject result = rpcCall("listTcpConnections", params);
    ListTcpConnectionsResult ret = new ListTcpConnectionsResult();
    ret._ret_ = result.getInt("_ret_");
    ret.results = new java.util.ArrayList<String>() {
      private static final long serialVersionUID = 1L;
      {
        final JSONArray array0 = result.getJSONArray("results");
        for (int i0 = 0; i0 < array0.length(); i0++) {
          final int i0_f = i0;
          this.add(array0.getString(i0_f));
        }
      }
    };
    return ret;
  }

  @Override
  public AsyncRequest listTcpConnections(final AsyncRpcResponse<ListTcpConnectionsResult> rsp) {
    return listTcpConnections(rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest listTcpConnections(final AsyncRpcResponse<ListTcpConnectionsResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = null;
    return rpcCall("listTcpConnections", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          ListTcpConnectionsResult ret = new ListTcpConnectionsResult();
          ret._ret_ = result.getInt("_ret_");
          ret.results = new java.util.ArrayList<String>() {
            private static final long serialVersionUID = 1L;
            {
              final JSONArray array0 = result.getJSONArray("results");
              for (int i0 = 0; i0 < array0.length(); i0++) {
                final int i0_f = i0;
                this.add(array0.getString(i0_f));
              }
            }
          };
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }
}
