// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2025 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from AlarmManager.idl.

package com.raritan.json_rpc.event;

import org.json.*;

import com.raritan.idl.*;
import com.raritan.json_rpc.*;
import com.raritan.util.AsyncRequest;

public class AlarmManager_Proxy extends ObjectProxy implements com.raritan.idl.event.AlarmManager {

  public AlarmManager_Proxy(Agent agent, String rid, TypeInfo typeInfo) {
    super(agent, rid, typeInfo);
  }

  public AlarmManager_Proxy(Agent agent, String rid) {
    this(agent, rid, com.raritan.idl.event.AlarmManager.typeInfo);
  }

  public static AlarmManager_Proxy staticCast(ObjectProxy proxy) {
    return proxy == null ? null : new AlarmManager_Proxy(proxy.getAgent(), proxy.getRid(), proxy.getStaticTypeInfo());
  }


  @Override
  public AcknowledgeAlarmResult acknowledgeAlarm(final String alarmId) throws Exception {
    JSONObject params = new JSONObject();
    params.put("alarmId", alarmId);
    final JSONObject result = rpcCall("acknowledgeAlarm", params);
    AcknowledgeAlarmResult ret = new AcknowledgeAlarmResult();
    ret._ret_ = result.getInt("_ret_");
    return ret;
  }

  @Override
  public AsyncRequest acknowledgeAlarm(final String alarmId, final AsyncRpcResponse<AcknowledgeAlarmResult> rsp) {
    return acknowledgeAlarm(alarmId, rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest acknowledgeAlarm(final String alarmId, final AsyncRpcResponse<AcknowledgeAlarmResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = new JSONObject();
    try {
      params.put("alarmId", alarmId);
    } catch (Exception e) {
      rsp.onFailure(e);
    }
    return rpcCall("acknowledgeAlarm", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          AcknowledgeAlarmResult ret = new AcknowledgeAlarmResult();
          ret._ret_ = result.getInt("_ret_");
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public ListAlarmsResult listAlarms() throws Exception {
    JSONObject params = null;
    final JSONObject result = rpcCall("listAlarms", params);
    ListAlarmsResult ret = new ListAlarmsResult();
    ret._ret_ = new java.util.ArrayList<com.raritan.idl.event.AlarmManager.Alarm>() {
      private static final long serialVersionUID = 1L;
      {
        final JSONArray array0 = result.getJSONArray("_ret_");
        for (int i0 = 0; i0 < array0.length(); i0++) {
          final int i0_f = i0;
          this.add(com.raritan.json_rpc.event.AlarmManager.Alarm_Codec.decode(array0.getJSONObject(i0_f), agent));
        }
      }
    };
    return ret;
  }

  @Override
  public AsyncRequest listAlarms(final AsyncRpcResponse<ListAlarmsResult> rsp) {
    return listAlarms(rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest listAlarms(final AsyncRpcResponse<ListAlarmsResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = null;
    return rpcCall("listAlarms", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          ListAlarmsResult ret = new ListAlarmsResult();
          ret._ret_ = new java.util.ArrayList<com.raritan.idl.event.AlarmManager.Alarm>() {
            private static final long serialVersionUID = 1L;
            {
              final JSONArray array0 = result.getJSONArray("_ret_");
              for (int i0 = 0; i0 < array0.length(); i0++) {
                final int i0_f = i0;
                this.add(com.raritan.json_rpc.event.AlarmManager.Alarm_Codec.decode(array0.getJSONObject(i0_f), agent));
              }
            }
          };
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }
}
