// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2025 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from AssetStrip.idl.

package com.raritan.json_rpc.assetmgrmodel;

import org.json.*;

import com.raritan.idl.*;
import com.raritan.json_rpc.*;
import com.raritan.util.AsyncRequest;

public class AssetStrip_Proxy extends ObjectProxy implements com.raritan.idl.assetmgrmodel.AssetStrip {

  public AssetStrip_Proxy(Agent agent, String rid, TypeInfo typeInfo) {
    super(agent, rid, typeInfo);
  }

  public AssetStrip_Proxy(Agent agent, String rid) {
    this(agent, rid, com.raritan.idl.assetmgrmodel.AssetStrip.typeInfo);
  }

  public static AssetStrip_Proxy staticCast(ObjectProxy proxy) {
    return proxy == null ? null : new AssetStrip_Proxy(proxy.getAgent(), proxy.getRid(), proxy.getStaticTypeInfo());
  }


  @Override
  public GetStateResult getState() throws Exception {
    JSONObject params = null;
    final JSONObject result = rpcCall("getState", params);
    GetStateResult ret = new GetStateResult();
    ret._ret_ = com.raritan.json_rpc.assetmgrmodel.AssetStrip.State_Codec.decode(result.getInt("_ret_"));
    return ret;
  }

  @Override
  public AsyncRequest getState(final AsyncRpcResponse<GetStateResult> rsp) {
    return getState(rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest getState(final AsyncRpcResponse<GetStateResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = null;
    return rpcCall("getState", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          GetStateResult ret = new GetStateResult();
          ret._ret_ = com.raritan.json_rpc.assetmgrmodel.AssetStrip.State_Codec.decode(result.getInt("_ret_"));
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public GetDeviceInfoResult getDeviceInfo() throws Exception {
    JSONObject params = null;
    final JSONObject result = rpcCall("getDeviceInfo", params);
    GetDeviceInfoResult ret = new GetDeviceInfoResult();
    ret._ret_ = result.getInt("_ret_");
    ret.info = com.raritan.json_rpc.assetmgrmodel.AssetStrip.DeviceInfo_Codec.decode(result.getJSONObject("info"), agent);
    return ret;
  }

  @Override
  public AsyncRequest getDeviceInfo(final AsyncRpcResponse<GetDeviceInfoResult> rsp) {
    return getDeviceInfo(rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest getDeviceInfo(final AsyncRpcResponse<GetDeviceInfoResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = null;
    return rpcCall("getDeviceInfo", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          GetDeviceInfoResult ret = new GetDeviceInfoResult();
          ret._ret_ = result.getInt("_ret_");
          ret.info = com.raritan.json_rpc.assetmgrmodel.AssetStrip.DeviceInfo_Codec.decode(result.getJSONObject("info"), agent);
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public GetStripSettingsResult getStripSettings() throws Exception {
    JSONObject params = null;
    final JSONObject result = rpcCall("getStripSettings", params);
    GetStripSettingsResult ret = new GetStripSettingsResult();
    ret._ret_ = com.raritan.json_rpc.assetmgrmodel.AssetStrip.StripSettings_Codec.decode(result.getJSONObject("_ret_"), agent);
    return ret;
  }

  @Override
  public AsyncRequest getStripSettings(final AsyncRpcResponse<GetStripSettingsResult> rsp) {
    return getStripSettings(rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest getStripSettings(final AsyncRpcResponse<GetStripSettingsResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = null;
    return rpcCall("getStripSettings", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          GetStripSettingsResult ret = new GetStripSettingsResult();
          ret._ret_ = com.raritan.json_rpc.assetmgrmodel.AssetStrip.StripSettings_Codec.decode(result.getJSONObject("_ret_"), agent);
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public SetStripSettingsResult setStripSettings(final com.raritan.idl.assetmgrmodel.AssetStrip.StripSettings settings) throws Exception {
    JSONObject params = new JSONObject();
    params.put("settings", com.raritan.json_rpc.assetmgrmodel.AssetStrip.StripSettings_Codec.encode(settings));
    final JSONObject result = rpcCall("setStripSettings", params);
    SetStripSettingsResult ret = new SetStripSettingsResult();
    ret._ret_ = result.getInt("_ret_");
    return ret;
  }

  @Override
  public AsyncRequest setStripSettings(final com.raritan.idl.assetmgrmodel.AssetStrip.StripSettings settings, final AsyncRpcResponse<SetStripSettingsResult> rsp) {
    return setStripSettings(settings, rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest setStripSettings(final com.raritan.idl.assetmgrmodel.AssetStrip.StripSettings settings, final AsyncRpcResponse<SetStripSettingsResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = new JSONObject();
    try {
      params.put("settings", com.raritan.json_rpc.assetmgrmodel.AssetStrip.StripSettings_Codec.encode(settings));
    } catch (Exception e) {
      rsp.onFailure(e);
    }
    return rpcCall("setStripSettings", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          SetStripSettingsResult ret = new SetStripSettingsResult();
          ret._ret_ = result.getInt("_ret_");
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public SetRackUnitSettingsResult setRackUnitSettings(final int channel, final com.raritan.idl.assetmgrmodel.AssetStrip.RackUnitSettings settings) throws Exception {
    JSONObject params = new JSONObject();
    params.put("channel", channel);
    params.put("settings", com.raritan.json_rpc.assetmgrmodel.AssetStrip.RackUnitSettings_Codec.encode(settings));
    final JSONObject result = rpcCall("setRackUnitSettings", params);
    SetRackUnitSettingsResult ret = new SetRackUnitSettingsResult();
    ret._ret_ = result.getInt("_ret_");
    return ret;
  }

  @Override
  public AsyncRequest setRackUnitSettings(final int channel, final com.raritan.idl.assetmgrmodel.AssetStrip.RackUnitSettings settings, final AsyncRpcResponse<SetRackUnitSettingsResult> rsp) {
    return setRackUnitSettings(channel, settings, rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest setRackUnitSettings(final int channel, final com.raritan.idl.assetmgrmodel.AssetStrip.RackUnitSettings settings, final AsyncRpcResponse<SetRackUnitSettingsResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = new JSONObject();
    try {
      params.put("channel", channel);
      params.put("settings", com.raritan.json_rpc.assetmgrmodel.AssetStrip.RackUnitSettings_Codec.encode(settings));
    } catch (Exception e) {
      rsp.onFailure(e);
    }
    return rpcCall("setRackUnitSettings", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          SetRackUnitSettingsResult ret = new SetRackUnitSettingsResult();
          ret._ret_ = result.getInt("_ret_");
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public SetMultipleRackUnitSettingsResult setMultipleRackUnitSettings(final java.util.List<Integer> channels, final java.util.List<com.raritan.idl.assetmgrmodel.AssetStrip.RackUnitSettings> settings) throws Exception {
    JSONObject params = new JSONObject();
    params.put("channels", new JSONArray() {{
      final java.util.List<Integer> array0 = channels;
      for (int i0 = 0; i0 < array0.size(); i0++) {
        final int i0_f = i0;
        this.put(array0.get(i0_f));
      }
    }});
    params.put("settings", new JSONArray() {{
      final java.util.List<com.raritan.idl.assetmgrmodel.AssetStrip.RackUnitSettings> array0 = settings;
      for (int i0 = 0; i0 < array0.size(); i0++) {
        final int i0_f = i0;
        this.put(com.raritan.json_rpc.assetmgrmodel.AssetStrip.RackUnitSettings_Codec.encode(array0.get(i0_f)));
      }
    }});
    final JSONObject result = rpcCall("setMultipleRackUnitSettings", params);
    SetMultipleRackUnitSettingsResult ret = new SetMultipleRackUnitSettingsResult();
    ret._ret_ = result.getInt("_ret_");
    return ret;
  }

  @Override
  public AsyncRequest setMultipleRackUnitSettings(final java.util.List<Integer> channels, final java.util.List<com.raritan.idl.assetmgrmodel.AssetStrip.RackUnitSettings> settings, final AsyncRpcResponse<SetMultipleRackUnitSettingsResult> rsp) {
    return setMultipleRackUnitSettings(channels, settings, rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest setMultipleRackUnitSettings(final java.util.List<Integer> channels, final java.util.List<com.raritan.idl.assetmgrmodel.AssetStrip.RackUnitSettings> settings, final AsyncRpcResponse<SetMultipleRackUnitSettingsResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = new JSONObject();
    try {
      params.put("channels", new JSONArray() {{
        final java.util.List<Integer> array0 = channels;
        for (int i0 = 0; i0 < array0.size(); i0++) {
          final int i0_f = i0;
          this.put(array0.get(i0_f));
        }
      }});
      params.put("settings", new JSONArray() {{
        final java.util.List<com.raritan.idl.assetmgrmodel.AssetStrip.RackUnitSettings> array0 = settings;
        for (int i0 = 0; i0 < array0.size(); i0++) {
          final int i0_f = i0;
          this.put(com.raritan.json_rpc.assetmgrmodel.AssetStrip.RackUnitSettings_Codec.encode(array0.get(i0_f)));
        }
      }});
    } catch (Exception e) {
      rsp.onFailure(e);
    }
    return rpcCall("setMultipleRackUnitSettings", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          SetMultipleRackUnitSettingsResult ret = new SetMultipleRackUnitSettingsResult();
          ret._ret_ = result.getInt("_ret_");
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public GetRackUnitInfoResult getRackUnitInfo(final int channel) throws Exception {
    JSONObject params = new JSONObject();
    params.put("channel", channel);
    final JSONObject result = rpcCall("getRackUnitInfo", params);
    GetRackUnitInfoResult ret = new GetRackUnitInfoResult();
    ret._ret_ = result.getInt("_ret_");
    ret.info = com.raritan.json_rpc.assetmgrmodel.AssetStrip.RackUnitInfo_Codec.decode(result.getJSONObject("info"), agent);
    return ret;
  }

  @Override
  public AsyncRequest getRackUnitInfo(final int channel, final AsyncRpcResponse<GetRackUnitInfoResult> rsp) {
    return getRackUnitInfo(channel, rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest getRackUnitInfo(final int channel, final AsyncRpcResponse<GetRackUnitInfoResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = new JSONObject();
    try {
      params.put("channel", channel);
    } catch (Exception e) {
      rsp.onFailure(e);
    }
    return rpcCall("getRackUnitInfo", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          GetRackUnitInfoResult ret = new GetRackUnitInfoResult();
          ret._ret_ = result.getInt("_ret_");
          ret.info = com.raritan.json_rpc.assetmgrmodel.AssetStrip.RackUnitInfo_Codec.decode(result.getJSONObject("info"), agent);
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public GetAllRackUnitInfosResult getAllRackUnitInfos() throws Exception {
    JSONObject params = null;
    final JSONObject result = rpcCall("getAllRackUnitInfos", params);
    GetAllRackUnitInfosResult ret = new GetAllRackUnitInfosResult();
    ret._ret_ = new java.util.ArrayList<com.raritan.idl.assetmgrmodel.AssetStrip.RackUnitInfo>() {
      private static final long serialVersionUID = 1L;
      {
        final JSONArray array0 = result.getJSONArray("_ret_");
        for (int i0 = 0; i0 < array0.length(); i0++) {
          final int i0_f = i0;
          this.add(com.raritan.json_rpc.assetmgrmodel.AssetStrip.RackUnitInfo_Codec.decode(array0.getJSONObject(i0_f), agent));
        }
      }
    };
    return ret;
  }

  @Override
  public AsyncRequest getAllRackUnitInfos(final AsyncRpcResponse<GetAllRackUnitInfosResult> rsp) {
    return getAllRackUnitInfos(rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest getAllRackUnitInfos(final AsyncRpcResponse<GetAllRackUnitInfosResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = null;
    return rpcCall("getAllRackUnitInfos", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          GetAllRackUnitInfosResult ret = new GetAllRackUnitInfosResult();
          ret._ret_ = new java.util.ArrayList<com.raritan.idl.assetmgrmodel.AssetStrip.RackUnitInfo>() {
            private static final long serialVersionUID = 1L;
            {
              final JSONArray array0 = result.getJSONArray("_ret_");
              for (int i0 = 0; i0 < array0.length(); i0++) {
                final int i0_f = i0;
                this.add(com.raritan.json_rpc.assetmgrmodel.AssetStrip.RackUnitInfo_Codec.decode(array0.getJSONObject(i0_f), agent));
              }
            }
          };
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public GetTagResult getTag(final int channel) throws Exception {
    JSONObject params = new JSONObject();
    params.put("channel", channel);
    final JSONObject result = rpcCall("getTag", params);
    GetTagResult ret = new GetTagResult();
    ret._ret_ = result.getInt("_ret_");
    ret.tagInfo = com.raritan.json_rpc.assetmgrmodel.AssetStrip.TagInfo_Codec.decode(result.getJSONObject("tagInfo"), agent);
    return ret;
  }

  @Override
  public AsyncRequest getTag(final int channel, final AsyncRpcResponse<GetTagResult> rsp) {
    return getTag(channel, rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest getTag(final int channel, final AsyncRpcResponse<GetTagResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = new JSONObject();
    try {
      params.put("channel", channel);
    } catch (Exception e) {
      rsp.onFailure(e);
    }
    return rpcCall("getTag", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          GetTagResult ret = new GetTagResult();
          ret._ret_ = result.getInt("_ret_");
          ret.tagInfo = com.raritan.json_rpc.assetmgrmodel.AssetStrip.TagInfo_Codec.decode(result.getJSONObject("tagInfo"), agent);
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public GetAllTagsResult getAllTags() throws Exception {
    JSONObject params = null;
    final JSONObject result = rpcCall("getAllTags", params);
    GetAllTagsResult ret = new GetAllTagsResult();
    ret._ret_ = result.getInt("_ret_");
    ret.tags = new java.util.ArrayList<com.raritan.idl.assetmgrmodel.AssetStrip.TagInfo>() {
      private static final long serialVersionUID = 1L;
      {
        final JSONArray array0 = result.getJSONArray("tags");
        for (int i0 = 0; i0 < array0.length(); i0++) {
          final int i0_f = i0;
          this.add(com.raritan.json_rpc.assetmgrmodel.AssetStrip.TagInfo_Codec.decode(array0.getJSONObject(i0_f), agent));
        }
      }
    };
    return ret;
  }

  @Override
  public AsyncRequest getAllTags(final AsyncRpcResponse<GetAllTagsResult> rsp) {
    return getAllTags(rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest getAllTags(final AsyncRpcResponse<GetAllTagsResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = null;
    return rpcCall("getAllTags", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          GetAllTagsResult ret = new GetAllTagsResult();
          ret._ret_ = result.getInt("_ret_");
          ret.tags = new java.util.ArrayList<com.raritan.idl.assetmgrmodel.AssetStrip.TagInfo>() {
            private static final long serialVersionUID = 1L;
            {
              final JSONArray array0 = result.getJSONArray("tags");
              for (int i0 = 0; i0 < array0.length(); i0++) {
                final int i0_f = i0;
                this.add(com.raritan.json_rpc.assetmgrmodel.AssetStrip.TagInfo_Codec.decode(array0.getJSONObject(i0_f), agent));
              }
            }
          };
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public TriggerPowercycleResult triggerPowercycle(final boolean hard) throws Exception {
    JSONObject params = new JSONObject();
    params.put("hard", hard);
    final JSONObject result = rpcCall("triggerPowercycle", params);
    TriggerPowercycleResult ret = new TriggerPowercycleResult();
    ret._ret_ = result.getInt("_ret_");
    return ret;
  }

  @Override
  public AsyncRequest triggerPowercycle(final boolean hard, final AsyncRpcResponse<TriggerPowercycleResult> rsp) {
    return triggerPowercycle(hard, rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest triggerPowercycle(final boolean hard, final AsyncRpcResponse<TriggerPowercycleResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = new JSONObject();
    try {
      params.put("hard", hard);
    } catch (Exception e) {
      rsp.onFailure(e);
    }
    return rpcCall("triggerPowercycle", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          TriggerPowercycleResult ret = new TriggerPowercycleResult();
          ret._ret_ = result.getInt("_ret_");
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }
}
