// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2025 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from SerialPort.idl.

package com.raritan.idl.serial;

import com.raritan.idl.*;
import com.raritan.util.AsyncRequest;

public interface SerialPort_3_0_1 {
  static public final TypeInfo typeInfo = new TypeInfo("serial.SerialPort:3.0.1", null);

  public static final int SUCCESS = 0;

  public static final int ERR_INVALID_VALUE = 1;

  public enum PortState {
    CONSOLE,
    ANALOGMODEM,
    GSMMODEM,
    DISCONNECTED;
  }

  public enum DetectionType {
    AUTOMATIC,
    FORCE_CONSOLE,
    FORCE_ANALOGMODEM,
    FORCE_GSMMODEM;
  }

  public enum BaudRate {
    BR1200,
    BR2400,
    BR4800,
    BR9600,
    BR19200,
    BR38400,
    BR57600,
    BR115200;
  }

  static public class MetaData implements Cloneable {
    public boolean hasModemSupport = false;

    public Object clone() {
      MetaData copy = new MetaData();

      copy.hasModemSupport = this.hasModemSupport;

      return copy;
    }

  }

  static public class State implements Cloneable {
    public com.raritan.idl.serial.SerialPort_3_0_1.PortState state = com.raritan.idl.serial.SerialPort_3_0_1.PortState.values()[0];
    public String deviceName = new String();

    public Object clone() {
      State copy = new State();

      copy.state = this.state;
      copy.deviceName = this.deviceName;

      return copy;
    }

  }

  static public class Settings implements Cloneable {
    public com.raritan.idl.serial.SerialPort_3_0_1.BaudRate consoleBaudRate = com.raritan.idl.serial.SerialPort_3_0_1.BaudRate.values()[0];
    public com.raritan.idl.serial.SerialPort_3_0_1.BaudRate modemBaudRate = com.raritan.idl.serial.SerialPort_3_0_1.BaudRate.values()[0];
    public com.raritan.idl.serial.SerialPort_3_0_1.DetectionType detectType = com.raritan.idl.serial.SerialPort_3_0_1.DetectionType.values()[0];

    public Object clone() {
      Settings copy = new Settings();

      copy.consoleBaudRate = this.consoleBaudRate;
      copy.modemBaudRate = this.modemBaudRate;
      copy.detectType = this.detectType;

      return copy;
    }

  }

  public class ModemEvent extends com.raritan.idl.idl.Event {

    static public final TypeInfo typeInfo = new TypeInfo("serial.SerialPort_3_0_1.ModemEvent:1.0.0", com.raritan.idl.idl.Event.typeInfo);

    @Override
    protected TypeInfo getClassTypeInfo() {
      return typeInfo;
    }

    public Object modem = null;
  }

  public class ModemAddedEvent extends com.raritan.idl.serial.SerialPort_3_0_1.ModemEvent {

    static public final TypeInfo typeInfo = new TypeInfo("serial.SerialPort_3_0_1.ModemAddedEvent:1.0.0", com.raritan.idl.serial.SerialPort_3_0_1.ModemEvent.typeInfo);

    @Override
    protected TypeInfo getClassTypeInfo() {
      return typeInfo;
    }

  }

  public class ModemRemovedEvent extends com.raritan.idl.serial.SerialPort_3_0_1.ModemEvent {

    static public final TypeInfo typeInfo = new TypeInfo("serial.SerialPort_3_0_1.ModemRemovedEvent:1.0.0", com.raritan.idl.serial.SerialPort_3_0_1.ModemEvent.typeInfo);

    @Override
    protected TypeInfo getClassTypeInfo() {
      return typeInfo;
    }

  }

  public class GetMetaDataResult {
    public com.raritan.idl.serial.SerialPort_3_0_1.MetaData _ret_;
  }

  GetMetaDataResult getMetaData() throws Exception;

  AsyncRequest getMetaData(AsyncRpcResponse<GetMetaDataResult> rsp);

  AsyncRequest getMetaData(AsyncRpcResponse<GetMetaDataResult> rsp, RpcCtrl rpcCtrl);


  public class GetSettingsResult {
    public com.raritan.idl.serial.SerialPort_3_0_1.Settings _ret_;
  }

  GetSettingsResult getSettings() throws Exception;

  AsyncRequest getSettings(AsyncRpcResponse<GetSettingsResult> rsp);

  AsyncRequest getSettings(AsyncRpcResponse<GetSettingsResult> rsp, RpcCtrl rpcCtrl);


  public class SetSettingsResult {
    public int _ret_;
  }

  SetSettingsResult setSettings(com.raritan.idl.serial.SerialPort_3_0_1.Settings settings) throws Exception;

  AsyncRequest setSettings(com.raritan.idl.serial.SerialPort_3_0_1.Settings settings, AsyncRpcResponse<SetSettingsResult> rsp);

  AsyncRequest setSettings(com.raritan.idl.serial.SerialPort_3_0_1.Settings settings, AsyncRpcResponse<SetSettingsResult> rsp, RpcCtrl rpcCtrl);


  public class GetStateResult {
    public com.raritan.idl.serial.SerialPort_3_0_1.State _ret_;
  }

  GetStateResult getState() throws Exception;

  AsyncRequest getState(AsyncRpcResponse<GetStateResult> rsp);

  AsyncRequest getState(AsyncRpcResponse<GetStateResult> rsp, RpcCtrl rpcCtrl);


  public class GetModemResult {
    public Object _ret_;
  }

  GetModemResult getModem() throws Exception;

  AsyncRequest getModem(AsyncRpcResponse<GetModemResult> rsp);

  AsyncRequest getModem(AsyncRpcResponse<GetModemResult> rsp, RpcCtrl rpcCtrl);

}
