// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2025 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from SerialPort.idl.

package com.raritan.idl.serial;

import com.raritan.idl.*;
import com.raritan.util.AsyncRequest;

public interface SerialPort {
  static public final TypeInfo typeInfo = new TypeInfo("serial.SerialPort:1.0.0", null);

  public static final int SUCCESS = 0;

  public static final int ERR_INVALID_VALUE = 1;

  public static final int ERR_NO_MODEM = 2;

  public enum PortState {
    CONSOLE,
    ANALOGMODEM,
    GSMMODEM;
  }

  public enum BaudRate {
    BR1200,
    BR2400,
    BR4800,
    BR9600,
    BR19200,
    BR38400,
    BR57600,
    BR115200;
  }

  static public class State implements Cloneable {
    public com.raritan.idl.serial.SerialPort.PortState state = com.raritan.idl.serial.SerialPort.PortState.values()[0];
    public String deviceName = new String();

    public Object clone() {
      State copy = new State();

      copy.state = this.state;
      copy.deviceName = this.deviceName;

      return copy;
    }

  }

  static public class ConsoleSettings implements Cloneable {
    public com.raritan.idl.serial.SerialPort.BaudRate baudRate = com.raritan.idl.serial.SerialPort.BaudRate.values()[0];

    public Object clone() {
      ConsoleSettings copy = new ConsoleSettings();

      copy.baudRate = this.baudRate;

      return copy;
    }

  }

  public class GetConsoleSettingsResult {
    public com.raritan.idl.serial.SerialPort.ConsoleSettings _ret_;
  }

  GetConsoleSettingsResult getConsoleSettings() throws Exception;

  AsyncRequest getConsoleSettings(AsyncRpcResponse<GetConsoleSettingsResult> rsp);

  AsyncRequest getConsoleSettings(AsyncRpcResponse<GetConsoleSettingsResult> rsp, RpcCtrl rpcCtrl);


  public class SetConsoleSettingsResult {
    public int _ret_;
  }

  SetConsoleSettingsResult setConsoleSettings(com.raritan.idl.serial.SerialPort.ConsoleSettings settings) throws Exception;

  AsyncRequest setConsoleSettings(com.raritan.idl.serial.SerialPort.ConsoleSettings settings, AsyncRpcResponse<SetConsoleSettingsResult> rsp);

  AsyncRequest setConsoleSettings(com.raritan.idl.serial.SerialPort.ConsoleSettings settings, AsyncRpcResponse<SetConsoleSettingsResult> rsp, RpcCtrl rpcCtrl);


  public class GetStateResult {
    public com.raritan.idl.serial.SerialPort.State _ret_;
  }

  GetStateResult getState() throws Exception;

  AsyncRequest getState(AsyncRpcResponse<GetStateResult> rsp);

  AsyncRequest getState(AsyncRpcResponse<GetStateResult> rsp, RpcCtrl rpcCtrl);


  public class GetGsmModemResult {
    public int _ret_;
    public com.raritan.idl.serial.GsmModem modem;
  }

  GetGsmModemResult getGsmModem() throws Exception;

  AsyncRequest getGsmModem(AsyncRpcResponse<GetGsmModemResult> rsp);

  AsyncRequest getGsmModem(AsyncRpcResponse<GetGsmModemResult> rsp, RpcCtrl rpcCtrl);

}
