// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2025 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from NumericSensor.idl.

package com.raritan.idl.sensors;

import com.raritan.idl.*;
import com.raritan.util.AsyncRequest;

public interface NumericSensor extends com.raritan.idl.sensors.Sensor {
  static public final TypeInfo typeInfo = new TypeInfo("sensors.NumericSensor:1.0.0", com.raritan.idl.sensors.Sensor.typeInfo);

  public enum Events {
    EVT_KEY_READING,
    EVT_KEY_STATE,
    EVT_KEY_METADATA,
    EVT_KEY_THRESHOLDS;
  }

  static public class Range implements Cloneable {
    public double lower = 0.0;
    public double upper = 0.0;

    public Object clone() {
      Range copy = new Range();

      copy.lower = this.lower;
      copy.upper = this.upper;

      return copy;
    }

  }

  static public class MetaData implements Cloneable {
    public com.raritan.idl.sensors.Sensor.TypeSpec type = new com.raritan.idl.sensors.Sensor.TypeSpec();
    public int decdigits = 0;
    public float accuracy = 0.0f;
    public float resolution = 0.0f;
    public float tolerance = 0.0f;
    public com.raritan.idl.sensors.NumericSensor.Range range = new com.raritan.idl.sensors.NumericSensor.Range();

    public Object clone() {
      MetaData copy = new MetaData();

      Object typeCopy = this.type.clone();
      copy.type = (com.raritan.idl.sensors.Sensor.TypeSpec) typeCopy;
      copy.decdigits = this.decdigits;
      copy.accuracy = this.accuracy;
      copy.resolution = this.resolution;
      copy.tolerance = this.tolerance;
      Object rangeCopy = this.range.clone();
      copy.range = (com.raritan.idl.sensors.NumericSensor.Range) rangeCopy;

      return copy;
    }

  }

  static public class Thresholds implements Cloneable {
    public boolean upperCriticalActive = false;
    public double upperCritical = 0.0;
    public boolean upperWarningActive = false;
    public double upperWarning = 0.0;
    public boolean lowerWarningActive = false;
    public double lowerWarning = 0.0;
    public boolean lowerCriticalActive = false;
    public double lowerCritical = 0.0;
    public int assertionTimeout = 0;
    public float deassertionHysteresis = 0.0f;

    public Object clone() {
      Thresholds copy = new Thresholds();

      copy.upperCriticalActive = this.upperCriticalActive;
      copy.upperCritical = this.upperCritical;
      copy.upperWarningActive = this.upperWarningActive;
      copy.upperWarning = this.upperWarning;
      copy.lowerWarningActive = this.lowerWarningActive;
      copy.lowerWarning = this.lowerWarning;
      copy.lowerCriticalActive = this.lowerCriticalActive;
      copy.lowerCritical = this.lowerCritical;
      copy.assertionTimeout = this.assertionTimeout;
      copy.deassertionHysteresis = this.deassertionHysteresis;

      return copy;
    }

  }

  static public class Reading implements Cloneable {

    static public class Status implements Cloneable {
      public boolean aboveUpperCritical = false;
      public boolean aboveUpperWarning = false;
      public boolean belowLowerWarning = false;
      public boolean belowLowerCritical = false;

      public Object clone() {
        Status copy = new Status();

        copy.aboveUpperCritical = this.aboveUpperCritical;
        copy.aboveUpperWarning = this.aboveUpperWarning;
        copy.belowLowerWarning = this.belowLowerWarning;
        copy.belowLowerCritical = this.belowLowerCritical;

        return copy;
      }

    }
    public java.util.Date timestamp = new java.util.Date();
    public boolean available = false;
    public com.raritan.idl.sensors.NumericSensor.Reading.Status status = new com.raritan.idl.sensors.NumericSensor.Reading.Status();
    public boolean valid = false;
    public double value = 0.0;

    public Object clone() {
      Reading copy = new Reading();

      copy.timestamp = this.timestamp;
      copy.available = this.available;
      Object statusCopy = this.status.clone();
      copy.status = (com.raritan.idl.sensors.NumericSensor.Reading.Status) statusCopy;
      copy.valid = this.valid;
      copy.value = this.value;

      return copy;
    }

  }

  public class GetMetaDataResult {
    public com.raritan.idl.sensors.NumericSensor.MetaData _ret_;
  }

  GetMetaDataResult getMetaData() throws Exception;

  AsyncRequest getMetaData(AsyncRpcResponse<GetMetaDataResult> rsp);

  AsyncRequest getMetaData(AsyncRpcResponse<GetMetaDataResult> rsp, RpcCtrl rpcCtrl);


  public class GetDefaultThresholdsResult {
    public com.raritan.idl.sensors.NumericSensor.Thresholds _ret_;
  }

  GetDefaultThresholdsResult getDefaultThresholds() throws Exception;

  AsyncRequest getDefaultThresholds(AsyncRpcResponse<GetDefaultThresholdsResult> rsp);

  AsyncRequest getDefaultThresholds(AsyncRpcResponse<GetDefaultThresholdsResult> rsp, RpcCtrl rpcCtrl);


  public class GetThresholdsResult {
    public com.raritan.idl.sensors.NumericSensor.Thresholds _ret_;
  }

  GetThresholdsResult getThresholds() throws Exception;

  AsyncRequest getThresholds(AsyncRpcResponse<GetThresholdsResult> rsp);

  AsyncRequest getThresholds(AsyncRpcResponse<GetThresholdsResult> rsp, RpcCtrl rpcCtrl);


  public class SetThresholdsResult {
    public int _ret_;
  }

  SetThresholdsResult setThresholds(com.raritan.idl.sensors.NumericSensor.Thresholds thresh) throws Exception;

  AsyncRequest setThresholds(com.raritan.idl.sensors.NumericSensor.Thresholds thresh, AsyncRpcResponse<SetThresholdsResult> rsp);

  AsyncRequest setThresholds(com.raritan.idl.sensors.NumericSensor.Thresholds thresh, AsyncRpcResponse<SetThresholdsResult> rsp, RpcCtrl rpcCtrl);


  public class GetReadingResult {
    public com.raritan.idl.sensors.NumericSensor.Reading _ret_;
  }

  GetReadingResult getReading() throws Exception;

  AsyncRequest getReading(AsyncRpcResponse<GetReadingResult> rsp);

  AsyncRequest getReading(AsyncRpcResponse<GetReadingResult> rsp, RpcCtrl rpcCtrl);

}
