// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2025 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from PeripheralDeviceManager.idl.

package com.raritan.idl.peripheral;

import com.raritan.idl.*;
import com.raritan.util.AsyncRequest;

public interface DeviceManager_5_0_3 {
  static public final TypeInfo typeInfo = new TypeInfo("peripheral.DeviceManager:5.0.3", null);

  public static final int ERR_INVALID_PARAMS = 1;

  public static final int ERR_NOT_ON_SECONDARY = 2;

  public enum ZCoordMode {
    RACKUNITS,
    FREEFORM;
  }

  static public class Settings implements Cloneable {
    public com.raritan.idl.peripheral.DeviceManager_5_0_3.ZCoordMode zCoordMode = com.raritan.idl.peripheral.DeviceManager_5_0_3.ZCoordMode.values()[0];
    public boolean autoManageNewDevices = false;
    public float deviceAltitude = 0.0f;
    public int presenceDetectionTimeout = 0;
    public java.util.Map<String, com.raritan.idl.sensors.NumericSensor_4_0_6.Thresholds> defaultThresholdsMap = new java.util.HashMap<>();
    public int maxActivePoweredDryContacts = 0;
    public boolean muteOtherAccessControlUnit = false;

    public Object clone() {
      Settings copy = new Settings();

      copy.zCoordMode = this.zCoordMode;
      copy.autoManageNewDevices = this.autoManageNewDevices;
      copy.deviceAltitude = this.deviceAltitude;
      copy.presenceDetectionTimeout = this.presenceDetectionTimeout;
      copy.defaultThresholdsMap = new java.util.HashMap<String, com.raritan.idl.sensors.NumericSensor_4_0_6.Thresholds>(this.defaultThresholdsMap);
      copy.maxActivePoweredDryContacts = this.maxActivePoweredDryContacts;
      copy.muteOtherAccessControlUnit = this.muteOtherAccessControlUnit;

      return copy;
    }

  }

  static public class MetaData implements Cloneable {
    public int oneWirePortCount = 0;
    public int onboardDeviceCount = 0;

    public Object clone() {
      MetaData copy = new MetaData();

      copy.oneWirePortCount = this.oneWirePortCount;
      copy.onboardDeviceCount = this.onboardDeviceCount;

      return copy;
    }

  }

  static public class DeviceTypeInfo implements Cloneable {
    public com.raritan.idl.sensors.Sensor_4_0_5.TypeSpec type = new com.raritan.idl.sensors.Sensor_4_0_5.TypeSpec();
    public boolean isActuator = false;
    public String identifier = new String();
    public String name = new String();
    public com.raritan.idl.sensors.NumericSensor_4_0_6.Range defaultRange = new com.raritan.idl.sensors.NumericSensor_4_0_6.Range();
    public int defaultDecDigits = 0;

    public Object clone() {
      DeviceTypeInfo copy = new DeviceTypeInfo();

      Object typeCopy = this.type.clone();
      copy.type = (com.raritan.idl.sensors.Sensor_4_0_5.TypeSpec) typeCopy;
      copy.isActuator = this.isActuator;
      copy.identifier = this.identifier;
      copy.name = this.name;
      Object defaultRangeCopy = this.defaultRange.clone();
      copy.defaultRange = (com.raritan.idl.sensors.NumericSensor_4_0_6.Range) defaultRangeCopy;
      copy.defaultDecDigits = this.defaultDecDigits;

      return copy;
    }

  }

  static public class FirmwareUpdateState implements Cloneable {
    public boolean active = false;
    public int remaining = 0;

    public Object clone() {
      FirmwareUpdateState copy = new FirmwareUpdateState();

      copy.active = this.active;
      copy.remaining = this.remaining;

      return copy;
    }

  }

  public class SettingsChangedEvent extends com.raritan.idl.event.UserEvent {

    static public final TypeInfo typeInfo = new TypeInfo("peripheral.DeviceManager_5_0_3.SettingsChangedEvent:1.0.0", com.raritan.idl.event.UserEvent.typeInfo);

    @Override
    protected TypeInfo getClassTypeInfo() {
      return typeInfo;
    }

    public com.raritan.idl.peripheral.DeviceManager_5_0_3.Settings oldSettings = new com.raritan.idl.peripheral.DeviceManager_5_0_3.Settings();
    public com.raritan.idl.peripheral.DeviceManager_5_0_3.Settings newSettings = new com.raritan.idl.peripheral.DeviceManager_5_0_3.Settings();
  }

  public class DeviceEvent extends com.raritan.idl.idl.Event {

    static public final TypeInfo typeInfo = new TypeInfo("peripheral.DeviceManager_5_0_3.DeviceEvent:1.0.0", com.raritan.idl.idl.Event.typeInfo);

    @Override
    protected TypeInfo getClassTypeInfo() {
      return typeInfo;
    }

    public java.util.List<com.raritan.idl.peripheral.Device_7_0_0> devices = new java.util.ArrayList<>();
    public java.util.List<com.raritan.idl.peripheral.Device_7_0_0> allDevices = new java.util.ArrayList<>();
  }

  public class DeviceAddedEvent extends com.raritan.idl.peripheral.DeviceManager_5_0_3.DeviceEvent {

    static public final TypeInfo typeInfo = new TypeInfo("peripheral.DeviceManager_5_0_3.DeviceAddedEvent:1.0.0", com.raritan.idl.peripheral.DeviceManager_5_0_3.DeviceEvent.typeInfo);

    @Override
    protected TypeInfo getClassTypeInfo() {
      return typeInfo;
    }

  }

  public class DeviceRemovedEvent extends com.raritan.idl.peripheral.DeviceManager_5_0_3.DeviceEvent {

    static public final TypeInfo typeInfo = new TypeInfo("peripheral.DeviceManager_5_0_3.DeviceRemovedEvent:1.0.0", com.raritan.idl.peripheral.DeviceManager_5_0_3.DeviceEvent.typeInfo);

    @Override
    protected TypeInfo getClassTypeInfo() {
      return typeInfo;
    }

  }

  public class UnknownDeviceAttachedEvent extends com.raritan.idl.idl.Event {

    static public final TypeInfo typeInfo = new TypeInfo("peripheral.DeviceManager_5_0_3.UnknownDeviceAttachedEvent:1.0.0", com.raritan.idl.idl.Event.typeInfo);

    @Override
    protected TypeInfo getClassTypeInfo() {
      return typeInfo;
    }

    public String romCode = new String();
    public java.util.List<com.raritan.idl.peripheral.PosElement_4_0_0> position = new java.util.ArrayList<>();
  }

  public enum DeviceFirmwareUpdateState {
    UPDATE_STARTED,
    UPDATE_SUCCESSFUL,
    UPDATE_FAILED;
  }

  public class DeviceFirmwareUpdateStateChangedEvent extends com.raritan.idl.idl.Event {

    static public final TypeInfo typeInfo = new TypeInfo("peripheral.DeviceManager_5_0_3.DeviceFirmwareUpdateStateChangedEvent:1.0.0", com.raritan.idl.idl.Event.typeInfo);

    @Override
    protected TypeInfo getClassTypeInfo() {
      return typeInfo;
    }

    public String oldVersion = new String();
    public String newVersion = new String();
    public String serial = new String();
    public com.raritan.idl.peripheral.DeviceManager_5_0_3.DeviceFirmwareUpdateState state = com.raritan.idl.peripheral.DeviceManager_5_0_3.DeviceFirmwareUpdateState.values()[0];
  }

  public class FirmwareUpdateStateChangedEvent extends com.raritan.idl.idl.Event {

    static public final TypeInfo typeInfo = new TypeInfo("peripheral.DeviceManager_5_0_3.FirmwareUpdateStateChangedEvent:1.0.0", com.raritan.idl.idl.Event.typeInfo);

    @Override
    protected TypeInfo getClassTypeInfo() {
      return typeInfo;
    }

    public com.raritan.idl.peripheral.DeviceManager_5_0_3.FirmwareUpdateState newState = new com.raritan.idl.peripheral.DeviceManager_5_0_3.FirmwareUpdateState();
  }

  public class PackageEvent extends com.raritan.idl.idl.Event {

    static public final TypeInfo typeInfo = new TypeInfo("peripheral.DeviceManager_5_0_3.PackageEvent:1.0.0", com.raritan.idl.idl.Event.typeInfo);

    @Override
    protected TypeInfo getClassTypeInfo() {
      return typeInfo;
    }

    public java.util.List<com.raritan.idl.peripheral.PackageInfo_5_0_0> packageInfos = new java.util.ArrayList<>();
    public java.util.List<com.raritan.idl.peripheral.PackageInfo_5_0_0> allPackages = new java.util.ArrayList<>();
  }

  public class PackageAddedEvent extends com.raritan.idl.peripheral.DeviceManager_5_0_3.PackageEvent {

    static public final TypeInfo typeInfo = new TypeInfo("peripheral.DeviceManager_5_0_3.PackageAddedEvent:1.0.0", com.raritan.idl.peripheral.DeviceManager_5_0_3.PackageEvent.typeInfo);

    @Override
    protected TypeInfo getClassTypeInfo() {
      return typeInfo;
    }

  }

  public class PackageRemovedEvent extends com.raritan.idl.peripheral.DeviceManager_5_0_3.PackageEvent {

    static public final TypeInfo typeInfo = new TypeInfo("peripheral.DeviceManager_5_0_3.PackageRemovedEvent:1.0.0", com.raritan.idl.peripheral.DeviceManager_5_0_3.PackageEvent.typeInfo);

    @Override
    protected TypeInfo getClassTypeInfo() {
      return typeInfo;
    }

  }

  static public class Statistics implements Cloneable {
    public int cSumErrCnt = 0;
    public int fuseTripCnt = 0;

    public Object clone() {
      Statistics copy = new Statistics();

      copy.cSumErrCnt = this.cSumErrCnt;
      copy.fuseTripCnt = this.fuseTripCnt;

      return copy;
    }

  }

  public class GetDeviceSlotsResult {
    public java.util.List<com.raritan.idl.peripheral.DeviceSlot_4_0_2> _ret_;
  }

  GetDeviceSlotsResult getDeviceSlots() throws Exception;

  AsyncRequest getDeviceSlots(AsyncRpcResponse<GetDeviceSlotsResult> rsp);

  AsyncRequest getDeviceSlots(AsyncRpcResponse<GetDeviceSlotsResult> rsp, RpcCtrl rpcCtrl);


  public class GetDeviceSlotResult {
    public com.raritan.idl.peripheral.DeviceSlot_4_0_2 _ret_;
  }

  GetDeviceSlotResult getDeviceSlot(int idx) throws Exception;

  AsyncRequest getDeviceSlot(int idx, AsyncRpcResponse<GetDeviceSlotResult> rsp);

  AsyncRequest getDeviceSlot(int idx, AsyncRpcResponse<GetDeviceSlotResult> rsp, RpcCtrl rpcCtrl);


  public class GetSensorHubsResult {
    public java.util.List<com.raritan.idl.peripheral.SensorHub_2_0_2> _ret_;
  }

  GetSensorHubsResult getSensorHubs() throws Exception;

  AsyncRequest getSensorHubs(AsyncRpcResponse<GetSensorHubsResult> rsp);

  AsyncRequest getSensorHubs(AsyncRpcResponse<GetSensorHubsResult> rsp, RpcCtrl rpcCtrl);


  public class GetDiscoveredDevicesResult {
    public java.util.List<com.raritan.idl.peripheral.Device_7_0_0> _ret_;
  }

  GetDiscoveredDevicesResult getDiscoveredDevices() throws Exception;

  AsyncRequest getDiscoveredDevices(AsyncRpcResponse<GetDiscoveredDevicesResult> rsp);

  AsyncRequest getDiscoveredDevices(AsyncRpcResponse<GetDiscoveredDevicesResult> rsp, RpcCtrl rpcCtrl);


  public class GetDiscoveredPackageInfosResult {
    public java.util.List<com.raritan.idl.peripheral.PackageInfo_5_0_0> _ret_;
  }

  GetDiscoveredPackageInfosResult getDiscoveredPackageInfos() throws Exception;

  AsyncRequest getDiscoveredPackageInfos(AsyncRpcResponse<GetDiscoveredPackageInfosResult> rsp);

  AsyncRequest getDiscoveredPackageInfos(AsyncRpcResponse<GetDiscoveredPackageInfosResult> rsp, RpcCtrl rpcCtrl);


  public class GetSettingsResult {
    public com.raritan.idl.peripheral.DeviceManager_5_0_3.Settings _ret_;
  }

  GetSettingsResult getSettings() throws Exception;

  AsyncRequest getSettings(AsyncRpcResponse<GetSettingsResult> rsp);

  AsyncRequest getSettings(AsyncRpcResponse<GetSettingsResult> rsp, RpcCtrl rpcCtrl);


  public class SetSettingsResult {
    public int _ret_;
  }

  SetSettingsResult setSettings(com.raritan.idl.peripheral.DeviceManager_5_0_3.Settings settings) throws Exception;

  AsyncRequest setSettings(com.raritan.idl.peripheral.DeviceManager_5_0_3.Settings settings, AsyncRpcResponse<SetSettingsResult> rsp);

  AsyncRequest setSettings(com.raritan.idl.peripheral.DeviceManager_5_0_3.Settings settings, AsyncRpcResponse<SetSettingsResult> rsp, RpcCtrl rpcCtrl);


  public class GetMetaDataResult {
    public com.raritan.idl.peripheral.DeviceManager_5_0_3.MetaData _ret_;
  }

  GetMetaDataResult getMetaData() throws Exception;

  AsyncRequest getMetaData(AsyncRpcResponse<GetMetaDataResult> rsp);

  AsyncRequest getMetaData(AsyncRpcResponse<GetMetaDataResult> rsp, RpcCtrl rpcCtrl);


  public class GetDeviceTypeInfosResult {
    public java.util.List<com.raritan.idl.peripheral.DeviceManager_5_0_3.DeviceTypeInfo> _ret_;
  }

  GetDeviceTypeInfosResult getDeviceTypeInfos() throws Exception;

  AsyncRequest getDeviceTypeInfos(AsyncRpcResponse<GetDeviceTypeInfosResult> rsp);

  AsyncRequest getDeviceTypeInfos(AsyncRpcResponse<GetDeviceTypeInfosResult> rsp, RpcCtrl rpcCtrl);


  public class GetFirmwareUpdateStateResult {
    public com.raritan.idl.peripheral.DeviceManager_5_0_3.FirmwareUpdateState _ret_;
  }

  GetFirmwareUpdateStateResult getFirmwareUpdateState() throws Exception;

  AsyncRequest getFirmwareUpdateState(AsyncRpcResponse<GetFirmwareUpdateStateResult> rsp);

  AsyncRequest getFirmwareUpdateState(AsyncRpcResponse<GetFirmwareUpdateStateResult> rsp, RpcCtrl rpcCtrl);


  public class GetStatisticsResult {
    public com.raritan.idl.peripheral.DeviceManager_5_0_3.Statistics _ret_;
  }

  GetStatisticsResult getStatistics() throws Exception;

  AsyncRequest getStatistics(AsyncRpcResponse<GetStatisticsResult> rsp);

  AsyncRequest getStatistics(AsyncRpcResponse<GetStatisticsResult> rsp, RpcCtrl rpcCtrl);


  public class GetDiscoveredPackagesResult {
    public java.util.List<com.raritan.idl.peripheral.Package_3_0_1> _ret_;
  }

  GetDiscoveredPackagesResult getDiscoveredPackages() throws Exception;

  AsyncRequest getDiscoveredPackages(AsyncRpcResponse<GetDiscoveredPackagesResult> rsp);

  AsyncRequest getDiscoveredPackages(AsyncRpcResponse<GetDiscoveredPackagesResult> rsp, RpcCtrl rpcCtrl);


  public class GetPortFuseResult {
    public com.raritan.idl.portsmodel.PortFuse_1_0_1 _ret_;
  }

  GetPortFuseResult getPortFuse() throws Exception;

  AsyncRequest getPortFuse(AsyncRpcResponse<GetPortFuseResult> rsp);

  AsyncRequest getPortFuse(AsyncRpcResponse<GetPortFuseResult> rsp, RpcCtrl rpcCtrl);


  public class GetGatewaySensorManagerResult {
    public com.raritan.idl.peripheral.GatewaySensorManager _ret_;
  }

  GetGatewaySensorManagerResult getGatewaySensorManager() throws Exception;

  AsyncRequest getGatewaySensorManager(AsyncRpcResponse<GetGatewaySensorManagerResult> rsp);

  AsyncRequest getGatewaySensorManager(AsyncRpcResponse<GetGatewaySensorManagerResult> rsp, RpcCtrl rpcCtrl);

}
