// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2025 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from TransferSwitch.idl.

package com.raritan.idl.pdumodel;

import com.raritan.idl.*;
import com.raritan.util.AsyncRequest;

public interface TransferSwitch_1_0_2 extends com.raritan.idl.pdumodel.EDevice {
  static public final TypeInfo typeInfo = new TypeInfo("pdumodel.TransferSwitch:1.0.2", com.raritan.idl.pdumodel.EDevice.typeInfo);

  public static final int ERR_INVALID_PARAM = 1;

  public static final int ERR_SWITCH_FAULT = 2;

  public static final int ERR_SWITCH_POWER_FAIL = 3;

  public enum Events {
    EVT_KEY_SETTINGS_CHANGED;
  }

  public enum Type {
    STS;
  }

  public enum TransferReason {
    REASON_UNKNOWN,
    REASON_STARTUP,
    REASON_MANUAL_TRANSFER,
    REASON_AUTO_RETRANSFER,
    REASON_POWER_FAILURE,
    REASON_POWER_QUALITY,
    REASON_OVERLOAD,
    REASON_OVERHEAT,
    REASON_INTERNAL_FAILURE;
  }

  static public class MetaData implements Cloneable {
    public String label = new String();
    public com.raritan.idl.pdumodel.Nameplate namePlate = new com.raritan.idl.pdumodel.Nameplate();
    public com.raritan.idl.pdumodel.Rating rating = new com.raritan.idl.pdumodel.Rating();
    public com.raritan.idl.pdumodel.TransferSwitch_1_0_2.Type type = com.raritan.idl.pdumodel.TransferSwitch_1_0_2.Type.values()[0];
    public int sourceCount = 0;

    public Object clone() {
      MetaData copy = new MetaData();

      copy.label = this.label;
      Object namePlateCopy = this.namePlate.clone();
      copy.namePlate = (com.raritan.idl.pdumodel.Nameplate) namePlateCopy;
      Object ratingCopy = this.rating.clone();
      copy.rating = (com.raritan.idl.pdumodel.Rating) ratingCopy;
      copy.type = this.type;
      copy.sourceCount = this.sourceCount;

      return copy;
    }

  }

  public static final int OPERATIONAL_STATE_OFF = 0;

  public static final int OPERATIONAL_STATE_NORMAL = 1;

  public static final int OPERATIONAL_STATE_STANDBY = 2;

  static public class Sensors implements Cloneable {
    public com.raritan.idl.sensors.StateSensor_3_0_1 selectedSource = null;
    public com.raritan.idl.sensors.StateSensor_3_0_1 operationalState = null;
    public com.raritan.idl.sensors.NumericSensor_3_0_0 sourceVoltagePhaseSyncAngle = null;
    public com.raritan.idl.sensors.NumericSensor_3_0_0 temperature = null;
    public com.raritan.idl.sensors.NumericSensor_3_0_0 fanSpeed = null;
    public com.raritan.idl.sensors.StateSensor_3_0_1 overloadAlarm = null;
    public com.raritan.idl.sensors.StateSensor_3_0_1 overheatAlarm = null;
    public com.raritan.idl.sensors.StateSensor_3_0_1 phaseSyncAlarm = null;
    public com.raritan.idl.sensors.StateSensor_3_0_1 movFault = null;
    public com.raritan.idl.sensors.StateSensor_3_0_1 scrOpenFault = null;
    public com.raritan.idl.sensors.StateSensor_3_0_1 scrShortFault = null;
    public com.raritan.idl.sensors.StateSensor_3_0_1 fanFault = null;

    public Object clone() {
      Sensors copy = new Sensors();

      copy.selectedSource = this.selectedSource;
      copy.operationalState = this.operationalState;
      copy.sourceVoltagePhaseSyncAngle = this.sourceVoltagePhaseSyncAngle;
      copy.temperature = this.temperature;
      copy.fanSpeed = this.fanSpeed;
      copy.overloadAlarm = this.overloadAlarm;
      copy.overheatAlarm = this.overheatAlarm;
      copy.phaseSyncAlarm = this.phaseSyncAlarm;
      copy.movFault = this.movFault;
      copy.scrOpenFault = this.scrOpenFault;
      copy.scrShortFault = this.scrShortFault;
      copy.fanFault = this.fanFault;

      return copy;
    }

  }

  static public class OutputSensors implements Cloneable {
    public com.raritan.idl.sensors.NumericSensor_3_0_0 voltage = null;
    public com.raritan.idl.sensors.NumericSensor_3_0_0 current = null;
    public com.raritan.idl.sensors.NumericSensor_3_0_0 peakCurrent = null;
    public com.raritan.idl.sensors.NumericSensor_3_0_0 activePower = null;
    public com.raritan.idl.sensors.NumericSensor_3_0_0 apparentPower = null;
    public com.raritan.idl.sensors.NumericSensor_3_0_0 powerFactor = null;
    public com.raritan.idl.sensors.NumericSensor_3_0_0 activeEnergy = null;
    public com.raritan.idl.sensors.NumericSensor_3_0_0 apparentEnergy = null;
    public com.raritan.idl.sensors.NumericSensor_3_0_0 unbalancedCurrent = null;
    public com.raritan.idl.sensors.NumericSensor_3_0_0 lineFrequency = null;
    public com.raritan.idl.sensors.NumericSensor_3_0_0 phaseAngle = null;

    public Object clone() {
      OutputSensors copy = new OutputSensors();

      copy.voltage = this.voltage;
      copy.current = this.current;
      copy.peakCurrent = this.peakCurrent;
      copy.activePower = this.activePower;
      copy.apparentPower = this.apparentPower;
      copy.powerFactor = this.powerFactor;
      copy.activeEnergy = this.activeEnergy;
      copy.apparentEnergy = this.apparentEnergy;
      copy.unbalancedCurrent = this.unbalancedCurrent;
      copy.lineFrequency = this.lineFrequency;
      copy.phaseAngle = this.phaseAngle;

      return copy;
    }

  }

  static public class PowerQualitySettings implements Cloneable {
    public double minMarginalVoltage = 0.0;
    public double minGoodVoltage = 0.0;
    public double maxGoodVoltage = 0.0;
    public double maxMarginalVoltage = 0.0;
    public double voltageHysteresis = 0.0;
    public int voltageDetectTime = 0;
    public double minGoodFrequency = 0.0;
    public double maxGoodFrequency = 0.0;
    public double frequencyHysteresis = 0.0;

    public Object clone() {
      PowerQualitySettings copy = new PowerQualitySettings();

      copy.minMarginalVoltage = this.minMarginalVoltage;
      copy.minGoodVoltage = this.minGoodVoltage;
      copy.maxGoodVoltage = this.maxGoodVoltage;
      copy.maxMarginalVoltage = this.maxMarginalVoltage;
      copy.voltageHysteresis = this.voltageHysteresis;
      copy.voltageDetectTime = this.voltageDetectTime;
      copy.minGoodFrequency = this.minGoodFrequency;
      copy.maxGoodFrequency = this.maxGoodFrequency;
      copy.frequencyHysteresis = this.frequencyHysteresis;

      return copy;
    }

  }

  static public class Settings implements Cloneable {
    public String name = new String();
    public int preferredSource = 0;
    public boolean autoRetransfer = false;
    public boolean noAutoRetransferIfPhaseFault = false;
    public int autoRetransferWaitTime = 0;
    public boolean manualTransferEnabled = false;
    public com.raritan.idl.pdumodel.TransferSwitch_1_0_2.PowerQualitySettings powerQuality = new com.raritan.idl.pdumodel.TransferSwitch_1_0_2.PowerQualitySettings();

    public Object clone() {
      Settings copy = new Settings();

      copy.name = this.name;
      copy.preferredSource = this.preferredSource;
      copy.autoRetransfer = this.autoRetransfer;
      copy.noAutoRetransferIfPhaseFault = this.noAutoRetransferIfPhaseFault;
      copy.autoRetransferWaitTime = this.autoRetransferWaitTime;
      copy.manualTransferEnabled = this.manualTransferEnabled;
      Object powerQualityCopy = this.powerQuality.clone();
      copy.powerQuality = (com.raritan.idl.pdumodel.TransferSwitch_1_0_2.PowerQualitySettings) powerQualityCopy;

      return copy;
    }

  }

  public class GetMetaDataResult {
    public com.raritan.idl.pdumodel.TransferSwitch_1_0_2.MetaData _ret_;
  }

  GetMetaDataResult getMetaData() throws Exception;

  AsyncRequest getMetaData(AsyncRpcResponse<GetMetaDataResult> rsp);

  AsyncRequest getMetaData(AsyncRpcResponse<GetMetaDataResult> rsp, RpcCtrl rpcCtrl);


  public class GetSensorsResult {
    public com.raritan.idl.pdumodel.TransferSwitch_1_0_2.Sensors _ret_;
  }

  GetSensorsResult getSensors() throws Exception;

  AsyncRequest getSensors(AsyncRpcResponse<GetSensorsResult> rsp);

  AsyncRequest getSensors(AsyncRpcResponse<GetSensorsResult> rsp, RpcCtrl rpcCtrl);


  public class GetOutputSensorsResult {
    public com.raritan.idl.pdumodel.TransferSwitch_1_0_2.OutputSensors _ret_;
  }

  GetOutputSensorsResult getOutputSensors() throws Exception;

  AsyncRequest getOutputSensors(AsyncRpcResponse<GetOutputSensorsResult> rsp);

  AsyncRequest getOutputSensors(AsyncRpcResponse<GetOutputSensorsResult> rsp, RpcCtrl rpcCtrl);


  public class GetPolesResult {
    public java.util.List<com.raritan.idl.pdumodel.ThrowPole> _ret_;
  }

  GetPolesResult getPoles() throws Exception;

  AsyncRequest getPoles(AsyncRpcResponse<GetPolesResult> rsp);

  AsyncRequest getPoles(AsyncRpcResponse<GetPolesResult> rsp, RpcCtrl rpcCtrl);


  public class GetSettingsResult {
    public com.raritan.idl.pdumodel.TransferSwitch_1_0_2.Settings _ret_;
  }

  GetSettingsResult getSettings() throws Exception;

  AsyncRequest getSettings(AsyncRpcResponse<GetSettingsResult> rsp);

  AsyncRequest getSettings(AsyncRpcResponse<GetSettingsResult> rsp, RpcCtrl rpcCtrl);


  public class SetSettingsResult {
    public int _ret_;
  }

  SetSettingsResult setSettings(com.raritan.idl.pdumodel.TransferSwitch_1_0_2.Settings settings) throws Exception;

  AsyncRequest setSettings(com.raritan.idl.pdumodel.TransferSwitch_1_0_2.Settings settings, AsyncRpcResponse<SetSettingsResult> rsp);

  AsyncRequest setSettings(com.raritan.idl.pdumodel.TransferSwitch_1_0_2.Settings settings, AsyncRpcResponse<SetSettingsResult> rsp, RpcCtrl rpcCtrl);


  public class TransferToSourceResult {
    public int _ret_;
  }

  TransferToSourceResult transferToSource(int source, boolean faultOverride) throws Exception;

  AsyncRequest transferToSource(int source, boolean faultOverride, AsyncRpcResponse<TransferToSourceResult> rsp);

  AsyncRequest transferToSource(int source, boolean faultOverride, AsyncRpcResponse<TransferToSourceResult> rsp, RpcCtrl rpcCtrl);


  public class GetLastTransferReasonResult {
    public com.raritan.idl.pdumodel.TransferSwitch_1_0_2.TransferReason _ret_;
  }

  GetLastTransferReasonResult getLastTransferReason() throws Exception;

  AsyncRequest getLastTransferReason(AsyncRpcResponse<GetLastTransferReasonResult> rsp);

  AsyncRequest getLastTransferReason(AsyncRpcResponse<GetLastTransferReasonResult> rsp, RpcCtrl rpcCtrl);

}
