// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2025 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from Outlet.idl.

package com.raritan.idl.pdumodel;

import com.raritan.idl.*;
import com.raritan.util.AsyncRequest;

public interface Outlet_1_2_0 {
  static public final TypeInfo typeInfo = new TypeInfo("pdumodel.Outlet:1.2.0", null);

  public static final int ERR_OUTLET_NOT_SWITCHABLE = 1;

  public static final int ERR_LOAD_SHEDDING_ACTIVE = 2;

  public static final int ERR_INVALID_PARAM = 1;

  public enum Events {
    EVT_KEY_STATE_CHANGE,
    EVT_KEY_SETTINGS_CHANGE;
  }

  static public class MetaData implements Cloneable {
    public String label = new String();
    public String receptacleType = new String();
    public com.raritan.idl.pdumodel.Nameplate namePlate = new com.raritan.idl.pdumodel.Nameplate();
    public com.raritan.idl.pdumodel.Rating rating = new com.raritan.idl.pdumodel.Rating();
    public boolean isSwitchable = false;
    public int maxRelayCycleCnt = 0;

    public Object clone() {
      MetaData copy = new MetaData();

      copy.label = this.label;
      copy.receptacleType = this.receptacleType;
      Object namePlateCopy = this.namePlate.clone();
      copy.namePlate = (com.raritan.idl.pdumodel.Nameplate) namePlateCopy;
      Object ratingCopy = this.rating.clone();
      copy.rating = (com.raritan.idl.pdumodel.Rating) ratingCopy;
      copy.isSwitchable = this.isSwitchable;
      copy.maxRelayCycleCnt = this.maxRelayCycleCnt;

      return copy;
    }

  }

  public enum PowerState {
    PS_OFF,
    PS_ON;
  }

  static public class LedState implements Cloneable {
    public boolean red = false;
    public boolean green = false;
    public boolean blinking = false;

    public Object clone() {
      LedState copy = new LedState();

      copy.red = this.red;
      copy.green = this.green;
      copy.blinking = this.blinking;

      return copy;
    }

  }

  static public class State implements Cloneable {
    public boolean available = false;
    public com.raritan.idl.pdumodel.Outlet_1_2_0.PowerState powerState = com.raritan.idl.pdumodel.Outlet_1_2_0.PowerState.values()[0];
    public boolean switchOnInProgress = false;
    public boolean cycleInProgress = false;
    public com.raritan.idl.pdumodel.Outlet_1_2_0.LedState ledState = new com.raritan.idl.pdumodel.Outlet_1_2_0.LedState();
    public java.util.Date lastPowerStateChange = new java.util.Date();

    public Object clone() {
      State copy = new State();

      copy.available = this.available;
      copy.powerState = this.powerState;
      copy.switchOnInProgress = this.switchOnInProgress;
      copy.cycleInProgress = this.cycleInProgress;
      Object ledStateCopy = this.ledState.clone();
      copy.ledState = (com.raritan.idl.pdumodel.Outlet_1_2_0.LedState) ledStateCopy;
      copy.lastPowerStateChange = this.lastPowerStateChange;

      return copy;
    }

  }

  public enum StartupState {
    SS_ON,
    SS_OFF,
    SS_LASTKNOWN,
    SS_PDUDEF;
  }

  static public class Settings implements Cloneable {
    public String name = new String();
    public com.raritan.idl.pdumodel.Outlet_1_2_0.StartupState startupState = com.raritan.idl.pdumodel.Outlet_1_2_0.StartupState.values()[0];
    public boolean usePduCycleDelay = false;
    public int cycleDelay = 0;
    public boolean nonCritical = false;
    public int sequenceDelay = 0;

    public Object clone() {
      Settings copy = new Settings();

      copy.name = this.name;
      copy.startupState = this.startupState;
      copy.usePduCycleDelay = this.usePduCycleDelay;
      copy.cycleDelay = this.cycleDelay;
      copy.nonCritical = this.nonCritical;
      copy.sequenceDelay = this.sequenceDelay;

      return copy;
    }

  }

  static public class Sensors implements Cloneable {
    public com.raritan.idl.sensors.NumericSensor voltage = null;
    public com.raritan.idl.sensors.NumericSensor current = null;
    public com.raritan.idl.sensors.NumericSensor peakCurrent = null;
    public com.raritan.idl.sensors.NumericSensor maximumCurrent = null;
    public com.raritan.idl.sensors.NumericSensor unbalancedCurrent = null;
    public com.raritan.idl.sensors.NumericSensor activePower = null;
    public com.raritan.idl.sensors.NumericSensor apparentPower = null;
    public com.raritan.idl.sensors.NumericSensor powerFactor = null;
    public com.raritan.idl.sensors.NumericSensor activeEnergy = null;
    public com.raritan.idl.sensors.NumericSensor apparentEnergy = null;
    public com.raritan.idl.sensors.StateSensor outletState = null;

    public Object clone() {
      Sensors copy = new Sensors();

      copy.voltage = this.voltage;
      copy.current = this.current;
      copy.peakCurrent = this.peakCurrent;
      copy.maximumCurrent = this.maximumCurrent;
      copy.unbalancedCurrent = this.unbalancedCurrent;
      copy.activePower = this.activePower;
      copy.apparentPower = this.apparentPower;
      copy.powerFactor = this.powerFactor;
      copy.activeEnergy = this.activeEnergy;
      copy.apparentEnergy = this.apparentEnergy;
      copy.outletState = this.outletState;

      return copy;
    }

  }

  public class GetMetaDataResult {
    public com.raritan.idl.pdumodel.Outlet_1_2_0.MetaData _ret_;
  }

  GetMetaDataResult getMetaData() throws Exception;

  AsyncRequest getMetaData(AsyncRpcResponse<GetMetaDataResult> rsp);

  AsyncRequest getMetaData(AsyncRpcResponse<GetMetaDataResult> rsp, RpcCtrl rpcCtrl);


  public class GetSensorsResult {
    public com.raritan.idl.pdumodel.Outlet_1_2_0.Sensors _ret_;
  }

  GetSensorsResult getSensors() throws Exception;

  AsyncRequest getSensors(AsyncRpcResponse<GetSensorsResult> rsp);

  AsyncRequest getSensors(AsyncRpcResponse<GetSensorsResult> rsp, RpcCtrl rpcCtrl);


  public class GetStateResult {
    public com.raritan.idl.pdumodel.Outlet_1_2_0.State _ret_;
  }

  GetStateResult getState() throws Exception;

  AsyncRequest getState(AsyncRpcResponse<GetStateResult> rsp);

  AsyncRequest getState(AsyncRpcResponse<GetStateResult> rsp, RpcCtrl rpcCtrl);


  public class SetPowerStateResult {
    public int _ret_;
  }

  SetPowerStateResult setPowerState(com.raritan.idl.pdumodel.Outlet_1_2_0.PowerState pstate) throws Exception;

  AsyncRequest setPowerState(com.raritan.idl.pdumodel.Outlet_1_2_0.PowerState pstate, AsyncRpcResponse<SetPowerStateResult> rsp);

  AsyncRequest setPowerState(com.raritan.idl.pdumodel.Outlet_1_2_0.PowerState pstate, AsyncRpcResponse<SetPowerStateResult> rsp, RpcCtrl rpcCtrl);


  public class CyclePowerStateResult {
    public int _ret_;
  }

  CyclePowerStateResult cyclePowerState() throws Exception;

  AsyncRequest cyclePowerState(AsyncRpcResponse<CyclePowerStateResult> rsp);

  AsyncRequest cyclePowerState(AsyncRpcResponse<CyclePowerStateResult> rsp, RpcCtrl rpcCtrl);


  public class GetSettingsResult {
    public com.raritan.idl.pdumodel.Outlet_1_2_0.Settings _ret_;
  }

  GetSettingsResult getSettings() throws Exception;

  AsyncRequest getSettings(AsyncRpcResponse<GetSettingsResult> rsp);

  AsyncRequest getSettings(AsyncRpcResponse<GetSettingsResult> rsp, RpcCtrl rpcCtrl);


  public class SetSettingsResult {
    public int _ret_;
  }

  SetSettingsResult setSettings(com.raritan.idl.pdumodel.Outlet_1_2_0.Settings settings) throws Exception;

  AsyncRequest setSettings(com.raritan.idl.pdumodel.Outlet_1_2_0.Settings settings, AsyncRpcResponse<SetSettingsResult> rsp);

  AsyncRequest setSettings(com.raritan.idl.pdumodel.Outlet_1_2_0.Settings settings, AsyncRpcResponse<SetSettingsResult> rsp, RpcCtrl rpcCtrl);


  public class GetIOPResult {
    public com.raritan.idl.pdumodel.Inlet_1_0_1 i;
    public com.raritan.idl.pdumodel.OverCurrentProtector_1_1_0 o;
    public java.util.List<com.raritan.idl.pdumodel.Pole> p;
  }

  GetIOPResult getIOP() throws Exception;

  AsyncRequest getIOP(AsyncRpcResponse<GetIOPResult> rsp);

  AsyncRequest getIOP(AsyncRpcResponse<GetIOPResult> rsp, RpcCtrl rpcCtrl);


  public class GetControllerResult {
    public com.raritan.idl.pdumodel.Controller_2_0_0 _ret_;
  }

  GetControllerResult getController() throws Exception;

  AsyncRequest getController(AsyncRpcResponse<GetControllerResult> rsp);

  AsyncRequest getController(AsyncRpcResponse<GetControllerResult> rsp, RpcCtrl rpcCtrl);

}
