// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2025 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from EventEngine.idl.

package com.raritan.idl.event;

import com.raritan.idl.*;
import com.raritan.util.AsyncRequest;

public interface Engine {
  static public final TypeInfo typeInfo = new TypeInfo("event.Engine:1.0.0", null);

  static public class EventDesc implements Cloneable {

    public enum Type {
      NODE,
      DYN_NODE,
      LEAF;
    }
    public com.raritan.idl.event.Engine.EventDesc.Type eventDescType = com.raritan.idl.event.Engine.EventDesc.Type.values()[0];
    public com.raritan.idl.event.Event.Type eventType = com.raritan.idl.event.Event.Type.values()[0];
    public String dynNodeContext = new String();
    public String idComp = new String();
    public String name = new String();
    public java.util.List<com.raritan.idl.event.Engine.EventDesc> entries = new java.util.ArrayList<>();

    public Object clone() {
      EventDesc copy = new EventDesc();

      copy.eventDescType = this.eventDescType;
      copy.eventType = this.eventType;
      copy.dynNodeContext = this.dynNodeContext;
      copy.idComp = this.idComp;
      copy.name = this.name;
      copy.entries = new java.util.ArrayList<com.raritan.idl.event.Engine.EventDesc>(this.entries);

      return copy;
    }

  }

  public class ListEventDescsResult {
    public int _ret_;
    public java.util.List<com.raritan.idl.event.Engine.EventDesc> eventDescs;
  }

  ListEventDescsResult listEventDescs(java.util.List<String> eventIdPrefix) throws Exception;

  AsyncRequest listEventDescs(java.util.List<String> eventIdPrefix, AsyncRpcResponse<ListEventDescsResult> rsp);

  AsyncRequest listEventDescs(java.util.List<String> eventIdPrefix, AsyncRpcResponse<ListEventDescsResult> rsp, RpcCtrl rpcCtrl);


  public class ListActionTypesResult {
    public java.util.List<String> _ret_;
  }

  ListActionTypesResult listActionTypes() throws Exception;

  AsyncRequest listActionTypes(AsyncRpcResponse<ListActionTypesResult> rsp);

  AsyncRequest listActionTypes(AsyncRpcResponse<ListActionTypesResult> rsp, RpcCtrl rpcCtrl);


  static public class Action implements Cloneable {
    public String id = new String();
    public String name = new String();
    public boolean isSystem = false;
    public String type = new String();
    public java.util.List<com.raritan.idl.event.KeyValue> arguments = new java.util.ArrayList<>();

    public Object clone() {
      Action copy = new Action();

      copy.id = this.id;
      copy.name = this.name;
      copy.isSystem = this.isSystem;
      copy.type = this.type;
      copy.arguments = new java.util.ArrayList<com.raritan.idl.event.KeyValue>(this.arguments);

      return copy;
    }

  }

  public class AddActionResult {
    public int _ret_;
    public String actionId;
  }

  AddActionResult addAction(com.raritan.idl.event.Engine.Action action) throws Exception;

  AsyncRequest addAction(com.raritan.idl.event.Engine.Action action, AsyncRpcResponse<AddActionResult> rsp);

  AsyncRequest addAction(com.raritan.idl.event.Engine.Action action, AsyncRpcResponse<AddActionResult> rsp, RpcCtrl rpcCtrl);


  public class ModifyActionResult {
    public int _ret_;
  }

  ModifyActionResult modifyAction(com.raritan.idl.event.Engine.Action action) throws Exception;

  AsyncRequest modifyAction(com.raritan.idl.event.Engine.Action action, AsyncRpcResponse<ModifyActionResult> rsp);

  AsyncRequest modifyAction(com.raritan.idl.event.Engine.Action action, AsyncRpcResponse<ModifyActionResult> rsp, RpcCtrl rpcCtrl);


  public class DeleteActionResult {
    public int _ret_;
  }

  DeleteActionResult deleteAction(String actionId) throws Exception;

  AsyncRequest deleteAction(String actionId, AsyncRpcResponse<DeleteActionResult> rsp);

  AsyncRequest deleteAction(String actionId, AsyncRpcResponse<DeleteActionResult> rsp, RpcCtrl rpcCtrl);


  public class ListActionsResult {
    public java.util.List<com.raritan.idl.event.Engine.Action> _ret_;
  }

  ListActionsResult listActions() throws Exception;

  AsyncRequest listActions(AsyncRpcResponse<ListActionsResult> rsp);

  AsyncRequest listActions(AsyncRpcResponse<ListActionsResult> rsp, RpcCtrl rpcCtrl);


  public class TriggerActionResult {
    public int _ret_;
    public String errMsg;
  }

  TriggerActionResult triggerAction(String actionId, java.util.List<com.raritan.idl.event.KeyValue> context) throws Exception;

  AsyncRequest triggerAction(String actionId, java.util.List<com.raritan.idl.event.KeyValue> context, AsyncRpcResponse<TriggerActionResult> rsp);

  AsyncRequest triggerAction(String actionId, java.util.List<com.raritan.idl.event.KeyValue> context, AsyncRpcResponse<TriggerActionResult> rsp, RpcCtrl rpcCtrl);


  static public class Condition implements Cloneable {

    public enum Op {
      AND,
      OR,
      XOR;
    }

    public enum MatchType {
      ASSERTED,
      DEASSERTED,
      BOTH;
    }
    public boolean negate = false;
    public com.raritan.idl.event.Engine.Condition.Op operation = com.raritan.idl.event.Engine.Condition.Op.values()[0];
    public com.raritan.idl.event.Engine.Condition.MatchType matchType = com.raritan.idl.event.Engine.Condition.MatchType.values()[0];
    public java.util.List<String> eventId = new java.util.ArrayList<>();
    public java.util.List<com.raritan.idl.event.Engine.Condition> conditions = new java.util.ArrayList<>();

    public Object clone() {
      Condition copy = new Condition();

      copy.negate = this.negate;
      copy.operation = this.operation;
      copy.matchType = this.matchType;
      copy.eventId = new java.util.ArrayList<String>(this.eventId);
      copy.conditions = new java.util.ArrayList<com.raritan.idl.event.Engine.Condition>(this.conditions);

      return copy;
    }

  }

  static public class Rule implements Cloneable {
    public String id = new String();
    public String name = new String();
    public boolean isSystem = false;
    public boolean isEnabled = false;
    public boolean isAutoRearm = false;
    public boolean hasMatched = false;
    public com.raritan.idl.event.Engine.Condition condition = new com.raritan.idl.event.Engine.Condition();
    public java.util.List<String> actionIds = new java.util.ArrayList<>();
    public java.util.List<com.raritan.idl.event.KeyValue> arguments = new java.util.ArrayList<>();

    public Object clone() {
      Rule copy = new Rule();

      copy.id = this.id;
      copy.name = this.name;
      copy.isSystem = this.isSystem;
      copy.isEnabled = this.isEnabled;
      copy.isAutoRearm = this.isAutoRearm;
      copy.hasMatched = this.hasMatched;
      Object conditionCopy = this.condition.clone();
      copy.condition = (com.raritan.idl.event.Engine.Condition) conditionCopy;
      copy.actionIds = new java.util.ArrayList<String>(this.actionIds);
      copy.arguments = new java.util.ArrayList<com.raritan.idl.event.KeyValue>(this.arguments);

      return copy;
    }

  }

  public class AddRuleResult {
    public int _ret_;
    public String ruleId;
  }

  AddRuleResult addRule(com.raritan.idl.event.Engine.Rule rule) throws Exception;

  AsyncRequest addRule(com.raritan.idl.event.Engine.Rule rule, AsyncRpcResponse<AddRuleResult> rsp);

  AsyncRequest addRule(com.raritan.idl.event.Engine.Rule rule, AsyncRpcResponse<AddRuleResult> rsp, RpcCtrl rpcCtrl);


  public class ModifyRuleResult {
    public int _ret_;
  }

  ModifyRuleResult modifyRule(com.raritan.idl.event.Engine.Rule rule) throws Exception;

  AsyncRequest modifyRule(com.raritan.idl.event.Engine.Rule rule, AsyncRpcResponse<ModifyRuleResult> rsp);

  AsyncRequest modifyRule(com.raritan.idl.event.Engine.Rule rule, AsyncRpcResponse<ModifyRuleResult> rsp, RpcCtrl rpcCtrl);


  public class EnableRuleResult {
    public int _ret_;
  }

  EnableRuleResult enableRule(String ruleId) throws Exception;

  AsyncRequest enableRule(String ruleId, AsyncRpcResponse<EnableRuleResult> rsp);

  AsyncRequest enableRule(String ruleId, AsyncRpcResponse<EnableRuleResult> rsp, RpcCtrl rpcCtrl);


  public class DisableRuleResult {
    public int _ret_;
  }

  DisableRuleResult disableRule(String ruleId) throws Exception;

  AsyncRequest disableRule(String ruleId, AsyncRpcResponse<DisableRuleResult> rsp);

  AsyncRequest disableRule(String ruleId, AsyncRpcResponse<DisableRuleResult> rsp, RpcCtrl rpcCtrl);


  public class DeleteRuleResult {
    public int _ret_;
  }

  DeleteRuleResult deleteRule(String ruleId) throws Exception;

  AsyncRequest deleteRule(String ruleId, AsyncRpcResponse<DeleteRuleResult> rsp);

  AsyncRequest deleteRule(String ruleId, AsyncRpcResponse<DeleteRuleResult> rsp, RpcCtrl rpcCtrl);


  public class ListRulesResult {
    public java.util.List<com.raritan.idl.event.Engine.Rule> _ret_;
  }

  ListRulesResult listRules() throws Exception;

  AsyncRequest listRules(AsyncRpcResponse<ListRulesResult> rsp);

  AsyncRequest listRules(AsyncRpcResponse<ListRulesResult> rsp, RpcCtrl rpcCtrl);


  public class DeliverEventResult {
    public int _ret_;
  }

  DeliverEventResult deliverEvent(com.raritan.idl.event.Event event) throws Exception;

  AsyncRequest deliverEvent(com.raritan.idl.event.Event event, AsyncRpcResponse<DeliverEventResult> rsp);

  AsyncRequest deliverEvent(com.raritan.idl.event.Event event, AsyncRpcResponse<DeliverEventResult> rsp, RpcCtrl rpcCtrl);


  public class RearmRuleResult {
    public int _ret_;
  }

  RearmRuleResult rearmRule(String ruleId) throws Exception;

  AsyncRequest rearmRule(String ruleId, AsyncRpcResponse<RearmRuleResult> rsp);

  AsyncRequest rearmRule(String ruleId, AsyncRpcResponse<RearmRuleResult> rsp, RpcCtrl rpcCtrl);

}
