// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2025 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from AlarmManager.idl.

package com.raritan.idl.event;

import com.raritan.idl.*;
import com.raritan.util.AsyncRequest;

public interface AlarmManager {
  static public final TypeInfo typeInfo = new TypeInfo("event.AlarmManager:1.0.0", null);

  public static final int NO_ERROR = 0;

  public static final int ERR_UNKNOWN_ALARM_ID = 1;

  public static final int ERR_EXECUTING_ACTIONS = 2;

  static public class Alert implements Cloneable {
    public String eventCondition = new String();
    public String message = new String();
    public java.util.Date firstAppearance = new java.util.Date();
    public java.util.Date lastAppearance = new java.util.Date();
    public int numberAlerts = 0;

    public Object clone() {
      Alert copy = new Alert();

      copy.eventCondition = this.eventCondition;
      copy.message = this.message;
      copy.firstAppearance = this.firstAppearance;
      copy.lastAppearance = this.lastAppearance;
      copy.numberAlerts = this.numberAlerts;

      return copy;
    }

  }

  static public class Alarm implements Cloneable {
    public String id = new String();
    public String name = new String();
    public String actionId = new String();
    public java.util.List<com.raritan.idl.event.AlarmManager.Alert> alerts = new java.util.ArrayList<>();

    public Object clone() {
      Alarm copy = new Alarm();

      copy.id = this.id;
      copy.name = this.name;
      copy.actionId = this.actionId;
      copy.alerts = new java.util.ArrayList<com.raritan.idl.event.AlarmManager.Alert>(this.alerts);

      return copy;
    }

  }

  public class AlarmAddedEvent extends com.raritan.idl.idl.Event {

    static public final TypeInfo typeInfo = new TypeInfo("event.AlarmManager.AlarmAddedEvent:1.0.0", com.raritan.idl.idl.Event.typeInfo);

    @Override
    protected TypeInfo getClassTypeInfo() {
      return typeInfo;
    }

    public com.raritan.idl.event.AlarmManager.Alarm alarm = new com.raritan.idl.event.AlarmManager.Alarm();
  }

  public class AlarmUpdatedEvent extends com.raritan.idl.idl.Event {

    static public final TypeInfo typeInfo = new TypeInfo("event.AlarmManager.AlarmUpdatedEvent:1.0.0", com.raritan.idl.idl.Event.typeInfo);

    @Override
    protected TypeInfo getClassTypeInfo() {
      return typeInfo;
    }

    public com.raritan.idl.event.AlarmManager.Alarm alarm = new com.raritan.idl.event.AlarmManager.Alarm();
  }

  public class AlarmAcknowledgedEvent extends com.raritan.idl.idl.Event {

    static public final TypeInfo typeInfo = new TypeInfo("event.AlarmManager.AlarmAcknowledgedEvent:1.0.0", com.raritan.idl.idl.Event.typeInfo);

    @Override
    protected TypeInfo getClassTypeInfo() {
      return typeInfo;
    }

    public String alarmId = new String();
  }

  public class AcknowledgeAlarmResult {
    public int _ret_;
  }

  AcknowledgeAlarmResult acknowledgeAlarm(String alarmId) throws Exception;

  AsyncRequest acknowledgeAlarm(String alarmId, AsyncRpcResponse<AcknowledgeAlarmResult> rsp);

  AsyncRequest acknowledgeAlarm(String alarmId, AsyncRpcResponse<AcknowledgeAlarmResult> rsp, RpcCtrl rpcCtrl);


  public class ListAlarmsResult {
    public java.util.List<com.raritan.idl.event.AlarmManager.Alarm> _ret_;
  }

  ListAlarmsResult listAlarms() throws Exception;

  AsyncRequest listAlarms(AsyncRpcResponse<ListAlarmsResult> rsp);

  AsyncRequest listAlarms(AsyncRpcResponse<ListAlarmsResult> rsp, RpcCtrl rpcCtrl);

}
