// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2025 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from ServerSSLCert.idl.

package com.raritan.idl.cert;

import com.raritan.idl.*;
import com.raritan.util.AsyncRequest;

public interface ServerSSLCert {
  static public final TypeInfo typeInfo = new TypeInfo("cert.ServerSSLCert:1.0.0", null);

  static public class CommonAttributes implements Cloneable {
    public String country = new String();
    public String stateOrProvince = new String();
    public String locality = new String();
    public String organization = new String();
    public String organizationalUnit = new String();
    public String commonName = new String();
    public String emailAddress = new String();

    public Object clone() {
      CommonAttributes copy = new CommonAttributes();

      copy.country = this.country;
      copy.stateOrProvince = this.stateOrProvince;
      copy.locality = this.locality;
      copy.organization = this.organization;
      copy.organizationalUnit = this.organizationalUnit;
      copy.commonName = this.commonName;
      copy.emailAddress = this.emailAddress;

      return copy;
    }

  }

  static public class ReqInfo implements Cloneable {
    public com.raritan.idl.cert.ServerSSLCert.CommonAttributes subject = new com.raritan.idl.cert.ServerSSLCert.CommonAttributes();
    public int keyLength = 0;

    public Object clone() {
      ReqInfo copy = new ReqInfo();

      Object subjectCopy = this.subject.clone();
      copy.subject = (com.raritan.idl.cert.ServerSSLCert.CommonAttributes) subjectCopy;
      copy.keyLength = this.keyLength;

      return copy;
    }

  }

  static public class CertInfo implements Cloneable {
    public com.raritan.idl.cert.ServerSSLCert.CommonAttributes subject = new com.raritan.idl.cert.ServerSSLCert.CommonAttributes();
    public com.raritan.idl.cert.ServerSSLCert.CommonAttributes issuer = new com.raritan.idl.cert.ServerSSLCert.CommonAttributes();
    public String invalidBefore = new String();
    public String invalidAfter = new String();
    public String serialNumber = new String();
    public int keyLength = 0;

    public Object clone() {
      CertInfo copy = new CertInfo();

      Object subjectCopy = this.subject.clone();
      copy.subject = (com.raritan.idl.cert.ServerSSLCert.CommonAttributes) subjectCopy;
      Object issuerCopy = this.issuer.clone();
      copy.issuer = (com.raritan.idl.cert.ServerSSLCert.CommonAttributes) issuerCopy;
      copy.invalidBefore = this.invalidBefore;
      copy.invalidAfter = this.invalidAfter;
      copy.serialNumber = this.serialNumber;
      copy.keyLength = this.keyLength;

      return copy;
    }

  }

  static public class Info implements Cloneable {
    public boolean havePendingReq = false;
    public boolean havePendingCert = false;
    public com.raritan.idl.cert.ServerSSLCert.ReqInfo pendingReqInfo = new com.raritan.idl.cert.ServerSSLCert.ReqInfo();
    public com.raritan.idl.cert.ServerSSLCert.CertInfo pendingCertInfo = new com.raritan.idl.cert.ServerSSLCert.CertInfo();
    public com.raritan.idl.cert.ServerSSLCert.CertInfo activeCertInfo = new com.raritan.idl.cert.ServerSSLCert.CertInfo();
    public int maxSignDays = 0;

    public Object clone() {
      Info copy = new Info();

      copy.havePendingReq = this.havePendingReq;
      copy.havePendingCert = this.havePendingCert;
      Object pendingReqInfoCopy = this.pendingReqInfo.clone();
      copy.pendingReqInfo = (com.raritan.idl.cert.ServerSSLCert.ReqInfo) pendingReqInfoCopy;
      Object pendingCertInfoCopy = this.pendingCertInfo.clone();
      copy.pendingCertInfo = (com.raritan.idl.cert.ServerSSLCert.CertInfo) pendingCertInfoCopy;
      Object activeCertInfoCopy = this.activeCertInfo.clone();
      copy.activeCertInfo = (com.raritan.idl.cert.ServerSSLCert.CertInfo) activeCertInfoCopy;
      copy.maxSignDays = this.maxSignDays;

      return copy;
    }

  }

  public class GenerateUnsignedKeyPairResult {
    public int _ret_;
  }

  GenerateUnsignedKeyPairResult generateUnsignedKeyPair(com.raritan.idl.cert.ServerSSLCert.ReqInfo reqInfo, String challenge) throws Exception;

  AsyncRequest generateUnsignedKeyPair(com.raritan.idl.cert.ServerSSLCert.ReqInfo reqInfo, String challenge, AsyncRpcResponse<GenerateUnsignedKeyPairResult> rsp);

  AsyncRequest generateUnsignedKeyPair(com.raritan.idl.cert.ServerSSLCert.ReqInfo reqInfo, String challenge, AsyncRpcResponse<GenerateUnsignedKeyPairResult> rsp, RpcCtrl rpcCtrl);


  public class GenerateSelfSignedKeyPairResult {
    public int _ret_;
  }

  GenerateSelfSignedKeyPairResult generateSelfSignedKeyPair(com.raritan.idl.cert.ServerSSLCert.ReqInfo reqInfo, int days) throws Exception;

  AsyncRequest generateSelfSignedKeyPair(com.raritan.idl.cert.ServerSSLCert.ReqInfo reqInfo, int days, AsyncRpcResponse<GenerateSelfSignedKeyPairResult> rsp);

  AsyncRequest generateSelfSignedKeyPair(com.raritan.idl.cert.ServerSSLCert.ReqInfo reqInfo, int days, AsyncRpcResponse<GenerateSelfSignedKeyPairResult> rsp, RpcCtrl rpcCtrl);

  Void deletePending() throws Exception;

  AsyncRequest deletePending(AsyncRpcResponse<Void> rsp);

  AsyncRequest deletePending(AsyncRpcResponse<Void> rsp, RpcCtrl rpcCtrl);


  public class GetInfoResult {
    public com.raritan.idl.cert.ServerSSLCert.Info info;
  }

  GetInfoResult getInfo() throws Exception;

  AsyncRequest getInfo(AsyncRpcResponse<GetInfoResult> rsp);

  AsyncRequest getInfo(AsyncRpcResponse<GetInfoResult> rsp, RpcCtrl rpcCtrl);


  public class InstallPendingKeyPairResult {
    public int _ret_;
  }

  InstallPendingKeyPairResult installPendingKeyPair() throws Exception;

  AsyncRequest installPendingKeyPair(AsyncRpcResponse<InstallPendingKeyPairResult> rsp);

  AsyncRequest installPendingKeyPair(AsyncRpcResponse<InstallPendingKeyPairResult> rsp, RpcCtrl rpcCtrl);

}
