// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2025 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from BulkConfiguration.idl.

package com.raritan.idl.bulkcfg;

import com.raritan.idl.*;
import com.raritan.util.AsyncRequest;

public interface BulkConfiguration_1_0_2 {
  static public final TypeInfo typeInfo = new TypeInfo("bulkcfg.BulkConfiguration:1.0.2", null);

  public enum Status {
    UNKNOWN,
    UPLOAD_FAILED,
    RESTORE_PENDING,
    RESTORE_OK,
    RESTORE_FAILED;
  }

  public class GetStatusResult {
    public com.raritan.idl.bulkcfg.BulkConfiguration_1_0_2.Status status;
    public java.util.Date timeStamp;
  }

  GetStatusResult getStatus() throws Exception;

  AsyncRequest getStatus(AsyncRpcResponse<GetStatusResult> rsp);

  AsyncRequest getStatus(AsyncRpcResponse<GetStatusResult> rsp, RpcCtrl rpcCtrl);


  public enum FilterType {
    WHITELIST,
    BLACKLIST;
  }

  static public class Filter implements Cloneable {
    public String name = new String();
    public String displayName = new String();
    public boolean noOverride = false;
    public boolean bulkOnly = false;
    public java.util.List<String> ruleSpecs = new java.util.ArrayList<>();

    public Object clone() {
      Filter copy = new Filter();

      copy.name = this.name;
      copy.displayName = this.displayName;
      copy.noOverride = this.noOverride;
      copy.bulkOnly = this.bulkOnly;
      copy.ruleSpecs = new java.util.ArrayList<String>(this.ruleSpecs);

      return copy;
    }

  }

  static public class FilterProfile implements Cloneable {
    public String name = new String();
    public String description = new String();
    public java.util.Map<String, com.raritan.idl.bulkcfg.BulkConfiguration_1_0_2.FilterType> filterNameToTypeMap = new java.util.HashMap<>();

    public Object clone() {
      FilterProfile copy = new FilterProfile();

      copy.name = this.name;
      copy.description = this.description;
      copy.filterNameToTypeMap = new java.util.HashMap<String, com.raritan.idl.bulkcfg.BulkConfiguration_1_0_2.FilterType>(this.filterNameToTypeMap);

      return copy;
    }

  }

  static public class Settings implements Cloneable {
    public java.util.List<com.raritan.idl.bulkcfg.BulkConfiguration_1_0_2.FilterProfile> filterProfiles = new java.util.ArrayList<>();
    public String defaultProfileName = new String();

    public Object clone() {
      Settings copy = new Settings();

      copy.filterProfiles = new java.util.ArrayList<com.raritan.idl.bulkcfg.BulkConfiguration_1_0_2.FilterProfile>(this.filterProfiles);
      copy.defaultProfileName = this.defaultProfileName;

      return copy;
    }

  }

  public class SettingsChangedEvent extends com.raritan.idl.event.UserEvent {

    static public final TypeInfo typeInfo = new TypeInfo("bulkcfg.BulkConfiguration_1_0_2.SettingsChangedEvent:1.0.0", com.raritan.idl.event.UserEvent.typeInfo);

    @Override
    protected TypeInfo getClassTypeInfo() {
      return typeInfo;
    }

  }

  public class SavedEvent extends com.raritan.idl.event.UserEvent {

    static public final TypeInfo typeInfo = new TypeInfo("bulkcfg.BulkConfiguration_1_0_2.SavedEvent:1.0.0", com.raritan.idl.event.UserEvent.typeInfo);

    @Override
    protected TypeInfo getClassTypeInfo() {
      return typeInfo;
    }

    public boolean isBackup = false;
  }

  public class RestoredEvent extends com.raritan.idl.event.UserEvent {

    static public final TypeInfo typeInfo = new TypeInfo("bulkcfg.BulkConfiguration_1_0_2.RestoredEvent:1.0.0", com.raritan.idl.event.UserEvent.typeInfo);

    @Override
    protected TypeInfo getClassTypeInfo() {
      return typeInfo;
    }

    public boolean isBackup = false;
  }

  public static final int SUCCESS = 0;

  public static final int ERR_FILTER_NAME_UNKNOWN = 1;

  public static final int ERR_FILTER_TYPE_READONLY = 2;

  public static final int ERR_PROFILE_ALREADY_EXISTS = 3;

  public static final int ERR_PROFILE_DOES_NOT_EXIST = 4;

  public static final int ERR_PROFILE_IS_DEFAULT = 5;

  public static final int ERR_PROFILE_IS_BUILTIN = 6;

  public static final int ERR_PROFILE_NAME_TOO_LONG = 7;

  public static final int ERR_PROFILE_NAME_INVALID = 8;

  public static final int ERR_PROFILE_TOO_MANY = 9;

  public class GetFiltersResult {
    public java.util.List<com.raritan.idl.bulkcfg.BulkConfiguration_1_0_2.Filter> _ret_;
  }

  GetFiltersResult getFilters() throws Exception;

  AsyncRequest getFilters(AsyncRpcResponse<GetFiltersResult> rsp);

  AsyncRequest getFilters(AsyncRpcResponse<GetFiltersResult> rsp, RpcCtrl rpcCtrl);


  public class GetFilterProfilesResult {
    public java.util.List<com.raritan.idl.bulkcfg.BulkConfiguration_1_0_2.FilterProfile> _ret_;
  }

  GetFilterProfilesResult getFilterProfiles() throws Exception;

  AsyncRequest getFilterProfiles(AsyncRpcResponse<GetFilterProfilesResult> rsp);

  AsyncRequest getFilterProfiles(AsyncRpcResponse<GetFilterProfilesResult> rsp, RpcCtrl rpcCtrl);


  public class AddFilterProfileResult {
    public int _ret_;
  }

  AddFilterProfileResult addFilterProfile(com.raritan.idl.bulkcfg.BulkConfiguration_1_0_2.FilterProfile profile) throws Exception;

  AsyncRequest addFilterProfile(com.raritan.idl.bulkcfg.BulkConfiguration_1_0_2.FilterProfile profile, AsyncRpcResponse<AddFilterProfileResult> rsp);

  AsyncRequest addFilterProfile(com.raritan.idl.bulkcfg.BulkConfiguration_1_0_2.FilterProfile profile, AsyncRpcResponse<AddFilterProfileResult> rsp, RpcCtrl rpcCtrl);


  public class ModifyFilterProfileResult {
    public int _ret_;
  }

  ModifyFilterProfileResult modifyFilterProfile(com.raritan.idl.bulkcfg.BulkConfiguration_1_0_2.FilterProfile profile) throws Exception;

  AsyncRequest modifyFilterProfile(com.raritan.idl.bulkcfg.BulkConfiguration_1_0_2.FilterProfile profile, AsyncRpcResponse<ModifyFilterProfileResult> rsp);

  AsyncRequest modifyFilterProfile(com.raritan.idl.bulkcfg.BulkConfiguration_1_0_2.FilterProfile profile, AsyncRpcResponse<ModifyFilterProfileResult> rsp, RpcCtrl rpcCtrl);


  public class DeleteFilterProfileResult {
    public int _ret_;
  }

  DeleteFilterProfileResult deleteFilterProfile(String profileName) throws Exception;

  AsyncRequest deleteFilterProfile(String profileName, AsyncRpcResponse<DeleteFilterProfileResult> rsp);

  AsyncRequest deleteFilterProfile(String profileName, AsyncRpcResponse<DeleteFilterProfileResult> rsp, RpcCtrl rpcCtrl);


  public class GetDefaultFilterProfileNameResult {
    public String _ret_;
  }

  GetDefaultFilterProfileNameResult getDefaultFilterProfileName() throws Exception;

  AsyncRequest getDefaultFilterProfileName(AsyncRpcResponse<GetDefaultFilterProfileNameResult> rsp);

  AsyncRequest getDefaultFilterProfileName(AsyncRpcResponse<GetDefaultFilterProfileNameResult> rsp, RpcCtrl rpcCtrl);


  public class SelectDefaultFilterProfileResult {
    public int _ret_;
  }

  SelectDefaultFilterProfileResult selectDefaultFilterProfile(String profileName) throws Exception;

  AsyncRequest selectDefaultFilterProfile(String profileName, AsyncRpcResponse<SelectDefaultFilterProfileResult> rsp);

  AsyncRequest selectDefaultFilterProfile(String profileName, AsyncRpcResponse<SelectDefaultFilterProfileResult> rsp, RpcCtrl rpcCtrl);


  public class GetSettingsResult {
    public com.raritan.idl.bulkcfg.BulkConfiguration_1_0_2.Settings _ret_;
  }

  GetSettingsResult getSettings() throws Exception;

  AsyncRequest getSettings(AsyncRpcResponse<GetSettingsResult> rsp);

  AsyncRequest getSettings(AsyncRpcResponse<GetSettingsResult> rsp, RpcCtrl rpcCtrl);


  public class SetSettingsResult {
    public int _ret_;
  }

  SetSettingsResult setSettings(com.raritan.idl.bulkcfg.BulkConfiguration_1_0_2.Settings settings) throws Exception;

  AsyncRequest setSettings(com.raritan.idl.bulkcfg.BulkConfiguration_1_0_2.Settings settings, AsyncRpcResponse<SetSettingsResult> rsp);

  AsyncRequest setSettings(com.raritan.idl.bulkcfg.BulkConfiguration_1_0_2.Settings settings, AsyncRpcResponse<SetSettingsResult> rsp, RpcCtrl rpcCtrl);

}
