// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2025 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from AssetStrip.idl.

package com.raritan.idl.assetmgrmodel;

import com.raritan.idl.*;
import com.raritan.util.AsyncRequest;

public interface AssetStrip_2_0_0 {
  static public final TypeInfo typeInfo = new TypeInfo("assetmgrmodel.AssetStrip:2.0.0", null);

  public static final int NO_ERROR = 0;

  public static final int ERR_INVALID_PARAM = 1;

  public static final int ERR_NO_SUCH_OBJECT = 2;

  public static final int MAIN_STRIP_COLUMN = 0;

  public enum Events {
    EVT_KEY_STATE_CHANGED,
    EVT_KEY_SETTINGS_CHANGED,
    EVT_KEY_TAGS_CHANGED;
  }

  public enum State {
    DISCONNECTED,
    FIRMWARE_UPDATE,
    UNSUPPORTED,
    AVAILABLE;
  }

  public enum StripType {
    SIMPLE,
    COMPOSITE;
  }

  public enum TagType {
    SINGLE,
    EXTENSION,
    NONE;
  }

  public enum CascadeState {
    CASCADE_ACTIVE,
    CASCADE_FIRMWARE_UPDATE;
  }

  static public class DeviceInfo implements Cloneable {
    public int deviceId = 0;
    public int hardwareId = 0;
    public int protocolVersion = 0;
    public int bootVersion = 0;
    public int appVersion = 0;
    public boolean orientationSensAvailable = false;
    public boolean isCascadable = false;
    public boolean rackUnitCountConfigurable = false;

    public Object clone() {
      DeviceInfo copy = new DeviceInfo();

      copy.deviceId = this.deviceId;
      copy.hardwareId = this.hardwareId;
      copy.protocolVersion = this.protocolVersion;
      copy.bootVersion = this.bootVersion;
      copy.appVersion = this.appVersion;
      copy.orientationSensAvailable = this.orientationSensAvailable;
      copy.isCascadable = this.isCascadable;
      copy.rackUnitCountConfigurable = this.rackUnitCountConfigurable;

      return copy;
    }

  }

  static public class StripInfo implements Cloneable {
    public int maxMainTagCount = 0;
    public int maxBladeTagCount = 0;
    public int mainTagCount = 0;
    public int bladeTagCount = 0;
    public boolean bladeOverflow = false;
    public int rackUnitCount = 0;
    public int componentCount = 0;
    public com.raritan.idl.assetmgrmodel.AssetStrip_2_0_0.CascadeState cascadeState = com.raritan.idl.assetmgrmodel.AssetStrip_2_0_0.CascadeState.values()[0];

    public Object clone() {
      StripInfo copy = new StripInfo();

      copy.maxMainTagCount = this.maxMainTagCount;
      copy.maxBladeTagCount = this.maxBladeTagCount;
      copy.mainTagCount = this.mainTagCount;
      copy.bladeTagCount = this.bladeTagCount;
      copy.bladeOverflow = this.bladeOverflow;
      copy.rackUnitCount = this.rackUnitCount;
      copy.componentCount = this.componentCount;
      copy.cascadeState = this.cascadeState;

      return copy;
    }

  }

  static public class TagInfo implements Cloneable {
    public int rackUnitNumber = 0;
    public int slotNumber = 0;
    public String familyDesc = new String();
    public String rawId = new String();

    public Object clone() {
      TagInfo copy = new TagInfo();

      copy.rackUnitNumber = this.rackUnitNumber;
      copy.slotNumber = this.slotNumber;
      copy.familyDesc = this.familyDesc;
      copy.rawId = this.rawId;

      return copy;
    }

  }

  static public class RackUnitInfo implements Cloneable {
    public int rackUnitNumber = 0;
    public int rackUnitPosition = 0;
    public com.raritan.idl.assetmgrmodel.AssetStrip_2_0_0.TagType type = com.raritan.idl.assetmgrmodel.AssetStrip_2_0_0.TagType.values()[0];
    public int size = 0;
    public com.raritan.idl.assetmgrmodel.AssetStripConfig.RackUnitSettings settings = new com.raritan.idl.assetmgrmodel.AssetStripConfig.RackUnitSettings();

    public Object clone() {
      RackUnitInfo copy = new RackUnitInfo();

      copy.rackUnitNumber = this.rackUnitNumber;
      copy.rackUnitPosition = this.rackUnitPosition;
      copy.type = this.type;
      copy.size = this.size;
      Object settingsCopy = this.settings.clone();
      copy.settings = (com.raritan.idl.assetmgrmodel.AssetStripConfig.RackUnitSettings) settingsCopy;

      return copy;
    }

  }

  public class GetStateResult {
    public com.raritan.idl.assetmgrmodel.AssetStrip_2_0_0.State _ret_;
  }

  GetStateResult getState() throws Exception;

  AsyncRequest getState(AsyncRpcResponse<GetStateResult> rsp);

  AsyncRequest getState(AsyncRpcResponse<GetStateResult> rsp, RpcCtrl rpcCtrl);


  public class GetDeviceInfoResult {
    public com.raritan.idl.assetmgrmodel.AssetStrip_2_0_0.DeviceInfo _ret_;
  }

  GetDeviceInfoResult getDeviceInfo() throws Exception;

  AsyncRequest getDeviceInfo(AsyncRpcResponse<GetDeviceInfoResult> rsp);

  AsyncRequest getDeviceInfo(AsyncRpcResponse<GetDeviceInfoResult> rsp, RpcCtrl rpcCtrl);


  public class GetStripInfoResult {
    public com.raritan.idl.assetmgrmodel.AssetStrip_2_0_0.StripInfo _ret_;
  }

  GetStripInfoResult getStripInfo() throws Exception;

  AsyncRequest getStripInfo(AsyncRpcResponse<GetStripInfoResult> rsp);

  AsyncRequest getStripInfo(AsyncRpcResponse<GetStripInfoResult> rsp, RpcCtrl rpcCtrl);


  public class GetRackUnitInfoResult {
    public int _ret_;
    public com.raritan.idl.assetmgrmodel.AssetStrip_2_0_0.RackUnitInfo info;
  }

  GetRackUnitInfoResult getRackUnitInfo(int rackUnitNumber) throws Exception;

  AsyncRequest getRackUnitInfo(int rackUnitNumber, AsyncRpcResponse<GetRackUnitInfoResult> rsp);

  AsyncRequest getRackUnitInfo(int rackUnitNumber, AsyncRpcResponse<GetRackUnitInfoResult> rsp, RpcCtrl rpcCtrl);


  public class GetAllRackUnitInfosResult {
    public java.util.List<com.raritan.idl.assetmgrmodel.AssetStrip_2_0_0.RackUnitInfo> _ret_;
  }

  GetAllRackUnitInfosResult getAllRackUnitInfos() throws Exception;

  AsyncRequest getAllRackUnitInfos(AsyncRpcResponse<GetAllRackUnitInfosResult> rsp);

  AsyncRequest getAllRackUnitInfos(AsyncRpcResponse<GetAllRackUnitInfosResult> rsp, RpcCtrl rpcCtrl);


  public class GetTagResult {
    public int _ret_;
    public com.raritan.idl.assetmgrmodel.AssetStrip_2_0_0.TagInfo tagInfo;
  }

  GetTagResult getTag(int rackUnitNumber, int slotNumber) throws Exception;

  AsyncRequest getTag(int rackUnitNumber, int slotNumber, AsyncRpcResponse<GetTagResult> rsp);

  AsyncRequest getTag(int rackUnitNumber, int slotNumber, AsyncRpcResponse<GetTagResult> rsp, RpcCtrl rpcCtrl);


  public class GetAllTagsResult {
    public java.util.List<com.raritan.idl.assetmgrmodel.AssetStrip_2_0_0.TagInfo> _ret_;
  }

  GetAllTagsResult getAllTags() throws Exception;

  AsyncRequest getAllTags(AsyncRpcResponse<GetAllTagsResult> rsp);

  AsyncRequest getAllTags(AsyncRpcResponse<GetAllTagsResult> rsp, RpcCtrl rpcCtrl);


  public class GetMainTagsResult {
    public java.util.List<com.raritan.idl.assetmgrmodel.AssetStrip_2_0_0.TagInfo> _ret_;
  }

  GetMainTagsResult getMainTags() throws Exception;

  AsyncRequest getMainTags(AsyncRpcResponse<GetMainTagsResult> rsp);

  AsyncRequest getMainTags(AsyncRpcResponse<GetMainTagsResult> rsp, RpcCtrl rpcCtrl);


  public class GetExtensionTagsResult {
    public int _ret_;
    public java.util.List<com.raritan.idl.assetmgrmodel.AssetStrip_2_0_0.TagInfo> tags;
  }

  GetExtensionTagsResult getExtensionTags(int rackUnitNumber) throws Exception;

  AsyncRequest getExtensionTags(int rackUnitNumber, AsyncRpcResponse<GetExtensionTagsResult> rsp);

  AsyncRequest getExtensionTags(int rackUnitNumber, AsyncRpcResponse<GetExtensionTagsResult> rsp, RpcCtrl rpcCtrl);

  Void triggerPowercycle(boolean hard) throws Exception;

  AsyncRequest triggerPowercycle(boolean hard, AsyncRpcResponse<Void> rsp);

  AsyncRequest triggerPowercycle(boolean hard, AsyncRpcResponse<Void> rsp, RpcCtrl rpcCtrl);

}
