// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2025 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from SessionManager.idl.

package com.raritan.json_rpc.session;

import org.json.*;

import com.raritan.idl.*;
import com.raritan.json_rpc.*;
import com.raritan.util.AsyncRequest;

public class SessionManager_Proxy extends ObjectProxy implements com.raritan.idl.session.SessionManager {

  public SessionManager_Proxy(Agent agent, String rid, TypeInfo typeInfo) {
    super(agent, rid, typeInfo);
  }

  public SessionManager_Proxy(Agent agent, String rid) {
    this(agent, rid, com.raritan.idl.session.SessionManager.typeInfo);
  }

  public static SessionManager_Proxy staticCast(ObjectProxy proxy) {
    return proxy == null ? null : new SessionManager_Proxy(proxy.getAgent(), proxy.getRid(), proxy.getStaticTypeInfo());
  }


  @Override
  public NewSessionResult newSession() throws Exception {
    JSONObject params = null;
    final JSONObject result = rpcCall("newSession", params);
    NewSessionResult ret = new NewSessionResult();
    ret._ret_ = result.getInt("_ret_");
    ret.session = com.raritan.json_rpc.session.Session_Codec.decode(result.getJSONObject("session"), agent);
    return ret;
  }

  @Override
  public AsyncRequest newSession(final AsyncRpcResponse<NewSessionResult> rsp) {
    return newSession(rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest newSession(final AsyncRpcResponse<NewSessionResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = null;
    return rpcCall("newSession", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          NewSessionResult ret = new NewSessionResult();
          ret._ret_ = result.getInt("_ret_");
          ret.session = com.raritan.json_rpc.session.Session_Codec.decode(result.getJSONObject("session"), agent);
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public GetSessionResult getSession(final String token) throws Exception {
    JSONObject params = new JSONObject();
    params.put("token", token);
    final JSONObject result = rpcCall("getSession", params);
    GetSessionResult ret = new GetSessionResult();
    ret._ret_ = com.raritan.json_rpc.session.Session_Codec.decode(result.getJSONObject("_ret_"), agent);
    return ret;
  }

  @Override
  public AsyncRequest getSession(final String token, final AsyncRpcResponse<GetSessionResult> rsp) {
    return getSession(token, rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest getSession(final String token, final AsyncRpcResponse<GetSessionResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = new JSONObject();
    try {
      params.put("token", token);
    } catch (Exception e) {
      rsp.onFailure(e);
    }
    return rpcCall("getSession", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          GetSessionResult ret = new GetSessionResult();
          ret._ret_ = com.raritan.json_rpc.session.Session_Codec.decode(result.getJSONObject("_ret_"), agent);
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public GetCurrentSessionResult getCurrentSession() throws Exception {
    JSONObject params = null;
    final JSONObject result = rpcCall("getCurrentSession", params);
    GetCurrentSessionResult ret = new GetCurrentSessionResult();
    ret._ret_ = com.raritan.json_rpc.session.Session_Codec.decode(result.getJSONObject("_ret_"), agent);
    return ret;
  }

  @Override
  public AsyncRequest getCurrentSession(final AsyncRpcResponse<GetCurrentSessionResult> rsp) {
    return getCurrentSession(rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest getCurrentSession(final AsyncRpcResponse<GetCurrentSessionResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = null;
    return rpcCall("getCurrentSession", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          GetCurrentSessionResult ret = new GetCurrentSessionResult();
          ret._ret_ = com.raritan.json_rpc.session.Session_Codec.decode(result.getJSONObject("_ret_"), agent);
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public GetSessionsResult getSessions() throws Exception {
    JSONObject params = null;
    final JSONObject result = rpcCall("getSessions", params);
    GetSessionsResult ret = new GetSessionsResult();
    ret._ret_ = new java.util.ArrayList<com.raritan.idl.session.Session>() {
      private static final long serialVersionUID = 1L;
      {
        final JSONArray array0 = result.getJSONArray("_ret_");
        for (int i0 = 0; i0 < array0.length(); i0++) {
          final int i0_f = i0;
          this.add(com.raritan.json_rpc.session.Session_Codec.decode(array0.getJSONObject(i0_f), agent));
        }
      }
    };
    return ret;
  }

  @Override
  public AsyncRequest getSessions(final AsyncRpcResponse<GetSessionsResult> rsp) {
    return getSessions(rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest getSessions(final AsyncRpcResponse<GetSessionsResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = null;
    return rpcCall("getSessions", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          GetSessionsResult ret = new GetSessionsResult();
          ret._ret_ = new java.util.ArrayList<com.raritan.idl.session.Session>() {
            private static final long serialVersionUID = 1L;
            {
              final JSONArray array0 = result.getJSONArray("_ret_");
              for (int i0 = 0; i0 < array0.length(); i0++) {
                final int i0_f = i0;
                this.add(com.raritan.json_rpc.session.Session_Codec.decode(array0.getJSONObject(i0_f), agent));
              }
            }
          };
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public Void closeSession(final String token, final com.raritan.idl.session.SessionManager.CloseReason reason) throws Exception {
    JSONObject params = new JSONObject();
    params.put("token", token);
    params.put("reason", com.raritan.json_rpc.session.SessionManager.CloseReason_Codec.encode(reason));
    rpcCall("closeSession", params);
    Void ret = null;
    return ret;
  }

  @Override
  public AsyncRequest closeSession(final String token, final com.raritan.idl.session.SessionManager.CloseReason reason, final AsyncRpcResponse<Void> rsp) {
    return closeSession(token, reason, rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest closeSession(final String token, final com.raritan.idl.session.SessionManager.CloseReason reason, final AsyncRpcResponse<Void> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = new JSONObject();
    try {
      params.put("token", token);
      params.put("reason", com.raritan.json_rpc.session.SessionManager.CloseReason_Codec.encode(reason));
    } catch (Exception e) {
      rsp.onFailure(e);
    }
    return rpcCall("closeSession", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          Void ret = null;
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public Void closeCurrentSession(final com.raritan.idl.session.SessionManager.CloseReason reason) throws Exception {
    JSONObject params = new JSONObject();
    params.put("reason", com.raritan.json_rpc.session.SessionManager.CloseReason_Codec.encode(reason));
    rpcCall("closeCurrentSession", params);
    Void ret = null;
    return ret;
  }

  @Override
  public AsyncRequest closeCurrentSession(final com.raritan.idl.session.SessionManager.CloseReason reason, final AsyncRpcResponse<Void> rsp) {
    return closeCurrentSession(reason, rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest closeCurrentSession(final com.raritan.idl.session.SessionManager.CloseReason reason, final AsyncRpcResponse<Void> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = new JSONObject();
    try {
      params.put("reason", com.raritan.json_rpc.session.SessionManager.CloseReason_Codec.encode(reason));
    } catch (Exception e) {
      rsp.onFailure(e);
    }
    return rpcCall("closeCurrentSession", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          Void ret = null;
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public Void touchSession(final String token) throws Exception {
    JSONObject params = new JSONObject();
    params.put("token", token);
    rpcCall("touchSession", params);
    Void ret = null;
    return ret;
  }

  @Override
  public AsyncRequest touchSession(final String token, final AsyncRpcResponse<Void> rsp) {
    return touchSession(token, rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest touchSession(final String token, final AsyncRpcResponse<Void> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = new JSONObject();
    try {
      params.put("token", token);
    } catch (Exception e) {
      rsp.onFailure(e);
    }
    return rpcCall("touchSession", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          Void ret = null;
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public Void touchCurrentSession(final boolean userActivity) throws Exception {
    JSONObject params = new JSONObject();
    params.put("userActivity", userActivity);
    rpcCall("touchCurrentSession", params);
    Void ret = null;
    return ret;
  }

  @Override
  public AsyncRequest touchCurrentSession(final boolean userActivity, final AsyncRpcResponse<Void> rsp) {
    return touchCurrentSession(userActivity, rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest touchCurrentSession(final boolean userActivity, final AsyncRpcResponse<Void> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = new JSONObject();
    try {
      params.put("userActivity", userActivity);
    } catch (Exception e) {
      rsp.onFailure(e);
    }
    return rpcCall("touchCurrentSession", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          Void ret = null;
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public GetSessionHistoryResult getSessionHistory() throws Exception {
    JSONObject params = null;
    final JSONObject result = rpcCall("getSessionHistory", params);
    GetSessionHistoryResult ret = new GetSessionHistoryResult();
    ret._ret_ = new java.util.ArrayList<com.raritan.idl.session.HistoryEntry>() {
      private static final long serialVersionUID = 1L;
      {
        final JSONArray array0 = result.getJSONArray("_ret_");
        for (int i0 = 0; i0 < array0.length(); i0++) {
          final int i0_f = i0;
          this.add(com.raritan.json_rpc.session.HistoryEntry_Codec.decode(array0.getJSONObject(i0_f), agent));
        }
      }
    };
    return ret;
  }

  @Override
  public AsyncRequest getSessionHistory(final AsyncRpcResponse<GetSessionHistoryResult> rsp) {
    return getSessionHistory(rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest getSessionHistory(final AsyncRpcResponse<GetSessionHistoryResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = null;
    return rpcCall("getSessionHistory", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          GetSessionHistoryResult ret = new GetSessionHistoryResult();
          ret._ret_ = new java.util.ArrayList<com.raritan.idl.session.HistoryEntry>() {
            private static final long serialVersionUID = 1L;
            {
              final JSONArray array0 = result.getJSONArray("_ret_");
              for (int i0 = 0; i0 < array0.length(); i0++) {
                final int i0_f = i0;
                this.add(com.raritan.json_rpc.session.HistoryEntry_Codec.decode(array0.getJSONObject(i0_f), agent));
              }
            }
          };
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }
}
