// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2025 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from NumericSensor.idl.

package com.raritan.idl.sensors;

import com.raritan.idl.*;
import com.raritan.util.AsyncRequest;

public interface NumericSensor_4_0_8 extends com.raritan.idl.sensors.Sensor_4_0_7 {
  static public final TypeInfo typeInfo = new TypeInfo("sensors.NumericSensor:4.0.8", com.raritan.idl.sensors.Sensor_4_0_7.typeInfo);

  public static final int THRESHOLD_OUT_OF_RANGE = 1;

  public static final int THRESHOLD_INVALID = 2;

  public static final int THRESHOLD_NOT_SUPPORTED = 3;

  static public class Range implements Cloneable {
    public double lower = 0.0;
    public double upper = 0.0;

    public Object clone() {
      Range copy = new Range();

      copy.lower = this.lower;
      copy.upper = this.upper;

      return copy;
    }

  }

  static public class ThresholdCapabilities implements Cloneable {
    public boolean hasUpperCritical = false;
    public boolean hasUpperWarning = false;
    public boolean hasLowerWarning = false;
    public boolean hasLowerCritical = false;

    public Object clone() {
      ThresholdCapabilities copy = new ThresholdCapabilities();

      copy.hasUpperCritical = this.hasUpperCritical;
      copy.hasUpperWarning = this.hasUpperWarning;
      copy.hasLowerWarning = this.hasLowerWarning;
      copy.hasLowerCritical = this.hasLowerCritical;

      return copy;
    }

  }

  static public class MetaData implements Cloneable {
    public com.raritan.idl.sensors.Sensor_4_0_7.TypeSpec type = new com.raritan.idl.sensors.Sensor_4_0_7.TypeSpec();
    public int decdigits = 0;
    public float accuracy = 0.0f;
    public float resolution = 0.0f;
    public float tolerance = 0.0f;
    public float noiseThreshold = 0.0f;
    public com.raritan.idl.sensors.NumericSensor_4_0_8.Range range = new com.raritan.idl.sensors.NumericSensor_4_0_8.Range();
    public com.raritan.idl.sensors.NumericSensor_4_0_8.ThresholdCapabilities thresholdCaps = new com.raritan.idl.sensors.NumericSensor_4_0_8.ThresholdCapabilities();

    public Object clone() {
      MetaData copy = new MetaData();

      Object typeCopy = this.type.clone();
      copy.type = (com.raritan.idl.sensors.Sensor_4_0_7.TypeSpec) typeCopy;
      copy.decdigits = this.decdigits;
      copy.accuracy = this.accuracy;
      copy.resolution = this.resolution;
      copy.tolerance = this.tolerance;
      copy.noiseThreshold = this.noiseThreshold;
      Object rangeCopy = this.range.clone();
      copy.range = (com.raritan.idl.sensors.NumericSensor_4_0_8.Range) rangeCopy;
      Object thresholdCapsCopy = this.thresholdCaps.clone();
      copy.thresholdCaps = (com.raritan.idl.sensors.NumericSensor_4_0_8.ThresholdCapabilities) thresholdCapsCopy;

      return copy;
    }

  }

  static public class Thresholds implements Cloneable {
    public boolean upperCriticalActive = false;
    public double upperCritical = 0.0;
    public boolean upperWarningActive = false;
    public double upperWarning = 0.0;
    public boolean lowerWarningActive = false;
    public double lowerWarning = 0.0;
    public boolean lowerCriticalActive = false;
    public double lowerCritical = 0.0;
    public int assertionTimeout = 0;
    public float deassertionHysteresis = 0.0f;

    public Object clone() {
      Thresholds copy = new Thresholds();

      copy.upperCriticalActive = this.upperCriticalActive;
      copy.upperCritical = this.upperCritical;
      copy.upperWarningActive = this.upperWarningActive;
      copy.upperWarning = this.upperWarning;
      copy.lowerWarningActive = this.lowerWarningActive;
      copy.lowerWarning = this.lowerWarning;
      copy.lowerCriticalActive = this.lowerCriticalActive;
      copy.lowerCritical = this.lowerCritical;
      copy.assertionTimeout = this.assertionTimeout;
      copy.deassertionHysteresis = this.deassertionHysteresis;

      return copy;
    }

  }

  static public class Reading implements Cloneable {

    static public class Status implements Cloneable {
      public boolean aboveUpperCritical = false;
      public boolean aboveUpperWarning = false;
      public boolean belowLowerWarning = false;
      public boolean belowLowerCritical = false;

      public Object clone() {
        Status copy = new Status();

        copy.aboveUpperCritical = this.aboveUpperCritical;
        copy.aboveUpperWarning = this.aboveUpperWarning;
        copy.belowLowerWarning = this.belowLowerWarning;
        copy.belowLowerCritical = this.belowLowerCritical;

        return copy;
      }

    }
    public java.util.Date timestamp = new java.util.Date();
    public boolean available = false;
    public com.raritan.idl.sensors.NumericSensor_4_0_8.Reading.Status status = new com.raritan.idl.sensors.NumericSensor_4_0_8.Reading.Status();
    public boolean valid = false;
    public double value = 0.0;

    public Object clone() {
      Reading copy = new Reading();

      copy.timestamp = this.timestamp;
      copy.available = this.available;
      Object statusCopy = this.status.clone();
      copy.status = (com.raritan.idl.sensors.NumericSensor_4_0_8.Reading.Status) statusCopy;
      copy.valid = this.valid;
      copy.value = this.value;

      return copy;
    }

  }

  static public class MinMax implements Cloneable {
    public double minReading = 0.0;
    public java.util.Date minReadingTimestamp = new java.util.Date();
    public double maxReading = 0.0;
    public java.util.Date maxReadingTimestamp = new java.util.Date();
    public boolean valid = false;
    public java.util.Date observedSince = new java.util.Date();

    public Object clone() {
      MinMax copy = new MinMax();

      copy.minReading = this.minReading;
      copy.minReadingTimestamp = this.minReadingTimestamp;
      copy.maxReading = this.maxReading;
      copy.maxReadingTimestamp = this.maxReadingTimestamp;
      copy.valid = this.valid;
      copy.observedSince = this.observedSince;

      return copy;
    }

  }

  public class ReadingChangedEvent extends com.raritan.idl.idl.Event {

    static public final TypeInfo typeInfo = new TypeInfo("sensors.NumericSensor_4_0_8.ReadingChangedEvent:1.0.0", com.raritan.idl.idl.Event.typeInfo);

    @Override
    protected TypeInfo getClassTypeInfo() {
      return typeInfo;
    }

    public com.raritan.idl.sensors.NumericSensor_4_0_8.Reading newReading = new com.raritan.idl.sensors.NumericSensor_4_0_8.Reading();
  }

  public class StateChangedEvent extends com.raritan.idl.idl.Event {

    static public final TypeInfo typeInfo = new TypeInfo("sensors.NumericSensor_4_0_8.StateChangedEvent:1.0.0", com.raritan.idl.idl.Event.typeInfo);

    @Override
    protected TypeInfo getClassTypeInfo() {
      return typeInfo;
    }

    public com.raritan.idl.sensors.NumericSensor_4_0_8.Reading oldReading = new com.raritan.idl.sensors.NumericSensor_4_0_8.Reading();
    public com.raritan.idl.sensors.NumericSensor_4_0_8.Reading newReading = new com.raritan.idl.sensors.NumericSensor_4_0_8.Reading();
  }

  public class MetaDataChangedEvent extends com.raritan.idl.idl.Event {

    static public final TypeInfo typeInfo = new TypeInfo("sensors.NumericSensor_4_0_8.MetaDataChangedEvent:1.0.0", com.raritan.idl.idl.Event.typeInfo);

    @Override
    protected TypeInfo getClassTypeInfo() {
      return typeInfo;
    }

    public com.raritan.idl.sensors.NumericSensor_4_0_8.MetaData oldMetaData = new com.raritan.idl.sensors.NumericSensor_4_0_8.MetaData();
    public com.raritan.idl.sensors.NumericSensor_4_0_8.MetaData newMetaData = new com.raritan.idl.sensors.NumericSensor_4_0_8.MetaData();
  }

  public class DefaultThresholdsChangedEvent extends com.raritan.idl.event.UserEvent {

    static public final TypeInfo typeInfo = new TypeInfo("sensors.NumericSensor_4_0_8.DefaultThresholdsChangedEvent:1.0.0", com.raritan.idl.event.UserEvent.typeInfo);

    @Override
    protected TypeInfo getClassTypeInfo() {
      return typeInfo;
    }

    public com.raritan.idl.sensors.NumericSensor_4_0_8.Thresholds oldDefaultThresholds = new com.raritan.idl.sensors.NumericSensor_4_0_8.Thresholds();
    public com.raritan.idl.sensors.NumericSensor_4_0_8.Thresholds newDefaultThresholds = new com.raritan.idl.sensors.NumericSensor_4_0_8.Thresholds();
  }

  public class ThresholdsChangedEvent extends com.raritan.idl.event.UserEvent {

    static public final TypeInfo typeInfo = new TypeInfo("sensors.NumericSensor_4_0_8.ThresholdsChangedEvent:1.0.0", com.raritan.idl.event.UserEvent.typeInfo);

    @Override
    protected TypeInfo getClassTypeInfo() {
      return typeInfo;
    }

    public com.raritan.idl.sensors.NumericSensor_4_0_8.Thresholds oldThresholds = new com.raritan.idl.sensors.NumericSensor_4_0_8.Thresholds();
    public com.raritan.idl.sensors.NumericSensor_4_0_8.Thresholds newThresholds = new com.raritan.idl.sensors.NumericSensor_4_0_8.Thresholds();
  }

  public class MinMaxChangedEvent extends com.raritan.idl.idl.Event {

    static public final TypeInfo typeInfo = new TypeInfo("sensors.NumericSensor_4_0_8.MinMaxChangedEvent:1.0.0", com.raritan.idl.idl.Event.typeInfo);

    @Override
    protected TypeInfo getClassTypeInfo() {
      return typeInfo;
    }

    public com.raritan.idl.sensors.NumericSensor_4_0_8.MinMax newMinMax = new com.raritan.idl.sensors.NumericSensor_4_0_8.MinMax();
  }

  public class MinMaxResetEvent extends com.raritan.idl.event.UserEvent {

    static public final TypeInfo typeInfo = new TypeInfo("sensors.NumericSensor_4_0_8.MinMaxResetEvent:1.0.0", com.raritan.idl.event.UserEvent.typeInfo);

    @Override
    protected TypeInfo getClassTypeInfo() {
      return typeInfo;
    }

    public com.raritan.idl.sensors.NumericSensor_4_0_8.MinMax oldMinMax = new com.raritan.idl.sensors.NumericSensor_4_0_8.MinMax();
    public com.raritan.idl.sensors.NumericSensor_4_0_8.MinMax newMinMax = new com.raritan.idl.sensors.NumericSensor_4_0_8.MinMax();
  }

  public class GetMetaDataResult {
    public com.raritan.idl.sensors.NumericSensor_4_0_8.MetaData _ret_;
  }

  GetMetaDataResult getMetaData() throws Exception;

  AsyncRequest getMetaData(AsyncRpcResponse<GetMetaDataResult> rsp);

  AsyncRequest getMetaData(AsyncRpcResponse<GetMetaDataResult> rsp, RpcCtrl rpcCtrl);


  public class GetDefaultThresholdsResult {
    public com.raritan.idl.sensors.NumericSensor_4_0_8.Thresholds _ret_;
  }

  GetDefaultThresholdsResult getDefaultThresholds() throws Exception;

  AsyncRequest getDefaultThresholds(AsyncRpcResponse<GetDefaultThresholdsResult> rsp);

  AsyncRequest getDefaultThresholds(AsyncRpcResponse<GetDefaultThresholdsResult> rsp, RpcCtrl rpcCtrl);


  public class GetThresholdsResult {
    public com.raritan.idl.sensors.NumericSensor_4_0_8.Thresholds _ret_;
  }

  GetThresholdsResult getThresholds() throws Exception;

  AsyncRequest getThresholds(AsyncRpcResponse<GetThresholdsResult> rsp);

  AsyncRequest getThresholds(AsyncRpcResponse<GetThresholdsResult> rsp, RpcCtrl rpcCtrl);


  public class SetThresholdsResult {
    public int _ret_;
  }

  SetThresholdsResult setThresholds(com.raritan.idl.sensors.NumericSensor_4_0_8.Thresholds thresh) throws Exception;

  AsyncRequest setThresholds(com.raritan.idl.sensors.NumericSensor_4_0_8.Thresholds thresh, AsyncRpcResponse<SetThresholdsResult> rsp);

  AsyncRequest setThresholds(com.raritan.idl.sensors.NumericSensor_4_0_8.Thresholds thresh, AsyncRpcResponse<SetThresholdsResult> rsp, RpcCtrl rpcCtrl);


  public class GetReadingResult {
    public com.raritan.idl.sensors.NumericSensor_4_0_8.Reading _ret_;
  }

  GetReadingResult getReading() throws Exception;

  AsyncRequest getReading(AsyncRpcResponse<GetReadingResult> rsp);

  AsyncRequest getReading(AsyncRpcResponse<GetReadingResult> rsp, RpcCtrl rpcCtrl);


  public class GetMinMaxResult {
    public com.raritan.idl.sensors.NumericSensor_4_0_8.MinMax _ret_;
  }

  GetMinMaxResult getMinMax() throws Exception;

  AsyncRequest getMinMax(AsyncRpcResponse<GetMinMaxResult> rsp);

  AsyncRequest getMinMax(AsyncRpcResponse<GetMinMaxResult> rsp, RpcCtrl rpcCtrl);

  Void resetMinMax() throws Exception;

  AsyncRequest resetMinMax(AsyncRpcResponse<Void> rsp);

  AsyncRequest resetMinMax(AsyncRpcResponse<Void> rsp, RpcCtrl rpcCtrl);

}
