// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2025 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from GatewaySensorManager.idl.

package com.raritan.idl.peripheral;

import com.raritan.idl.*;
import com.raritan.util.AsyncRequest;

public interface GatewaySensorManager {
  static public final TypeInfo typeInfo = new TypeInfo("peripheral.GatewaySensorManager:1.0.0", null);

  public class SensorClass extends com.raritan.json_rpc.ValueObject {

    static public final TypeInfo typeInfo = new TypeInfo("peripheral.GatewaySensorManager.SensorClass:1.0.0", com.raritan.json_rpc.ValueObject.typeInfo);

    @Override
    protected TypeInfo getClassTypeInfo() {
      return typeInfo;
    }

    public String classId = new String();
  }

  public class NumericSensorClass extends com.raritan.idl.peripheral.GatewaySensorManager.SensorClass {

    static public final TypeInfo typeInfo = new TypeInfo("peripheral.GatewaySensorManager.NumericSensorClass:1.0.0", com.raritan.idl.peripheral.GatewaySensorManager.SensorClass.typeInfo);

    @Override
    protected TypeInfo getClassTypeInfo() {
      return typeInfo;
    }

    public com.raritan.idl.sensors.NumericSensor_4_0_6.MetaData metadata = new com.raritan.idl.sensors.NumericSensor_4_0_6.MetaData();
    public com.raritan.idl.sensors.NumericSensor_4_0_6.Thresholds defaultThresholds = new com.raritan.idl.sensors.NumericSensor_4_0_6.Thresholds();
    public boolean preferCommonThresholds = false;
  }

  public class StateSensorClass extends com.raritan.idl.peripheral.GatewaySensorManager.SensorClass {

    static public final TypeInfo typeInfo = new TypeInfo("peripheral.GatewaySensorManager.StateSensorClass:1.0.0", com.raritan.idl.peripheral.GatewaySensorManager.SensorClass.typeInfo);

    @Override
    protected TypeInfo getClassTypeInfo() {
      return typeInfo;
    }

    public com.raritan.idl.sensors.Sensor_4_0_5.TypeSpec type = new com.raritan.idl.sensors.Sensor_4_0_5.TypeSpec();
  }

  public class SwitchSensorClass extends com.raritan.idl.peripheral.GatewaySensorManager.StateSensorClass {

    static public final TypeInfo typeInfo = new TypeInfo("peripheral.GatewaySensorManager.SwitchSensorClass:1.0.0", com.raritan.idl.peripheral.GatewaySensorManager.StateSensorClass.typeInfo);

    @Override
    protected TypeInfo getClassTypeInfo() {
      return typeInfo;
    }

  }

  public class RemoteDevice extends com.raritan.json_rpc.ValueObject {

    static public final TypeInfo typeInfo = new TypeInfo("peripheral.GatewaySensorManager.RemoteDevice:1.0.0", com.raritan.json_rpc.ValueObject.typeInfo);

    @Override
    protected TypeInfo getClassTypeInfo() {
      return typeInfo;
    }

    public String deviceId = new String();
    public boolean disabled = false;
    public String name = new String();
    public int timeoutMs = 0;
    public int retry = 0;
  }

  public static final int MODBUS_VENDOR_NAME = 0;

  public static final int MODBUS_PRODUCT_CODE = 1;

  public static final int MODBUS_REVISION = 2;

  public static final int MODBUS_VENDOR_URL = 3;

  public static final int MODBUS_PRODUCT_NAME = 5;

  public static final int MODBUS_MODEL_NAME = 6;

  public static final int MODBUS_APP_NAME = 7;

  public class RemoteModbusDevice extends com.raritan.idl.peripheral.GatewaySensorManager.RemoteDevice {

    static public final TypeInfo typeInfo = new TypeInfo("peripheral.GatewaySensorManager.RemoteModbusDevice:1.0.0", com.raritan.idl.peripheral.GatewaySensorManager.RemoteDevice.typeInfo);

    @Override
    protected TypeInfo getClassTypeInfo() {
      return typeInfo;
    }

    public java.util.Map<Integer, String> detectionIdentifiers = new java.util.HashMap<>();
    public int unitId = 0;
  }

  public class RemoteModbusRTUDevice extends com.raritan.idl.peripheral.GatewaySensorManager.RemoteModbusDevice {

    static public final TypeInfo typeInfo = new TypeInfo("peripheral.GatewaySensorManager.RemoteModbusRTUDevice:1.0.0", com.raritan.idl.peripheral.GatewaySensorManager.RemoteModbusDevice.typeInfo);

    @Override
    protected TypeInfo getClassTypeInfo() {
      return typeInfo;
    }

    public String busInterface = new String();
    public com.raritan.idl.peripheral.ModbusCfg.SerialSettings busSettings = new com.raritan.idl.peripheral.ModbusCfg.SerialSettings();
    public int interframeDelayDeciChars = 0;
  }

  public class RemoteModbusTCPDevice extends com.raritan.idl.peripheral.GatewaySensorManager.RemoteModbusDevice {

    static public final TypeInfo typeInfo = new TypeInfo("peripheral.GatewaySensorManager.RemoteModbusTCPDevice:1.0.0", com.raritan.idl.peripheral.GatewaySensorManager.RemoteModbusDevice.typeInfo);

    @Override
    protected TypeInfo getClassTypeInfo() {
      return typeInfo;
    }

    public String ipAddress = new String();
    public int tcpPort = 0;
  }

  public enum EncodingType {
    BOOL,
    INT,
    UINT,
    IEEE754;
  }

  public enum Interpretation {
    DEFAULT,
    REJECT_DEVICE,
    REJECT_SENSOR,
    IGNORE,
    UNAVAILABLE,
    NUMERIC_INVALID,
    STATE_ON,
    STATE_OFF;
  }

  public class InterpretationRule extends com.raritan.json_rpc.ValueObject {

    static public final TypeInfo typeInfo = new TypeInfo("peripheral.GatewaySensorManager.InterpretationRule:1.0.0", com.raritan.json_rpc.ValueObject.typeInfo);

    @Override
    protected TypeInfo getClassTypeInfo() {
      return typeInfo;
    }

    public com.raritan.idl.peripheral.GatewaySensorManager.Interpretation interpretation = com.raritan.idl.peripheral.GatewaySensorManager.Interpretation.values()[0];
    public int ignoreTimeout = 0;
  }

  public class InterpretationRuleInvertable extends com.raritan.idl.peripheral.GatewaySensorManager.InterpretationRule {

    static public final TypeInfo typeInfo = new TypeInfo("peripheral.GatewaySensorManager.InterpretationRuleInvertable:1.0.0", com.raritan.idl.peripheral.GatewaySensorManager.InterpretationRule.typeInfo);

    @Override
    protected TypeInfo getClassTypeInfo() {
      return typeInfo;
    }

    public boolean invertCondition = false;
  }

  public class InterpretationRuleModbusException extends com.raritan.idl.peripheral.GatewaySensorManager.InterpretationRuleInvertable {

    static public final TypeInfo typeInfo = new TypeInfo("peripheral.GatewaySensorManager.InterpretationRuleModbusException:1.0.0", com.raritan.idl.peripheral.GatewaySensorManager.InterpretationRuleInvertable.typeInfo);

    @Override
    protected TypeInfo getClassTypeInfo() {
      return typeInfo;
    }

    public java.util.List<Integer> exceptions = new java.util.ArrayList<>();
  }

  public class InterpretationRuleModbusSystemError extends com.raritan.idl.peripheral.GatewaySensorManager.InterpretationRuleInvertable {

    static public final TypeInfo typeInfo = new TypeInfo("peripheral.GatewaySensorManager.InterpretationRuleModbusSystemError:1.0.0", com.raritan.idl.peripheral.GatewaySensorManager.InterpretationRuleInvertable.typeInfo);

    @Override
    protected TypeInfo getClassTypeInfo() {
      return typeInfo;
    }

    public java.util.List<Integer> errnos = new java.util.ArrayList<>();
  }

  public class InterpretationRuleModbusSpecificError extends com.raritan.idl.peripheral.GatewaySensorManager.InterpretationRuleInvertable {

    static public final TypeInfo typeInfo = new TypeInfo("peripheral.GatewaySensorManager.InterpretationRuleModbusSpecificError:1.0.0", com.raritan.idl.peripheral.GatewaySensorManager.InterpretationRuleInvertable.typeInfo);

    @Override
    protected TypeInfo getClassTypeInfo() {
      return typeInfo;
    }

    public java.util.List<com.raritan.idl.peripheral.ModbusCfg.SpecificModbusErrors> errors = new java.util.ArrayList<>();
  }

  public class InterpretationRuleRAW extends com.raritan.idl.peripheral.GatewaySensorManager.InterpretationRuleInvertable {

    static public final TypeInfo typeInfo = new TypeInfo("peripheral.GatewaySensorManager.InterpretationRuleRAW:1.0.0", com.raritan.idl.peripheral.GatewaySensorManager.InterpretationRuleInvertable.typeInfo);

    @Override
    protected TypeInfo getClassTypeInfo() {
      return typeInfo;
    }

    public long value = 0;
    public long mask = 0;
  }

  public class InterpretationRuleRangeRAW extends com.raritan.idl.peripheral.GatewaySensorManager.InterpretationRuleInvertable {

    static public final TypeInfo typeInfo = new TypeInfo("peripheral.GatewaySensorManager.InterpretationRuleRangeRAW:1.0.0", com.raritan.idl.peripheral.GatewaySensorManager.InterpretationRuleInvertable.typeInfo);

    @Override
    protected TypeInfo getClassTypeInfo() {
      return typeInfo;
    }

    public long min = 0;
    public long max = 0;
    public long mask = 0;
  }

  public class InterpretationRuleIEEE754INF extends com.raritan.idl.peripheral.GatewaySensorManager.InterpretationRuleInvertable {

    static public final TypeInfo typeInfo = new TypeInfo("peripheral.GatewaySensorManager.InterpretationRuleIEEE754INF:1.0.0", com.raritan.idl.peripheral.GatewaySensorManager.InterpretationRuleInvertable.typeInfo);

    @Override
    protected TypeInfo getClassTypeInfo() {
      return typeInfo;
    }

  }

  public class InterpretationRuleIEEE754NAN extends com.raritan.idl.peripheral.GatewaySensorManager.InterpretationRuleInvertable {

    static public final TypeInfo typeInfo = new TypeInfo("peripheral.GatewaySensorManager.InterpretationRuleIEEE754NAN:1.0.0", com.raritan.idl.peripheral.GatewaySensorManager.InterpretationRuleInvertable.typeInfo);

    @Override
    protected TypeInfo getClassTypeInfo() {
      return typeInfo;
    }

  }

  public class InterpretationRuleCatchAll extends com.raritan.idl.peripheral.GatewaySensorManager.InterpretationRule {

    static public final TypeInfo typeInfo = new TypeInfo("peripheral.GatewaySensorManager.InterpretationRuleCatchAll:1.0.0", com.raritan.idl.peripheral.GatewaySensorManager.InterpretationRule.typeInfo);

    @Override
    protected TypeInfo getClassTypeInfo() {
      return typeInfo;
    }

  }

  public class ValueEncoding extends com.raritan.json_rpc.ValueObject {

    static public final TypeInfo typeInfo = new TypeInfo("peripheral.GatewaySensorManager.ValueEncoding:1.0.0", com.raritan.json_rpc.ValueObject.typeInfo);

    @Override
    protected TypeInfo getClassTypeInfo() {
      return typeInfo;
    }

    public String encodingId = new String();
    public com.raritan.idl.peripheral.GatewaySensorManager.EncodingType type = com.raritan.idl.peripheral.GatewaySensorManager.EncodingType.values()[0];
    public boolean invertState = false;
    public java.util.List<com.raritan.idl.peripheral.GatewaySensorManager.InterpretationRule> interpretationRules = new java.util.ArrayList<>();
  }

  public class NumericValueEncoding extends com.raritan.idl.peripheral.GatewaySensorManager.ValueEncoding {

    static public final TypeInfo typeInfo = new TypeInfo("peripheral.GatewaySensorManager.NumericValueEncoding:1.0.0", com.raritan.idl.peripheral.GatewaySensorManager.ValueEncoding.typeInfo);

    @Override
    protected TypeInfo getClassTypeInfo() {
      return typeInfo;
    }

    public float scalingFactor = 0.0f;
    public float offset = 0.0f;
  }

  public class ModbusValueEncodingBit extends com.raritan.idl.peripheral.GatewaySensorManager.ValueEncoding {

    static public final TypeInfo typeInfo = new TypeInfo("peripheral.GatewaySensorManager.ModbusValueEncodingBit:1.0.0", com.raritan.idl.peripheral.GatewaySensorManager.ValueEncoding.typeInfo);

    @Override
    protected TypeInfo getClassTypeInfo() {
      return typeInfo;
    }

  }

  public class ModbusValueEncoding8 extends com.raritan.idl.peripheral.GatewaySensorManager.NumericValueEncoding {

    static public final TypeInfo typeInfo = new TypeInfo("peripheral.GatewaySensorManager.ModbusValueEncoding8:1.0.0", com.raritan.idl.peripheral.GatewaySensorManager.NumericValueEncoding.typeInfo);

    @Override
    protected TypeInfo getClassTypeInfo() {
      return typeInfo;
    }

    public boolean byteSwap = false;
    public long mask = 0;
  }

  public class ModbusValueEncoding16 extends com.raritan.idl.peripheral.GatewaySensorManager.ModbusValueEncoding8 {

    static public final TypeInfo typeInfo = new TypeInfo("peripheral.GatewaySensorManager.ModbusValueEncoding16:1.0.0", com.raritan.idl.peripheral.GatewaySensorManager.ModbusValueEncoding8.typeInfo);

    @Override
    protected TypeInfo getClassTypeInfo() {
      return typeInfo;
    }

  }

  public enum ModbusEndianness {
    MODBUS_BIG_ENDIAN,
    MODBUS_LITTLE_ENDIAN;
  }

  public class ModbusValueEncoding32 extends com.raritan.idl.peripheral.GatewaySensorManager.ModbusValueEncoding16 {

    static public final TypeInfo typeInfo = new TypeInfo("peripheral.GatewaySensorManager.ModbusValueEncoding32:1.0.0", com.raritan.idl.peripheral.GatewaySensorManager.ModbusValueEncoding16.typeInfo);

    @Override
    protected TypeInfo getClassTypeInfo() {
      return typeInfo;
    }

    public com.raritan.idl.peripheral.GatewaySensorManager.ModbusEndianness endianness = com.raritan.idl.peripheral.GatewaySensorManager.ModbusEndianness.values()[0];
  }

  public class ModbusValueEncoding64 extends com.raritan.idl.peripheral.GatewaySensorManager.ModbusValueEncoding32 {

    static public final TypeInfo typeInfo = new TypeInfo("peripheral.GatewaySensorManager.ModbusValueEncoding64:1.0.0", com.raritan.idl.peripheral.GatewaySensorManager.ModbusValueEncoding32.typeInfo);

    @Override
    protected TypeInfo getClassTypeInfo() {
      return typeInfo;
    }

  }

  public class Sensor extends com.raritan.json_rpc.ValueObject {

    static public final TypeInfo typeInfo = new TypeInfo("peripheral.GatewaySensorManager.Sensor:1.0.0", com.raritan.json_rpc.ValueObject.typeInfo);

    @Override
    protected TypeInfo getClassTypeInfo() {
      return typeInfo;
    }

    public String sensorId = new String();
    public boolean disabled = false;
    public String deviceId = new String();
    public String classId = new String();
    public String encodingId = new String();
    public String defaultName = new String();
  }

  public class ModbusSensor extends com.raritan.idl.peripheral.GatewaySensorManager.Sensor {

    static public final TypeInfo typeInfo = new TypeInfo("peripheral.GatewaySensorManager.ModbusSensor:1.0.0", com.raritan.idl.peripheral.GatewaySensorManager.Sensor.typeInfo);

    @Override
    protected TypeInfo getClassTypeInfo() {
      return typeInfo;
    }

    public com.raritan.idl.peripheral.ModbusCfg.ModbusFunction function = com.raritan.idl.peripheral.ModbusCfg.ModbusFunction.values()[0];
    public int regAddr = 0;
  }

  static public class ConfigurationPackage implements Cloneable {
    public boolean disabled = false;
    public String name = new String();
    public java.util.List<com.raritan.idl.peripheral.GatewaySensorManager.SensorClass> classes = new java.util.ArrayList<>();
    public java.util.List<com.raritan.idl.peripheral.GatewaySensorManager.RemoteDevice> devices = new java.util.ArrayList<>();
    public java.util.List<com.raritan.idl.peripheral.GatewaySensorManager.ValueEncoding> encodings = new java.util.ArrayList<>();
    public java.util.List<com.raritan.idl.peripheral.GatewaySensorManager.Sensor> sensors = new java.util.ArrayList<>();

    public Object clone() {
      ConfigurationPackage copy = new ConfigurationPackage();

      copy.disabled = this.disabled;
      copy.name = this.name;
      copy.classes = new java.util.ArrayList<com.raritan.idl.peripheral.GatewaySensorManager.SensorClass>(this.classes);
      copy.devices = new java.util.ArrayList<com.raritan.idl.peripheral.GatewaySensorManager.RemoteDevice>(this.devices);
      copy.encodings = new java.util.ArrayList<com.raritan.idl.peripheral.GatewaySensorManager.ValueEncoding>(this.encodings);
      copy.sensors = new java.util.ArrayList<com.raritan.idl.peripheral.GatewaySensorManager.Sensor>(this.sensors);

      return copy;
    }

  }

  public class GetConfigurationResult {
    public java.util.Map<String, com.raritan.idl.peripheral.GatewaySensorManager.ConfigurationPackage> _ret_;
  }

  GetConfigurationResult getConfiguration() throws Exception;

  AsyncRequest getConfiguration(AsyncRpcResponse<GetConfigurationResult> rsp);

  AsyncRequest getConfiguration(AsyncRpcResponse<GetConfigurationResult> rsp, RpcCtrl rpcCtrl);


  public static final int ERR_CONFIG_INCONSISTENT = 1;

  public static final int ERR_CONFIG_STORAGE_FAILED = 2;

  public class SetConfigurationResult {
    public int _ret_;
  }

  SetConfigurationResult setConfiguration(java.util.Map<String, com.raritan.idl.peripheral.GatewaySensorManager.ConfigurationPackage> cfg) throws Exception;

  AsyncRequest setConfiguration(java.util.Map<String, com.raritan.idl.peripheral.GatewaySensorManager.ConfigurationPackage> cfg, AsyncRpcResponse<SetConfigurationResult> rsp);

  AsyncRequest setConfiguration(java.util.Map<String, com.raritan.idl.peripheral.GatewaySensorManager.ConfigurationPackage> cfg, AsyncRpcResponse<SetConfigurationResult> rsp, RpcCtrl rpcCtrl);


  public class ConfigurationChangedEvent extends com.raritan.idl.idl.Event {

    static public final TypeInfo typeInfo = new TypeInfo("peripheral.GatewaySensorManager.ConfigurationChangedEvent:1.0.0", com.raritan.idl.idl.Event.typeInfo);

    @Override
    protected TypeInfo getClassTypeInfo() {
      return typeInfo;
    }

    public java.util.Map<String, com.raritan.idl.peripheral.GatewaySensorManager.ConfigurationPackage> configuration = new java.util.HashMap<>();
  }

  static public class FeedbackObject implements Cloneable {

    public enum FeedbackState {
      UNSPECIFIED,
      INTENTIONALLY_UNUSED,
      FAILED_PRECONDITIONS_UNUSED,
      FAILED,
      GOOD;
    }
    public String key = new String();
    public String value = new String();
    public com.raritan.idl.peripheral.GatewaySensorManager.FeedbackObject.FeedbackState stateTansitionTo = com.raritan.idl.peripheral.GatewaySensorManager.FeedbackObject.FeedbackState.values()[0];

    public Object clone() {
      FeedbackObject copy = new FeedbackObject();

      copy.key = this.key;
      copy.value = this.value;
      copy.stateTansitionTo = this.stateTansitionTo;

      return copy;
    }

  }

  public class Feedback extends com.raritan.json_rpc.ValueObject {

    static public final TypeInfo typeInfo = new TypeInfo("peripheral.GatewaySensorManager.Feedback:1.0.0", com.raritan.json_rpc.ValueObject.typeInfo);

    @Override
    protected TypeInfo getClassTypeInfo() {
      return typeInfo;
    }

    public com.raritan.idl.peripheral.GatewaySensorManager.FeedbackObject.FeedbackState currentState = com.raritan.idl.peripheral.GatewaySensorManager.FeedbackObject.FeedbackState.values()[0];
    public java.util.List<com.raritan.idl.peripheral.GatewaySensorManager.FeedbackObject> infos = new java.util.ArrayList<>();
  }

  public class DeviceFeedback extends com.raritan.idl.peripheral.GatewaySensorManager.Feedback {

    static public final TypeInfo typeInfo = new TypeInfo("peripheral.GatewaySensorManager.DeviceFeedback:1.0.0", com.raritan.idl.peripheral.GatewaySensorManager.Feedback.typeInfo);

    @Override
    protected TypeInfo getClassTypeInfo() {
      return typeInfo;
    }

    public String packageId = new String();
    public String deviceId = new String();
  }

  public class SensorFeedback extends com.raritan.idl.peripheral.GatewaySensorManager.Feedback {

    static public final TypeInfo typeInfo = new TypeInfo("peripheral.GatewaySensorManager.SensorFeedback:1.0.0", com.raritan.idl.peripheral.GatewaySensorManager.Feedback.typeInfo);

    @Override
    protected TypeInfo getClassTypeInfo() {
      return typeInfo;
    }

    public String packageId = new String();
    public String deviceId = new String();
    public String sensorId = new String();
  }

  public class GetFeedbackResult {
    public java.util.List<com.raritan.idl.peripheral.GatewaySensorManager.Feedback> _ret_;
  }

  GetFeedbackResult getFeedback() throws Exception;

  AsyncRequest getFeedback(AsyncRpcResponse<GetFeedbackResult> rsp);

  AsyncRequest getFeedback(AsyncRpcResponse<GetFeedbackResult> rsp, RpcCtrl rpcCtrl);


  public class FeedbackChangedEvent extends com.raritan.idl.idl.Event {

    static public final TypeInfo typeInfo = new TypeInfo("peripheral.GatewaySensorManager.FeedbackChangedEvent:1.0.0", com.raritan.idl.idl.Event.typeInfo);

    @Override
    protected TypeInfo getClassTypeInfo() {
      return typeInfo;
    }

    public java.util.List<com.raritan.idl.peripheral.GatewaySensorManager.Feedback> feedback = new java.util.ArrayList<>();
  }
}
