// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2025 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from DsamPort.idl.

package com.raritan.idl.dsam;

import com.raritan.idl.*;
import com.raritan.util.AsyncRequest;

public interface DsamPort {
  static public final TypeInfo typeInfo = new TypeInfo("dsam.DsamPort:1.0.0", null);

  public static final int SUCCESS = 0;

  public static final int SETTINGS_INVALID = 1;

  public static final int SSH_DPA_PORT_INVALID = 2;

  public static final int SSH_DPA_PORT_IN_USE = 3;

  public enum DeviceInterfaceType {
    DEV_IFTYPE_AUTO,
    DEV_IFTYPE_DTE,
    DEV_IFTYPE_DCE;
  }

  public enum Parity {
    PARITY_NONE,
    PARITY_ODD,
    PARITY_EVEN;
  }

  public enum FlowControl {
    FLOW_CTRL_NONE,
    FLOW_CTRL_HARDWARE,
    FLOW_CTRL_SOFTWARE;
  }

  public enum State {
    STATE_AVAILABLE,
    STATE_OCCUPIED,
    STATE_BUSY;
  }

  static public class Info implements Cloneable {
    public int dsamNumber = 0;
    public int portNumber = 0;
    public boolean connected = false;
    public com.raritan.idl.dsam.DsamPort.DeviceInterfaceType devIfType = com.raritan.idl.dsam.DsamPort.DeviceInterfaceType.values()[0];
    public com.raritan.idl.dsam.DsamPort.State state = com.raritan.idl.dsam.DsamPort.State.values()[0];

    public Object clone() {
      Info copy = new Info();

      copy.dsamNumber = this.dsamNumber;
      copy.portNumber = this.portNumber;
      copy.connected = this.connected;
      copy.devIfType = this.devIfType;
      copy.state = this.state;

      return copy;
    }

  }

  static public class Settings implements Cloneable {
    public String name = new String();
    public com.raritan.idl.dsam.DsamPort.DeviceInterfaceType devIfType = com.raritan.idl.dsam.DsamPort.DeviceInterfaceType.values()[0];
    public int baudRate = 0;
    public com.raritan.idl.dsam.DsamPort.Parity parity = com.raritan.idl.dsam.DsamPort.Parity.values()[0];
    public int stopBits = 0;
    public com.raritan.idl.dsam.DsamPort.FlowControl flowCtrl = com.raritan.idl.dsam.DsamPort.FlowControl.values()[0];
    public int breakDurationMs = 0;
    public boolean sshDpaPortEnabled = false;
    public int sshDpaPort = 0;
    public boolean allowSharedAccess = false;

    public Object clone() {
      Settings copy = new Settings();

      copy.name = this.name;
      copy.devIfType = this.devIfType;
      copy.baudRate = this.baudRate;
      copy.parity = this.parity;
      copy.stopBits = this.stopBits;
      copy.flowCtrl = this.flowCtrl;
      copy.breakDurationMs = this.breakDurationMs;
      copy.sshDpaPortEnabled = this.sshDpaPortEnabled;
      copy.sshDpaPort = this.sshDpaPort;
      copy.allowSharedAccess = this.allowSharedAccess;

      return copy;
    }

  }

  public class InfoChangedEvent extends com.raritan.idl.event.UserEvent {

    static public final TypeInfo typeInfo = new TypeInfo("dsam.DsamPort.InfoChangedEvent:1.0.0", com.raritan.idl.event.UserEvent.typeInfo);

    @Override
    protected TypeInfo getClassTypeInfo() {
      return typeInfo;
    }

    public com.raritan.idl.dsam.DsamPort.Info oldInfo = new com.raritan.idl.dsam.DsamPort.Info();
    public com.raritan.idl.dsam.DsamPort.Info newInfo = new com.raritan.idl.dsam.DsamPort.Info();
    public String portName = new String();
  }

  public class SettingsChangedEvent extends com.raritan.idl.event.UserEvent {

    static public final TypeInfo typeInfo = new TypeInfo("dsam.DsamPort.SettingsChangedEvent:1.0.0", com.raritan.idl.event.UserEvent.typeInfo);

    @Override
    protected TypeInfo getClassTypeInfo() {
      return typeInfo;
    }

    public int dsamNumber = 0;
    public int portNumber = 0;
    public com.raritan.idl.dsam.DsamPort.Settings oldSettings = new com.raritan.idl.dsam.DsamPort.Settings();
    public com.raritan.idl.dsam.DsamPort.Settings newSettings = new com.raritan.idl.dsam.DsamPort.Settings();
  }

  public class GetInfoResult {
    public com.raritan.idl.dsam.DsamPort.Info _ret_;
  }

  GetInfoResult getInfo() throws Exception;

  AsyncRequest getInfo(AsyncRpcResponse<GetInfoResult> rsp);

  AsyncRequest getInfo(AsyncRpcResponse<GetInfoResult> rsp, RpcCtrl rpcCtrl);


  public class GetSettingsResult {
    public com.raritan.idl.dsam.DsamPort.Settings _ret_;
  }

  GetSettingsResult getSettings() throws Exception;

  AsyncRequest getSettings(AsyncRpcResponse<GetSettingsResult> rsp);

  AsyncRequest getSettings(AsyncRpcResponse<GetSettingsResult> rsp, RpcCtrl rpcCtrl);


  public class SetSettingsResult {
    public int _ret_;
  }

  SetSettingsResult setSettings(com.raritan.idl.dsam.DsamPort.Settings settings) throws Exception;

  AsyncRequest setSettings(com.raritan.idl.dsam.DsamPort.Settings settings, AsyncRpcResponse<SetSettingsResult> rsp);

  AsyncRequest setSettings(com.raritan.idl.dsam.DsamPort.Settings settings, AsyncRpcResponse<SetSettingsResult> rsp, RpcCtrl rpcCtrl);


  public class GetTtyUsbNumberResult {
    public int _ret_;
  }

  GetTtyUsbNumberResult getTtyUsbNumber() throws Exception;

  AsyncRequest getTtyUsbNumber(AsyncRpcResponse<GetTtyUsbNumberResult> rsp);

  AsyncRequest getTtyUsbNumber(AsyncRpcResponse<GetTtyUsbNumberResult> rsp, RpcCtrl rpcCtrl);

  Void setState(com.raritan.idl.dsam.DsamPort.State state) throws Exception;

  AsyncRequest setState(com.raritan.idl.dsam.DsamPort.State state, AsyncRpcResponse<Void> rsp);

  AsyncRequest setState(com.raritan.idl.dsam.DsamPort.State state, AsyncRpcResponse<Void> rsp, RpcCtrl rpcCtrl);

}
